/*
 * Decompiled with CFR 0.152.
 */
package io.kk.cloudslang.vertx.util;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.CompositeFuture;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.json.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunMain {
    public static final String BOOT_DEPLOYED = "vertx.deployed";
    public static final String CLASSPATH = "classpath:";
    private static final Logger LOG = LoggerFactory.getLogger(RunMain.class);
    private static final String UTF_8 = "UTF-8";

    public static void main(String ... args) throws IOException {
        JsonObject jsonConf = RunMain.getConfig(args);
        DeploymentOptions deploymentOptions = new DeploymentOptions(jsonConf);
        VertxOptions options = new VertxOptions(jsonConf);
        Vertx vertx = Vertx.vertx((VertxOptions)options);
        vertx.deployVerticle(Boot.class.getName(), deploymentOptions, r -> {
            if (r.succeeded()) {
                LOG.info("Successfully deployed Boot Verticle");
                vertx.eventBus().publish(BOOT_DEPLOYED, (Object)"");
            } else {
                LOG.error("Unable to deploy Boot", r.cause());
                vertx.close();
            }
        });
    }

    private static JsonObject getConfig(String ... args) throws IOException {
        JsonObject json;
        if (args.length == 1) {
            LOG.debug("To read vertx configuration from {}", (Object)args[0]);
            json = args[0].startsWith(CLASSPATH) ? new JsonObject(IOUtils.toString((InputStream)RunMain.class.getResourceAsStream(args[0].substring(CLASSPATH.length())), (String)UTF_8)) : new JsonObject(FileUtils.readFileToString((File)new File(args[0]), (String)UTF_8));
        } else {
            json = new JsonObject(IOUtils.toString((InputStream)RunMain.class.getResourceAsStream("/vertx.json"), (String)UTF_8));
        }
        return json;
    }

    public static class Boot
    extends AbstractVerticle {
        private static final Logger LOG = LoggerFactory.getLogger(Boot.class);

        public void start(Future<Void> startFuture) throws Exception {
            ArrayList fs = new ArrayList();
            this.config().getJsonObject("boot").forEach(e -> {
                Future future = Future.future();
                LOG.debug("To deploy verticle {}", e.getValue());
                this.vertx.deployVerticle(e.getValue().toString(), new DeploymentOptions(this.config().getJsonObject((String)e.getKey())), future.completer());
                fs.add(future);
            });
            CompositeFuture.all(fs).setHandler(r -> {
                if (r.succeeded()) {
                    startFuture.complete();
                    LOG.info("All verticles were deployed");
                } else {
                    startFuture.fail(r.cause());
                }
            });
        }
    }
}

