/*
 * Decompiled with CFR 0.152.
 */
package io.kk.cloudslang.vertx;

import io.cloudslang.lang.api.Slang;
import io.cloudslang.lang.compiler.SlangSource;
import io.cloudslang.lang.entities.SystemProperty;
import io.cloudslang.score.events.ScoreEvent;
import io.kk.cloudslang.vertx.DependenciesLoader;
import io.kk.cloudslang.vertx.ExecResponse;
import io.kk.cloudslang.vertx.ExecResponseCodec;
import io.kk.cloudslang.vertx.FlowParams;
import io.kk.cloudslang.vertx.FlowParamsCodec;
import io.kk.cloudslang.vertx.SystemPropertiesLoader;
import io.kk.cloudslang.vertx.util.Util;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Future;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class CloudSlangService
extends AbstractVerticle {
    public static final String EXEC_FLOW = CloudSlangService.class + ".execflow";
    public static final String EXEC_FLOW_RESPONSE = EXEC_FLOW + "_response";
    public static final String SLANG_EXECUTION_EXCEPTION = "SLANG_EXECUTION_EXCEPTION";
    private static final String EVENT_EXECUTION_FINISHED = "EVENT_EXECUTION_FINISHED";
    private static final String EXECUTION_ID = "EXECUTION_ID";
    private static final Logger LOG = LoggerFactory.getLogger(CloudSlangService.class);
    private Slang slang;
    private File contentPath;
    private List<DependenciesLoader> loaders = new ArrayList<DependenciesLoader>();
    private List<SystemPropertiesLoader> spLoaders = new ArrayList<SystemPropertiesLoader>();

    public void start(Future<Void> startFuture) throws Exception {
        this.loadLoaders("loaders", this.loaders);
        this.loadLoaders("systemPropertiesLoader", this.spLoaders);
        this.vertx.eventBus().registerDefaultCodec(FlowParams.class, (MessageCodec)new FlowParamsCodec());
        this.vertx.eventBus().registerDefaultCodec(ExecResponse.class, (MessageCodec)new ExecResponseCodec());
        this.contentPath = new File(this.getContentPath()).getAbsoluteFile().getCanonicalFile();
        if (!this.contentPath.exists() && !this.contentPath.isDirectory()) {
            LOG.error("Can not find Content Path at {}", (Object)this.contentPath);
            startFuture.fail(this.contentPath + " not existed");
        } else {
            LOG.info("CloudSlang content path is {}", (Object)this.contentPath);
            this.initCloudSlang();
            this.vertx.eventBus().consumer(EXEC_FLOW, this::execFlow);
            super.start(startFuture);
            LOG.info("CloudSlang service Deployed");
        }
    }

    public void stop(Future<Void> stopFuture) throws Exception {
        super.stop(stopFuture);
    }

    private <T> void loadLoaders(String name, List<T> list) {
        this.config().getJsonArray(name, new JsonArray()).forEach(l -> {
            try {
                list.add(Class.forName(l.toString()).newInstance());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                LOG.warn("Unable to load loader " + l, (Throwable)e);
            }
        });
    }

    private void initCloudSlang() {
        ClassPathXmlApplicationContext applicationContext = new ClassPathXmlApplicationContext("/META-INF/spring/context.xml");
        this.slang = (Slang)applicationContext.getBean(Slang.class);
        this.slang.subscribeOnAllEvents(this::handleCloudSlangEvent);
    }

    private void handleCloudSlangEvent(ScoreEvent scoreEvent) {
        LOG.debug("CS event: {}", (Object)scoreEvent.getEventType());
        String type = scoreEvent.getEventType();
        if (LOG.isDebugEnabled()) {
            if (scoreEvent.getEventType().equals("SCORE_FINISHED_EVENT")) {
                LOG.debug("Score finished event={} - data={}", (Object)scoreEvent.getEventType(), (Object)scoreEvent.getData());
            }
            if (scoreEvent.getEventType().equals(SLANG_EXECUTION_EXCEPTION)) {
                LOG.debug("Score finished event={} - data={}", (Object)scoreEvent.getEventType(), (Object)scoreEvent.getData());
            }
        }
        if (type.equals(EVENT_EXECUTION_FINISHED)) {
            Map dataMap = (Map)((Object)scoreEvent.getData());
            long execId = (Long)dataMap.get(EXECUTION_ID);
            String result = dataMap.get("RESULT").toString();
            ExecResponse response = new ExecResponse();
            response.setStatus(result);
            if (response.getStatus().equals("success")) {
                Map outputs = (Map)dataMap.get("OUTPUTS");
                response.setResult(new JsonObject(outputs));
            }
            this.vertx.eventBus().send(execId + ".finished", (Object)response);
        } else if (type.equals(SLANG_EXECUTION_EXCEPTION)) {
            Map dataMap = (Map)((Object)scoreEvent.getData());
            long execId = (Long)dataMap.get(EXECUTION_ID);
            ExecResponse response = new ExecResponse();
            response.setStatus("error");
            response.setErrorReason(dataMap.get("EXCEPTION").toString());
            this.vertx.eventBus().send(execId + ".finished", (Object)response);
        }
    }

    private String getContentPath() {
        return Util.getConfig(this.config(), "CONTENT_PATH", "contentPath");
    }

    private void execFlow(Message<FlowParams> message) {
        FlowParams params = (FlowParams)message.body();
        if (LOG.isDebugEnabled()) {
            LOG.debug("To execute a flow {}", (Object)params.toJson().encodePrettily());
        }
        String name = params.getFlowName();
        String address = EXEC_FLOW_RESPONSE + "_" + params.getExecId();
        File file = this.getContentFile(name, "orc.json");
        LOG.debug("Orchestration {} entry is {}", (Object)name, (Object)file);
        if (!file.exists()) {
            LOG.warn("Flow {} is not found", (Object)name);
            ExecResponse response = new ExecResponse();
            response.setStatus("error");
            response.setStatusCode(500);
            response.setErrorReason("File " + name + " not found");
            this.vertx.eventBus().publish(address, (Object)response);
        } else {
            try {
                JsonObject flowCfg = new JsonObject(FileUtils.readFileToString((File)file, (String)"UTF-8"));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Flow [{}] config - {}", (Object)name, (Object)flowCfg.encodePrettily());
                }
                long slangId = this.slang.compileAndRun(this.getSource(name, flowCfg), this.getDependencies(name, flowCfg), this.getInputs(params.getArgs()), this.getSystemProperties());
                MessageConsumer consumer = this.vertx.eventBus().localConsumer(slangId + ".finished");
                consumer.handler(h -> {
                    ExecResponse response;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Result of execution - {}", (Object)((ExecResponse)h.body()).toJson().encodePrettily());
                    }
                    if ((response = (ExecResponse)h.body()).getStatus().equals("success")) {
                        response.setStatusCode(200);
                    } else {
                        response.setStatusCode(500);
                    }
                    this.vertx.eventBus().publish(address, (Object)response);
                    consumer.unregister();
                });
                consumer.exceptionHandler(ex -> {
                    LOG.warn("Error when executing " + name, ex);
                    ExecResponse response = new ExecResponse();
                    response.setStatus("error");
                    response.setStatusCode(500);
                    response.setErrorReason(ex.toString() + " - " + ex.getMessage());
                    this.vertx.eventBus().publish(address, (Object)response);
                    consumer.unregister();
                });
            }
            catch (Exception e) {
                LOG.error("Unable to execute flow {}", (Object)name);
                LOG.error("Unable to execute flow", (Throwable)e);
                ExecResponse response = new ExecResponse();
                response.setStatus("error");
                response.setStatusCode(500);
                response.setErrorReason(e.toString() + " - " + e.getMessage());
                this.vertx.eventBus().publish(address, (Object)response);
            }
        }
    }

    private Set<SystemProperty> getSystemProperties() {
        HashSet<SystemProperty> props = new HashSet<SystemProperty>();
        this.spLoaders.forEach(l -> props.addAll(l.load(this.config())));
        return props;
    }

    private Map<String, ? extends Serializable> getInputs(JsonObject args) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("args", args.toString());
        return map;
    }

    private Set<SlangSource> getDependencies(String name, JsonObject cfg) {
        LOG.debug("To load dependencies");
        HashSet<SlangSource> depSet = new HashSet<SlangSource>();
        cfg.getJsonArray("dependencies").forEach(o -> {
            String dep = o.toString();
            if (dep.trim().endsWith("/")) {
                LOG.info("Load dependencies from a folder {}", (Object)dep);
                File folder = new File(this.contentPath + "/" + name, dep);
                FileUtils.listFiles((File)folder, (String[])new String[]{"sl"}, (boolean)false).forEach(file -> depSet.add(SlangSource.fromFile((File)file)));
            } else {
                depSet.add(SlangSource.fromFile((File)this.getContentFile(name, dep)));
            }
        });
        this.loaders.forEach(l -> depSet.addAll(l.load(this.config())));
        return depSet;
    }

    private SlangSource getSource(String orcName, JsonObject cfg) {
        return SlangSource.fromFile((File)this.getContentFile(orcName, cfg.getString("source", "main.sl")));
    }

    private File getContentFile(String orcName, String fileName) {
        return new File(this.contentPath, orcName + "/" + fileName);
    }
}

