/*
 * Decompiled with CFR 0.152.
 */
package io.kk.cloudslang.vertx;

import io.kk.cloudslang.vertx.CloudSlangService;
import io.kk.cloudslang.vertx.ExecResponse;
import io.kk.cloudslang.vertx.FlowParams;
import io.kk.cloudslang.vertx.util.Util;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.eventbus.MessageProducer;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudSlangApi
extends AbstractVerticle {
    public static final String CONTENT_TYPE = "application/json";
    public static final String CONTENT_TYPE_UTF_8 = "application/json;charset=UTF-8";
    public static final String NAME = "name";
    private static final Logger LOG = LoggerFactory.getLogger(CloudSlangApi.class);
    private HttpServer server;
    private Router restApi;
    private MessageProducer<FlowParams> publisher;

    public void start(Future<Void> startFuture) throws Exception {
        this.initWebServer();
        super.start(startFuture);
        LOG.info("CloudSlang API Deployed");
    }

    public void stop(Future<Void> stopFuture) throws Exception {
        this.server.close();
        super.stop(stopFuture);
    }

    private void initWebServer() {
        HttpServerOptions options = new HttpServerOptions(this.config().getJsonObject("server"));
        this.server = this.vertx.createHttpServer(options);
        Router mainRouter = Router.router((Vertx)this.vertx);
        this.restApi = Router.router((Vertx)this.vertx);
        mainRouter.mountSubRouter(this.getBaseUrl(), this.restApi);
        this.restApi.route().handler((Handler)BodyHandler.create());
        this.initRestApi(this.restApi);
        this.server.requestHandler(arg_0 -> ((Router)mainRouter).accept(arg_0)).listen();
        this.publisher = this.vertx.eventBus().publisher(CloudSlangService.EXEC_FLOW);
        LOG.info("CloudSlang Vertx API listening at {}", (Object)options.getPort());
    }

    private void initRestApi(Router restApi) {
        restApi.post("/:name").consumes(CONTENT_TYPE).produces(CONTENT_TYPE_UTF_8).useNormalisedPath(true).handler(this::runFlow);
    }

    private void runFlow(RoutingContext routingContext) {
        JsonObject data;
        try {
            data = routingContext.getBodyAsJson();
        }
        catch (DecodeException e) {
            LOG.error("Unable to read post body", (Throwable)e);
            routingContext.response().setStatusCode(400).end();
            return;
        }
        FlowParams params = new FlowParams(data);
        params.setFlowName(routingContext.request().getParam(NAME));
        String id = UUID.randomUUID().toString();
        data.put("execId", id);
        params.setExecId(id);
        this.waitForResponse(id, routingContext);
        this.publisher.send((Object)params);
    }

    private void waitForResponse(String execId, RoutingContext routingContext) {
        String address = CloudSlangService.EXEC_FLOW_RESPONSE + "_" + execId;
        MessageConsumer consumer = this.vertx.eventBus().consumer(address);
        consumer.handler(h -> {
            try {
                ExecResponse response = (ExecResponse)h.body();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Got exec response {}", (Object)response.toJson().encodePrettily());
                }
                routingContext.response().setStatusCode(response.getStatusCode()).putHeader("Content-Type", CONTENT_TYPE_UTF_8).end(response.toJson().toString());
            }
            finally {
                consumer.unregister();
            }
        });
        consumer.exceptionHandler(ex -> {
            LOG.error("Unable to consume message {}", (Object)address);
            LOG.error("Error received", ex);
            routingContext.response().setStatusCode(500).end(ex.getMessage());
            consumer.unregister();
        });
    }

    private String getBaseUrl() {
        return Util.getConfig(this.config(), "BASE_URL", "baseUrl");
    }
}

