/*
 * Decompiled with CFR 0.152.
 */
package io.keen.client.java;

import io.keen.client.java.AlwaysConnectedNetworkStatusHandler;
import io.keen.client.java.Environment;
import io.keen.client.java.GlobalPropertiesEvaluator;
import io.keen.client.java.KeenAttemptCountingEventStore;
import io.keen.client.java.KeenCallback;
import io.keen.client.java.KeenDetailedCallback;
import io.keen.client.java.KeenEventStore;
import io.keen.client.java.KeenJsonHandler;
import io.keen.client.java.KeenLogging;
import io.keen.client.java.KeenNetworkStatusHandler;
import io.keen.client.java.KeenProject;
import io.keen.client.java.KeenUtils;
import io.keen.client.java.RamEventStore;
import io.keen.client.java.exceptions.InvalidEventCollectionException;
import io.keen.client.java.exceptions.InvalidEventException;
import io.keen.client.java.exceptions.NoWriteKeyException;
import io.keen.client.java.exceptions.ServerException;
import io.keen.client.java.http.HttpHandler;
import io.keen.client.java.http.OutputSource;
import io.keen.client.java.http.Request;
import io.keen.client.java.http.Response;
import io.keen.client.java.http.UrlConnectionHttpHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class KeenClient {
    private static final DateFormat ISO_8601_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.US);
    private final HttpHandler httpHandler;
    private final KeenJsonHandler jsonHandler;
    private final KeenEventStore eventStore;
    private final Executor publishExecutor;
    private final KeenNetworkStatusHandler networkStatusHandler;
    private final Object attemptsLock = new Object();
    private boolean isActive = true;
    private boolean isDebugMode;
    private int maxAttempts = 3;
    private KeenProject defaultProject;
    private String baseUrl;
    private GlobalPropertiesEvaluator globalPropertiesEvaluator;
    private Map<String, Object> globalProperties;
    private Proxy proxy;
    private static final String ENCODING = "UTF-8";

    public static KeenClient client() {
        if (ClientSingleton.INSTANCE.client == null) {
            throw new IllegalStateException("Please call KeenClient.initialize() before requesting the client.");
        }
        return ClientSingleton.INSTANCE.client;
    }

    public static void initialize(KeenClient client) {
        if (client == null) {
            throw new IllegalArgumentException("Client must not be null");
        }
        if (ClientSingleton.INSTANCE.client != null) {
            return;
        }
        ClientSingleton.INSTANCE.client = client;
    }

    public static boolean isInitialized() {
        return ClientSingleton.INSTANCE.client != null;
    }

    public void addEvent(String eventCollection, Map<String, Object> event) {
        this.addEvent(eventCollection, event, null);
    }

    public void addEvent(String eventCollection, Map<String, Object> event, Map<String, Object> keenProperties) {
        this.addEvent(null, eventCollection, event, keenProperties, null);
    }

    public void addEvent(KeenProject project, String eventCollection, Map<String, Object> event, Map<String, Object> keenProperties, KeenCallback callback) {
        if (!this.isActive) {
            this.handleLibraryInactive(callback);
            return;
        }
        if (project == null && this.defaultProject == null) {
            this.handleFailure(null, project, eventCollection, event, keenProperties, new IllegalStateException("No project specified, but no default project found"));
            return;
        }
        KeenProject useProject = project == null ? this.defaultProject : project;
        try {
            Map<String, Object> newEvent = this.validateAndBuildEvent(useProject, eventCollection, event, keenProperties);
            this.publish(useProject, eventCollection, newEvent);
            this.handleSuccess(callback, project, eventCollection, event, keenProperties);
        }
        catch (Exception e) {
            this.handleFailure(callback, project, eventCollection, event, keenProperties, e);
        }
    }

    public void addEventAsync(String eventCollection, Map<String, Object> event) {
        this.addEventAsync(eventCollection, event, null);
    }

    public void addEventAsync(String eventCollection, Map<String, Object> event, Map<String, Object> keenProperties) {
        this.addEventAsync(null, eventCollection, event, keenProperties, null);
    }

    public void addEventAsync(KeenProject project, final String eventCollection, final Map<String, Object> event, final Map<String, Object> keenProperties, final KeenCallback callback) {
        if (!this.isActive) {
            this.handleLibraryInactive(callback);
            return;
        }
        if (project == null && this.defaultProject == null) {
            this.handleFailure(null, project, eventCollection, event, keenProperties, new IllegalStateException("No project specified, but no default project found"));
            return;
        }
        final KeenProject useProject = project == null ? this.defaultProject : project;
        try {
            this.publishExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    KeenClient.this.addEvent(useProject, eventCollection, event, keenProperties, callback);
                }
            });
        }
        catch (Exception e) {
            this.handleFailure(callback, project, eventCollection, event, keenProperties, e);
        }
    }

    public void queueEvent(String eventCollection, Map<String, Object> event) {
        this.queueEvent(eventCollection, event, null);
    }

    public void queueEvent(String eventCollection, Map<String, Object> event, Map<String, Object> keenProperties) {
        this.queueEvent(null, eventCollection, event, keenProperties, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueEvent(KeenProject project, String eventCollection, Map<String, Object> event, Map<String, Object> keenProperties, KeenCallback callback) {
        if (!this.isActive) {
            this.handleLibraryInactive(callback);
            return;
        }
        if (project == null && this.defaultProject == null) {
            this.handleFailure(null, project, eventCollection, event, keenProperties, new IllegalStateException("No project specified, but no default project found"));
            return;
        }
        KeenProject useProject = project == null ? this.defaultProject : project;
        try {
            block9: {
                Map<String, Object> newEvent = this.validateAndBuildEvent(useProject, eventCollection, event, keenProperties);
                StringWriter writer = new StringWriter();
                this.jsonHandler.writeJson(writer, newEvent);
                String jsonEvent = writer.toString();
                KeenUtils.closeQuietly(writer);
                try {
                    Object handle = this.eventStore.store(useProject.getProjectId(), eventCollection, jsonEvent);
                    if (!(this.eventStore instanceof KeenAttemptCountingEventStore)) break block9;
                    Object object = this.attemptsLock;
                    synchronized (object) {
                        Map<String, Integer> attempts = this.getAttemptsMap(useProject.getProjectId(), eventCollection);
                        attempts.put("" + handle.hashCode(), this.maxAttempts);
                        this.setAttemptsMap(useProject.getProjectId(), eventCollection, attempts);
                    }
                }
                catch (IOException ex) {
                    KeenLogging.log("Failed to set the event POST attempt count. The event was still queued and will we POSTed.");
                }
            }
            this.handleSuccess(callback, project, eventCollection, event, keenProperties);
        }
        catch (Exception e) {
            this.handleFailure(callback, project, eventCollection, event, keenProperties, e);
        }
    }

    public void sendQueuedEvents() {
        this.sendQueuedEvents(null);
    }

    public void sendQueuedEvents(KeenProject project) {
        this.sendQueuedEvents(project, null);
    }

    public synchronized void sendQueuedEvents(KeenProject project, KeenCallback callback) {
        if (!this.isActive) {
            this.handleLibraryInactive(callback);
            return;
        }
        if (project == null && this.defaultProject == null) {
            this.handleFailure(null, new IllegalStateException("No project specified, but no default project found"));
            return;
        }
        if (!this.isNetworkConnected()) {
            KeenLogging.log("Not sending events because there is no network connection. Events will be retried next time `sendQueuedEvents` is called.");
            this.handleFailure(callback, new Exception("Network not connected."));
            return;
        }
        KeenProject useProject = project == null ? this.defaultProject : project;
        try {
            String projectId = useProject.getProjectId();
            Map<String, List<Object>> eventHandles = this.eventStore.getHandles(projectId);
            Map<String, List<Map<String, Object>>> events = this.buildEventMap(projectId, eventHandles);
            String response = this.publishAll(useProject, events);
            if (response != null) {
                try {
                    this.handleAddEventsResponse(eventHandles, response);
                }
                catch (Exception e) {
                    KeenLogging.log("Error handling response to batch publish: " + e.getMessage());
                }
            }
            this.handleSuccess(callback);
        }
        catch (Exception e) {
            this.handleFailure(callback, e);
        }
    }

    public void sendQueuedEventsAsync() {
        this.sendQueuedEventsAsync(null);
    }

    public void sendQueuedEventsAsync(KeenProject project) {
        this.sendQueuedEventsAsync(project, null);
    }

    public void sendQueuedEventsAsync(KeenProject project, final KeenCallback callback) {
        if (!this.isActive) {
            this.handleLibraryInactive(callback);
            return;
        }
        if (project == null && this.defaultProject == null) {
            this.handleFailure(null, new IllegalStateException("No project specified, but no default project found"));
            return;
        }
        final KeenProject useProject = project == null ? this.defaultProject : project;
        try {
            this.publishExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    KeenClient.this.sendQueuedEvents(useProject, callback);
                }
            });
        }
        catch (Exception e) {
            this.handleFailure(callback, e);
        }
    }

    public KeenJsonHandler getJsonHandler() {
        return this.jsonHandler;
    }

    public KeenEventStore getEventStore() {
        return this.eventStore;
    }

    public Executor getPublishExecutor() {
        return this.publishExecutor;
    }

    public KeenProject getDefaultProject() {
        return this.defaultProject;
    }

    public void setDefaultProject(KeenProject defaultProject) {
        this.defaultProject = defaultProject;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl == null ? "https://api.keen.io" : baseUrl;
    }

    public void setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public GlobalPropertiesEvaluator getGlobalPropertiesEvaluator() {
        return this.globalPropertiesEvaluator;
    }

    public void setGlobalPropertiesEvaluator(GlobalPropertiesEvaluator globalPropertiesEvaluator) {
        this.globalPropertiesEvaluator = globalPropertiesEvaluator;
    }

    public Map<String, Object> getGlobalProperties() {
        return this.globalProperties;
    }

    public void setGlobalProperties(Map<String, Object> globalProperties) {
        this.globalProperties = globalProperties;
    }

    public boolean isDebugMode() {
        return this.isDebugMode;
    }

    public void setDebugMode(boolean isDebugMode) {
        this.isDebugMode = isDebugMode;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setProxy(String proxyHost, int proxyPort) {
        this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    protected KeenClient(Builder builder) {
        this(builder, new Environment());
    }

    KeenClient(Builder builder, Environment env) {
        this.httpHandler = builder.httpHandler;
        this.jsonHandler = builder.jsonHandler;
        this.eventStore = builder.eventStore;
        this.publishExecutor = builder.publishExecutor;
        this.networkStatusHandler = builder.networkStatusHandler;
        if (this.httpHandler == null || this.jsonHandler == null || this.eventStore == null || this.publishExecutor == null) {
            this.setActive(false);
        }
        this.baseUrl = "https://api.keen.io";
        this.globalPropertiesEvaluator = null;
        this.globalProperties = null;
        if (env.getKeenProjectId() != null) {
            this.defaultProject = new KeenProject(env);
        }
    }

    protected void setActive(boolean isActive) {
        this.isActive = isActive;
        KeenLogging.log("Keen Client set to " + (isActive ? "active" : "inactive"));
    }

    protected Map<String, Object> validateAndBuildEvent(KeenProject project, String eventCollection, Map<String, Object> event, Map<String, Object> keenProperties) {
        GlobalPropertiesEvaluator globalPropertiesEvaluator;
        if (project.getWriteKey() == null) {
            throw new NoWriteKeyException("You can't send events to Keen if you haven't set a write key.");
        }
        this.validateEventCollection(eventCollection);
        this.validateEvent(event);
        KeenLogging.log(String.format(Locale.US, "Adding event to collection: %s", eventCollection));
        HashMap<String, Object> newEvent = new HashMap<String, Object>();
        HashMap<String, Object> mergedKeenProperties = new HashMap<String, Object>();
        if (null != this.globalProperties) {
            this.mergeGlobalProperties(this.getGlobalProperties(), mergedKeenProperties, newEvent);
        }
        if ((globalPropertiesEvaluator = this.getGlobalPropertiesEvaluator()) != null) {
            this.mergeGlobalProperties(globalPropertiesEvaluator.getGlobalProperties(eventCollection), mergedKeenProperties, newEvent);
        }
        if (keenProperties != null) {
            mergedKeenProperties.putAll(keenProperties);
        }
        if (!mergedKeenProperties.containsKey("timestamp")) {
            Calendar currentTime = Calendar.getInstance();
            String timestamp = ISO_8601_FORMAT.format(currentTime.getTime());
            mergedKeenProperties.put("timestamp", timestamp);
        }
        newEvent.put("keen", mergedKeenProperties);
        newEvent.putAll(event);
        return newEvent;
    }

    private void mergeGlobalProperties(Map<String, Object> globalProperties, Map<String, Object> keenProperties, Map<String, Object> newEvent) {
        if (globalProperties != null) {
            Object keen = (globalProperties = new HashMap<String, Object>(globalProperties)).remove("keen");
            if (keen instanceof Map) {
                keenProperties.putAll((Map)keen);
            }
            newEvent.putAll(globalProperties);
        }
    }

    private void validateEventCollection(String eventCollection) {
        if (eventCollection == null || eventCollection.length() == 0) {
            throw new InvalidEventCollectionException("You must specify a non-null, non-empty event collection: " + eventCollection);
        }
        if (eventCollection.length() > 256) {
            throw new InvalidEventCollectionException("An event collection name cannot be longer than 256 characters.");
        }
    }

    private void validateEvent(Map<String, Object> event) {
        this.validateEvent(event, 0);
    }

    private void validateEvent(Map<String, Object> event, int depth) {
        if (depth == 0) {
            if (event == null || event.size() == 0) {
                throw new InvalidEventException("You must specify a non-null, non-empty event.");
            }
            if (event.containsKey("keen")) {
                throw new InvalidEventException("An event cannot contain a root-level property named 'keen'.");
            }
        } else if (depth > 1000) {
            throw new InvalidEventException("An event's depth (i.e. layers of nesting) cannot exceed 1000");
        }
        for (Map.Entry<String, Object> entry : event.entrySet()) {
            String key = entry.getKey();
            if (key.contains(".")) {
                throw new InvalidEventException("An event cannot contain a property with the period (.) character in it.");
            }
            if (key.length() > 256) {
                throw new InvalidEventException("An event cannot contain a property name longer than 256 characters.");
            }
            this.validateEventValue(entry.getValue(), depth);
        }
    }

    private void validateEventValue(Object value, int depth) {
        if (value instanceof String) {
            String strValue = (String)value;
            if (strValue.length() >= 10000) {
                throw new InvalidEventException("An event cannot contain a string property value longer than 10,000 characters.");
            }
        } else if (value instanceof Map) {
            this.validateEvent((Map)value, depth + 1);
        } else if (value instanceof Iterable) {
            for (Object listElement : (Iterable)value) {
                this.validateEventValue(listElement, depth);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<Map<String, Object>>> buildEventMap(String projectId, Map<String, List<Object>> eventHandles) throws IOException {
        HashMap<String, List<Map<String, Object>>> result = new HashMap<String, List<Map<String, Object>>>();
        for (Map.Entry<String, List<Object>> entry : eventHandles.entrySet()) {
            String eventCollection = entry.getKey();
            List<Object> handles = entry.getValue();
            if (handles == null || handles.size() == 0) continue;
            ArrayList<Map<String, Object>> events = new ArrayList<Map<String, Object>>(handles.size());
            if (this.eventStore instanceof KeenAttemptCountingEventStore) {
                Object object = this.attemptsLock;
                synchronized (object) {
                    Map<String, Integer> attempts;
                    try {
                        attempts = this.getAttemptsMap(projectId, eventCollection);
                    }
                    catch (IOException ex) {
                        attempts = new HashMap<String, Integer>();
                        KeenLogging.log("Failed to read attempt counts map. Events will still be POSTed. Exception: " + ex);
                    }
                    for (Object handle : handles) {
                        Map<String, Object> event = this.getEvent(handle);
                        String attemptsKey = "" + handle.hashCode();
                        Integer remainingAttempts = attempts.get(attemptsKey);
                        if (remainingAttempts == null) {
                            remainingAttempts = 1;
                        }
                        Integer n = remainingAttempts;
                        Integer n2 = remainingAttempts = Integer.valueOf(remainingAttempts - 1);
                        attempts.put(attemptsKey, remainingAttempts);
                        if (remainingAttempts >= 0) {
                            events.add(event);
                            continue;
                        }
                        this.eventStore.remove(handle);
                        attempts.remove(attemptsKey);
                    }
                    try {
                        this.setAttemptsMap(projectId, eventCollection, attempts);
                    }
                    catch (IOException ex) {
                        KeenLogging.log("Failed to update event POST attempts counts while sending queued events. Events will still be POSTed. Exception: " + ex);
                    }
                }
            }
            for (Object handle : handles) {
                events.add(this.getEvent(handle));
            }
            result.put(eventCollection, events);
        }
        return result;
    }

    private String publish(KeenProject project, String eventCollection, Map<String, Object> event) throws IOException {
        URL url = this.createURL(project, eventCollection);
        if (url == null) {
            throw new IllegalStateException("URL address is empty");
        }
        return this.publishObject(project, url, event);
    }

    private URL createURL(KeenProject project, String eventCollection) {
        try {
            String encodedCollectionName = new URI(null, null, eventCollection, null).getRawPath();
            String path = String.format(Locale.US, "%s/%s/projects/%s/events/%s", this.getBaseUrl(), "3.0", project.getProjectId(), encodedCollectionName);
            return new URL(path);
        }
        catch (URISyntaxException e) {
            KeenLogging.log("Event collection name has invalid character to encode", e);
        }
        catch (MalformedURLException e) {
            KeenLogging.log("Url you create is malformed or there is not legal protocol in string you specified", e);
        }
        return null;
    }

    private String publishAll(KeenProject project, Map<String, List<Map<String, Object>>> events) throws IOException {
        String urlString = String.format(Locale.US, "%s/%s/projects/%s/events", this.getBaseUrl(), "3.0", project.getProjectId());
        URL url = new URL(urlString);
        return this.publishObject(project, url, events);
    }

    private synchronized String publishObject(KeenProject project, URL url, final Map<String, ?> requestData) throws IOException {
        Object request;
        if (requestData == null || requestData.size() == 0) {
            KeenLogging.log("No API calls were made because there were no events to upload");
            return null;
        }
        OutputSource source = new OutputSource(){

            @Override
            public void writeTo(OutputStream out) throws IOException {
                OutputStreamWriter writer = new OutputStreamWriter(out, KeenClient.ENCODING);
                KeenClient.this.jsonHandler.writeJson(writer, requestData);
            }
        };
        if (KeenLogging.isLoggingEnabled()) {
            try {
                StringWriter writer = new StringWriter();
                this.jsonHandler.writeJson(writer, requestData);
                request = writer.toString();
                KeenLogging.log(String.format(Locale.US, "Sent request '%s' to URL '%s'", request, url.toString()));
            }
            catch (IOException e) {
                KeenLogging.log("Couldn't log event written to file: ", e);
            }
        }
        String writeKey = project.getWriteKey();
        request = new Request(url, "POST", writeKey, source, this.proxy);
        Response response = this.httpHandler.execute((Request)request);
        if (KeenLogging.isLoggingEnabled()) {
            KeenLogging.log(String.format(Locale.US, "Received response: '%s' (%d)", response.body, response.statusCode));
        }
        if (response.isSuccess()) {
            return response.body;
        }
        throw new ServerException(response.body);
    }

    private boolean isNetworkConnected() {
        return this.networkStatusHandler.isNetworkConnected();
    }

    private void handleAddEventsResponse(Map<String, List<Object>> handles, String response) throws IOException {
        StringReader reader = new StringReader(response);
        Map<String, Object> responseMap = this.jsonHandler.readJson(reader);
        for (Map.Entry<String, Object> entry : responseMap.entrySet()) {
            String collectionName = entry.getKey();
            List<Object> collectionHandles = handles.get(collectionName);
            List eventResults = (List)entry.getValue();
            int index = 0;
            for (Map eventResult : eventResults) {
                boolean removeCacheEntry = true;
                boolean success = (Boolean)eventResult.get("success");
                if (!success) {
                    Map errorDict = (Map)eventResult.get("error");
                    String errorCode = (String)errorDict.get("name");
                    if (errorCode.equals("InvalidCollectionNameError") || errorCode.equals("InvalidPropertyNameError") || errorCode.equals("InvalidPropertyValueError")) {
                        removeCacheEntry = true;
                        KeenLogging.log("An invalid event was found. Deleting it. Error: " + errorDict.get("description"));
                    } else {
                        String description = (String)errorDict.get("description");
                        removeCacheEntry = false;
                        KeenLogging.log(String.format(Locale.US, "The event could not be inserted for some reason. Error name and description: %s %s", errorCode, description));
                    }
                }
                if (removeCacheEntry) {
                    Object handle = collectionHandles.get(index);
                    try {
                        this.eventStore.remove(handle);
                    }
                    catch (IOException e) {
                        KeenLogging.log("Failed to remove object '" + handle + "' from cache");
                    }
                }
                ++index;
            }
        }
    }

    private void handleSuccess(KeenCallback callback) {
        if (callback != null) {
            try {
                callback.onSuccess();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void handleSuccess(KeenCallback callback, KeenProject project, String eventCollection, Map<String, Object> event, Map<String, Object> keenProperties) {
        this.handleSuccess(callback);
        if (callback != null) {
            try {
                if (callback instanceof KeenDetailedCallback) {
                    ((KeenDetailedCallback)callback).onSuccess(project, eventCollection, event, keenProperties);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void handleFailure(KeenCallback callback, Exception e) {
        if (this.isDebugMode) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        KeenLogging.log("Encountered error: " + e.getMessage());
        if (callback != null) {
            try {
                callback.onFailure(e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void handleFailure(KeenCallback callback, KeenProject project, String eventCollection, Map<String, Object> event, Map<String, Object> keenProperties, Exception e) {
        if (this.isDebugMode) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        this.handleFailure(callback, e);
        KeenLogging.log("Encountered error: " + e.getMessage());
        if (callback != null) {
            try {
                if (callback instanceof KeenDetailedCallback) {
                    ((KeenDetailedCallback)callback).onFailure(project, eventCollection, event, keenProperties, e);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void handleLibraryInactive(KeenCallback callback) {
        this.handleFailure(callback, new IllegalStateException("The Keen library failed to initialize properly and is inactive"));
    }

    private Map<String, Object> getEvent(Object handle) throws IOException {
        String jsonEvent = this.eventStore.get(handle);
        StringReader reader = new StringReader(jsonEvent);
        Map<String, Object> event = this.jsonHandler.readJson(reader);
        KeenUtils.closeQuietly(reader);
        return event;
    }

    private Map<String, Integer> getAttemptsMap(String projectId, String eventCollection) throws IOException {
        KeenAttemptCountingEventStore res;
        String attemptsJSON;
        HashMap<String, Integer> attempts = new HashMap<String, Integer>();
        if (this.eventStore instanceof KeenAttemptCountingEventStore && (attemptsJSON = (res = (KeenAttemptCountingEventStore)this.eventStore).getAttempts(projectId, eventCollection)) != null) {
            StringReader reader = new StringReader(attemptsJSON);
            Map<String, Object> attemptTmp = this.jsonHandler.readJson(reader);
            for (Map.Entry<String, Object> entry : attemptTmp.entrySet()) {
                if (!(entry.getValue() instanceof Number)) continue;
                attempts.put(entry.getKey(), ((Number)entry.getValue()).intValue());
            }
        }
        return attempts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAttemptsMap(String projectId, String eventCollection, Map<String, Integer> attempts) throws IOException {
        if (this.eventStore instanceof KeenAttemptCountingEventStore) {
            KeenAttemptCountingEventStore res = (KeenAttemptCountingEventStore)this.eventStore;
            StringWriter writer = null;
            try {
                writer = new StringWriter();
                this.jsonHandler.writeJson(writer, attempts);
                String attemptsJSON = writer.toString();
                res.setAttempts(projectId, eventCollection, attemptsJSON);
            }
            finally {
                KeenUtils.closeQuietly(writer);
            }
        }
    }

    private static enum ClientSingleton {
        INSTANCE;

        KeenClient client;
    }

    public static abstract class Builder {
        private HttpHandler httpHandler;
        private KeenJsonHandler jsonHandler;
        private KeenEventStore eventStore;
        private Executor publishExecutor;
        private KeenNetworkStatusHandler networkStatusHandler;

        protected HttpHandler getDefaultHttpHandler() throws Exception {
            return new UrlConnectionHttpHandler();
        }

        public HttpHandler getHttpHandler() {
            return this.httpHandler;
        }

        public void setHttpHandler(HttpHandler httpHandler) {
            this.httpHandler = httpHandler;
        }

        public Builder withHttpHandler(HttpHandler httpHandler) {
            this.setHttpHandler(httpHandler);
            return this;
        }

        protected abstract KeenJsonHandler getDefaultJsonHandler() throws Exception;

        public KeenJsonHandler getJsonHandler() {
            return this.jsonHandler;
        }

        public void setJsonHandler(KeenJsonHandler jsonHandler) {
            this.jsonHandler = jsonHandler;
        }

        public Builder withJsonHandler(KeenJsonHandler jsonHandler) {
            this.setJsonHandler(jsonHandler);
            return this;
        }

        protected KeenEventStore getDefaultEventStore() throws Exception {
            return new RamEventStore();
        }

        public KeenEventStore getEventStore() {
            return this.eventStore;
        }

        public void setEventStore(KeenEventStore eventStore) {
            this.eventStore = eventStore;
        }

        public Builder withEventStore(KeenEventStore eventStore) {
            this.setEventStore(eventStore);
            return this;
        }

        protected Executor getDefaultPublishExecutor() throws Exception {
            int procCount = Runtime.getRuntime().availableProcessors();
            return Executors.newFixedThreadPool(procCount);
        }

        public Executor getPublishExecutor() {
            return this.publishExecutor;
        }

        public void setPublishExecutor(Executor publishExecutor) {
            this.publishExecutor = publishExecutor;
        }

        public Builder withPublishExecutor(Executor publishExecutor) {
            this.setPublishExecutor(publishExecutor);
            return this;
        }

        protected KeenNetworkStatusHandler getDefaultNetworkStatusHandler() {
            return new AlwaysConnectedNetworkStatusHandler();
        }

        public KeenNetworkStatusHandler getNetworkStatusHandler() {
            return this.networkStatusHandler;
        }

        public void setNetworkStatusHandler(KeenNetworkStatusHandler networkStatusHandler) {
            this.networkStatusHandler = networkStatusHandler;
        }

        public Builder withNetworkStatusHandler(KeenNetworkStatusHandler networkStatusHandler) {
            this.setNetworkStatusHandler(networkStatusHandler);
            return this;
        }

        public KeenClient build() {
            try {
                if (this.httpHandler == null) {
                    this.httpHandler = this.getDefaultHttpHandler();
                }
            }
            catch (Exception e) {
                KeenLogging.log("Exception building HTTP handler: " + e.getMessage());
            }
            try {
                if (this.jsonHandler == null) {
                    this.jsonHandler = this.getDefaultJsonHandler();
                }
            }
            catch (Exception e) {
                KeenLogging.log("Exception building JSON handler: " + e.getMessage());
            }
            try {
                if (this.eventStore == null) {
                    this.eventStore = this.getDefaultEventStore();
                }
            }
            catch (Exception e) {
                KeenLogging.log("Exception building event store: " + e.getMessage());
            }
            try {
                if (this.publishExecutor == null) {
                    this.publishExecutor = this.getDefaultPublishExecutor();
                }
            }
            catch (Exception e) {
                KeenLogging.log("Exception building publish executor: " + e.getMessage());
            }
            try {
                if (this.networkStatusHandler == null) {
                    this.networkStatusHandler = this.getDefaultNetworkStatusHandler();
                }
            }
            catch (Exception e) {
                KeenLogging.log("Exception building network status handler: " + e.getMessage());
            }
            return this.buildInstance();
        }

        protected KeenClient buildInstance() {
            return new KeenClient(this);
        }
    }
}

