/*
 * Decompiled with CFR 0.152.
 */
package io.keen.client.java;

import io.keen.client.java.Environment;

public class KeenProject {
    private final String projectId;
    private final String readKey;
    private final String writeKey;
    private final String masterKey;

    public KeenProject() {
        this(new Environment());
    }

    KeenProject(Environment env) {
        this(env.getKeenProjectId(), env.getKeenWriteKey(), env.getKeenReadKey());
    }

    public KeenProject(String projectId, String writeKey, String readKey) {
        this(projectId, writeKey, readKey, null);
    }

    public KeenProject(String projectId, String writeKey, String readKey, String masterKey) {
        if (null == projectId || projectId.trim().isEmpty()) {
            throw new IllegalArgumentException("Invalid project id specified: " + projectId);
        }
        if (!(null != writeKey && !writeKey.trim().isEmpty() || null != readKey && !readKey.trim().isEmpty() || null != masterKey && !masterKey.trim().isEmpty())) {
            throw new IllegalArgumentException("At least one of the keys given must be non-null and non-empty.");
        }
        this.projectId = projectId;
        this.writeKey = writeKey;
        this.readKey = readKey;
        this.masterKey = masterKey;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getReadKey() {
        return this.readKey;
    }

    public String getWriteKey() {
        return this.writeKey;
    }

    public String getMasterKey() {
        return this.masterKey;
    }
}

