/*
 * Decompiled with CFR 0.152.
 */
package io.keen.client.java;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;

public class KeenLogging {
    private static final Logger LOGGER = Logger.getLogger(KeenLogging.class.getName());
    private static final StreamHandler HANDLER = new StreamHandler(System.out, new SimpleFormatter());

    static void log(String msg) {
        if (KeenLogging.isLoggingEnabled()) {
            LOGGER.log(Level.FINER, msg);
            HANDLER.flush();
        }
    }

    public static void enableLogging() {
        KeenLogging.setLogLevel(Level.FINER);
    }

    public static void disableLogging() {
        KeenLogging.setLogLevel(Level.OFF);
    }

    public static void disableDefaultLogHandler() {
        LOGGER.removeHandler(HANDLER);
    }

    public static boolean isLoggingEnabled() {
        return LOGGER.getLevel() == Level.FINER;
    }

    private static void setLogLevel(Level newLevel) {
        LOGGER.setLevel(newLevel);
        for (Handler handler : LOGGER.getHandlers()) {
            try {
                handler.setLevel(newLevel);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }

    static {
        LOGGER.addHandler(HANDLER);
        KeenLogging.disableLogging();
    }
}

