/*
 * Decompiled with CFR 0.152.
 */
package io.keen.client.java;

import io.keen.client.java.KeenAttemptCountingEventStore;
import io.keen.client.java.KeenLogging;
import io.keen.client.java.KeenUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class FileEventStore
implements KeenAttemptCountingEventStore {
    private static final String ENCODING = "UTF-8";
    private static final int MAX_EVENTS_PER_COLLECTION = 10000;
    private static final int NUMBER_EVENTS_TO_FORGET = 100;
    private static final String ATTEMPTS_JSON_FILE_NAME = "__attempts.json";
    private final File root;

    public FileEventStore(File root) throws IOException {
        if (!root.exists() || !root.isDirectory()) {
            throw new IOException("Event store root '" + root + "' must exist and be a directory");
        }
        this.root = root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object store(String projectId, String eventCollection, String event) throws IOException {
        File collectionCacheDir = this.prepareCollectionDir(projectId, eventCollection);
        Calendar timestamp = Calendar.getInstance();
        File cacheFile = this.getFileForEvent(collectionCacheDir, timestamp);
        OutputStreamWriter writer = null;
        try {
            FileOutputStream out = new FileOutputStream(cacheFile);
            writer = new OutputStreamWriter((OutputStream)out, ENCODING);
            writer.write(event);
        }
        catch (Throwable throwable) {
            KeenUtils.closeQuietly(writer);
            throw throwable;
        }
        KeenUtils.closeQuietly(writer);
        return cacheFile;
    }

    @Override
    public String get(Object handle) throws IOException {
        if (!(handle instanceof File)) {
            throw new IllegalArgumentException("Expected File, but was " + handle.getClass());
        }
        File eventFile = (File)handle;
        if (eventFile.exists() && eventFile.isFile()) {
            return KeenUtils.convertFileToString(eventFile);
        }
        return null;
    }

    @Override
    public void remove(Object handle) throws IOException {
        if (!(handle instanceof File)) {
            throw new IllegalArgumentException("Expected File, but was " + handle.getClass());
        }
        File eventFile = (File)handle;
        if (eventFile.exists() && eventFile.isFile()) {
            if (eventFile.delete()) {
                KeenLogging.log(String.format(Locale.US, "Successfully deleted file: %s", eventFile.getAbsolutePath()));
            } else {
                KeenLogging.log(String.format(Locale.US, "CRITICAL ERROR: Could not remove event at %s", eventFile.getAbsolutePath()));
            }
        } else {
            KeenLogging.log(String.format(Locale.US, "WARNING: no event found at %s", eventFile.getAbsolutePath()));
        }
    }

    @Override
    public Map<String, List<Object>> getHandles(String projectId) throws IOException {
        File projectDir = this.getProjectDir(projectId, false);
        if (projectDir.exists() && projectDir.isDirectory()) {
            return this.getHandlesFromProjectDirectory(projectDir);
        }
        return new HashMap<String, List<Object>>();
    }

    @Override
    public String getAttempts(String projectId, String eventCollection) throws IOException {
        File projectDir = this.getProjectDir(projectId, false);
        File collectionDir = new File(projectDir, eventCollection);
        File attemptsFile = new File(collectionDir, ATTEMPTS_JSON_FILE_NAME);
        return this.get(attemptsFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttempts(String projectId, String eventCollection, String attemptsString) throws IOException {
        File collectionCacheDir = this.prepareCollectionDir(projectId, eventCollection);
        File cacheFile = new File(collectionCacheDir, ATTEMPTS_JSON_FILE_NAME);
        FileOutputStream out = new FileOutputStream(cacheFile);
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)out, ENCODING);
            writer.write(attemptsString);
        }
        catch (Throwable throwable) {
            KeenUtils.closeQuietly(writer);
            throw throwable;
        }
        KeenUtils.closeQuietly(writer);
    }

    private Map<String, List<Object>> getHandlesFromProjectDirectory(File projectDir) throws IOException {
        File[] collectionDirs = this.getSubDirectories(projectDir);
        HashMap<String, List<Object>> handleMap = new HashMap<String, List<Object>>();
        if (collectionDirs != null) {
            for (File directory : collectionDirs) {
                String collectionName = directory.getName();
                File[] files = this.getFilesInDir(directory);
                if (files != null) {
                    ArrayList<File> handleList = new ArrayList<File>();
                    handleList.addAll(Arrays.asList(files));
                    handleMap.put(collectionName, handleList);
                    continue;
                }
                KeenLogging.log("Directory was null while getting event handles: " + collectionName);
            }
        }
        return handleMap;
    }

    private File getKeenCacheDirectory() throws IOException {
        boolean dirMade;
        File file = new File(this.root, "keen");
        if (!file.exists() && !(dirMade = file.mkdir())) {
            throw new IOException("Could not make keen cache directory at: " + file.getAbsolutePath());
        }
        return file;
    }

    private File[] getSubDirectories(File parent) throws IOException {
        return parent.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
    }

    private File[] getFilesInDir(File dir) {
        return dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && !file.getName().equals(FileEventStore.ATTEMPTS_JSON_FILE_NAME);
            }
        });
    }

    private File getProjectDir(String projectId, boolean create) throws IOException {
        File projectDir = new File(this.getKeenCacheDirectory(), projectId);
        if (create && !projectDir.exists()) {
            KeenLogging.log("Cache directory for project '" + projectId + "' doesn't exist. " + "Creating it.");
            if (!projectDir.mkdirs()) {
                throw new IOException("Could not create project cache directory '" + projectDir.getAbsolutePath() + "'");
            }
        }
        return projectDir;
    }

    private File getCollectionDir(String projectId, String eventCollection) throws IOException {
        File collectionDir = new File(this.getProjectDir(projectId, true), eventCollection);
        if (!collectionDir.exists()) {
            KeenLogging.log("Cache directory for event collection '" + eventCollection + "' doesn't exist. Creating it.");
            if (!collectionDir.mkdirs()) {
                throw new IOException("Could not create collection cache directory '" + collectionDir.getAbsolutePath() + "'");
            }
        }
        return collectionDir;
    }

    private File getFileForEvent(File collectionDir, Calendar timestamp) throws IOException {
        int counter = 0;
        File eventFile = this.getNextFileForEvent(collectionDir, timestamp, counter);
        while (eventFile.exists()) {
            eventFile = this.getNextFileForEvent(collectionDir, timestamp, counter);
            ++counter;
        }
        return eventFile;
    }

    private File getNextFileForEvent(File dir, Calendar timestamp, int counter) {
        long timestampInMillis = timestamp.getTimeInMillis();
        String name = Long.toString(timestampInMillis);
        return new File(dir, name + "." + counter);
    }

    private int getMaxEventsPerCollection() {
        return 10000;
    }

    private int getNumberEventsToForget() {
        return 100;
    }

    private File prepareCollectionDir(String projectId, String eventCollection) throws IOException {
        File collectionDir = this.getCollectionDir(projectId, eventCollection);
        File[] eventFiles = this.getFilesInDir(collectionDir);
        if (eventFiles.length >= this.getMaxEventsPerCollection()) {
            KeenLogging.log(String.format(Locale.US, "Too many events in cache for %s, aging out old data", eventCollection));
            KeenLogging.log(String.format(Locale.US, "Count: %d and Max: %d", eventFiles.length, this.getMaxEventsPerCollection()));
            List<File> fileList = Arrays.asList(eventFiles);
            Collections.sort(fileList, new Comparator<File>(){

                @Override
                public int compare(File file, File file1) {
                    return file.getAbsolutePath().compareToIgnoreCase(file1.getAbsolutePath());
                }
            });
            for (int i = 0; i < this.getNumberEventsToForget(); ++i) {
                File f = fileList.get(i);
                if (f.delete()) continue;
                KeenLogging.log(String.format(Locale.US, "CRITICAL: can't delete file %s, cache is going to be too big", f.getAbsolutePath()));
            }
        }
        return collectionDir;
    }
}

