/*
 * Decompiled with CFR 0.152.
 */
package io.keen.client.java;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;

public class KeenLogging {
    private static final Logger LOGGER = Logger.getLogger(KeenLogging.class.getName());

    static void log(String msg) {
        LOGGER.log(Level.FINER, msg);
    }

    public static void enableLogging() {
        KeenLogging.setLogLevel(Level.FINER);
    }

    public static void disableLogging() {
        KeenLogging.setLogLevel(Level.OFF);
    }

    public static boolean isLoggingEnabled() {
        return LOGGER.getLevel() == Level.FINER;
    }

    private static void setLogLevel(Level newLevel) {
        LOGGER.setLevel(newLevel);
        for (Handler handler : LOGGER.getHandlers()) {
            handler.setLevel(newLevel);
        }
    }

    static {
        LOGGER.addHandler(new StreamHandler(System.out, new SimpleFormatter()));
        KeenLogging.disableLogging();
    }
}

