/*
 * Decompiled with CFR 0.152.
 */
package io.keen.client.java;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.keen.client.java.AddEventCallback;
import io.keen.client.java.GlobalPropertiesEvaluator;
import io.keen.client.java.KeenConfig;
import io.keen.client.java.KeenHttpRequestRunnable;
import io.keen.client.java.KeenLogging;
import io.keen.client.java.exceptions.InvalidEventCollectionException;
import io.keen.client.java.exceptions.InvalidEventException;
import io.keen.client.java.exceptions.KeenException;
import io.keen.client.java.exceptions.NoWriteKeyException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class KeenClient {
    static final ObjectMapper MAPPER = new ObjectMapper();
    static final ExecutorService EXECUTOR_SERVICE;
    private final String projectId;
    private final String writeKey;
    private final String readKey;
    private GlobalPropertiesEvaluator globalPropertiesEvaluator;
    private Map<String, Object> globalProperties;

    public static void initialize(String projectId, String writeKey, String readKey) {
        ClientSingleton.INSTANCE.client = new KeenClient(projectId, writeKey, readKey);
    }

    public static KeenClient client() {
        if (ClientSingleton.INSTANCE.client == null) {
            throw new IllegalStateException("Please call KeenClient.initialize() before requesting the shared client.");
        }
        return ClientSingleton.INSTANCE.client;
    }

    public KeenClient(String projectId, String writeKey, String readKey) {
        if (projectId == null || projectId.length() == 0) {
            throw new IllegalArgumentException("Invalid project id specified: " + projectId);
        }
        this.projectId = projectId;
        this.writeKey = writeKey;
        this.readKey = readKey;
        this.globalPropertiesEvaluator = null;
        this.globalProperties = null;
    }

    public void addEvent(String eventCollection, Map<String, Object> event) throws KeenException {
        this.addEvent(eventCollection, event, null, null);
    }

    public void addEvent(String eventCollection, Map<String, Object> event, Map<String, Object> keenProperties, AddEventCallback callback) throws KeenException {
        Map<String, Object> newEvent = this.validateAndBuildEvent(eventCollection, event, keenProperties);
        this.processRunnableInNewThread(new KeenHttpRequestRunnable(this, eventCollection, newEvent, callback));
    }

    Map<String, Object> validateAndBuildEvent(String eventCollection, Map<String, Object> event, Map<String, Object> keenProperties) throws KeenException {
        Map<String, Object> props;
        GlobalPropertiesEvaluator globalPropertiesEvaluator;
        if (this.getWriteKey() == null) {
            throw new NoWriteKeyException("You can't send events to Keen IO if you haven't set a write key.");
        }
        this.validateEventCollection(eventCollection);
        this.validateEvent(event);
        KeenLogging.log(String.format("Adding event to collection: %s", eventCollection));
        HashMap<String, Object> newEvent = new HashMap<String, Object>();
        Calendar timestamp = Calendar.getInstance();
        if (keenProperties == null) {
            keenProperties = new HashMap<String, Object>();
            keenProperties.put("timestamp", timestamp);
        } else if (!keenProperties.containsKey("timestamp")) {
            keenProperties.put("timestamp", timestamp);
        }
        newEvent.put("keen", keenProperties);
        Map<String, Object> globalProperties = this.getGlobalProperties();
        if (globalProperties != null) {
            newEvent.putAll(globalProperties);
        }
        if ((globalPropertiesEvaluator = this.getGlobalPropertiesEvaluator()) != null && (props = globalPropertiesEvaluator.getGlobalProperties(eventCollection)) != null) {
            newEvent.putAll(props);
        }
        newEvent.putAll(event);
        return newEvent;
    }

    private void validateEventCollection(String eventCollection) throws InvalidEventCollectionException {
        if (eventCollection == null || eventCollection.length() == 0) {
            throw new InvalidEventCollectionException("You must specify a non-null, non-empty event collection: " + eventCollection);
        }
        if (eventCollection.startsWith("$")) {
            throw new InvalidEventCollectionException("An event collection name cannot start with the dollar sign ($) character.");
        }
        if (eventCollection.length() > 256) {
            throw new InvalidEventCollectionException("An event collection name cannot be longer than 256 characters.");
        }
    }

    private void validateEvent(Map<String, Object> event) throws InvalidEventException {
        this.validateEvent(event, 0);
    }

    private void validateEvent(Map<String, Object> event, int depth) throws InvalidEventException {
        if (depth == 0) {
            if (event == null || event.size() == 0) {
                throw new InvalidEventException("You must specify a non-null, non-empty event.");
            }
            if (event.containsKey("keen")) {
                throw new InvalidEventException("An event cannot contain a root-level property named 'keen'.");
            }
        }
        for (Map.Entry<String, Object> entry : event.entrySet()) {
            String key = entry.getKey();
            if (key.contains(".")) {
                throw new InvalidEventException("An event cannot contain a property with the period (.) character in it.");
            }
            if (key.startsWith("$")) {
                throw new InvalidEventException("An event cannot contain a property that starts with the dollar sign ($) character in it.");
            }
            if (key.length() > 256) {
                throw new InvalidEventException("An event cannot contain a property name longer than 256 characters.");
            }
            Object value = entry.getValue();
            if (value instanceof String) {
                String strValue = (String)value;
                if (strValue.length() < 10000) continue;
                throw new InvalidEventException("An event cannot contain a string property value longer than 10,000 characters.");
            }
            if (!(value instanceof Map)) continue;
            this.validateEvent((Map)value, depth + 1);
        }
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getWriteKey() {
        return this.writeKey;
    }

    public String getReadKey() {
        return this.readKey;
    }

    public GlobalPropertiesEvaluator getGlobalPropertiesEvaluator() {
        return this.globalPropertiesEvaluator;
    }

    public void setGlobalPropertiesEvaluator(GlobalPropertiesEvaluator globalPropertiesEvaluator) {
        this.globalPropertiesEvaluator = globalPropertiesEvaluator;
    }

    public Map<String, Object> getGlobalProperties() {
        return this.globalProperties;
    }

    public void setGlobalProperties(Map<String, Object> globalProperties) {
        this.globalProperties = globalProperties;
    }

    public void processRunnableInNewThread(Runnable runnable) {
        EXECUTOR_SERVICE.submit(runnable);
    }

    static {
        MAPPER.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        EXECUTOR_SERVICE = Executors.newFixedThreadPool(KeenConfig.NUM_THREADS_FOR_HTTP_REQUESTS);
    }

    private static enum ClientSingleton {
        INSTANCE;

        private KeenClient client;
    }
}

