/*
 * Decompiled with CFR 0.152.
 */
package io.keen.client.android;

import android.os.Build;
import io.keen.client.android.JsonHelper;
import io.keen.client.java.KeenJsonHandler;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AndroidJsonHandler
implements KeenJsonHandler {
    private static final int COPY_BUFFER_SIZE = 4096;
    private boolean isWrapNestedMapsAndCollections = Build.VERSION.SDK_INT < 19;
    private JsonObjectManager jsonObjectManager = null;

    public Map<String, Object> readJson(Reader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException("Reader must not be null");
        }
        String json = AndroidJsonHandler.readerToString(reader);
        try {
            JSONObject jsonObject = new JSONObject(json);
            return JsonHelper.toMap(jsonObject);
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
    }

    public void writeJson(Writer writer, Map<String, ?> value) throws IOException {
        if (writer == null) {
            throw new IllegalArgumentException("Writer must not be null");
        }
        JSONObject jsonObject = this.convertMapToJSONObject(value);
        writer.write(this.getJsonObjectManager().stringify(jsonObject));
        writer.close();
    }

    public void setWrapNestedMapsAndCollections(boolean value) {
        this.isWrapNestedMapsAndCollections = value;
    }

    protected void setJsonObjectManager(JsonObjectManager jsonObjectManager) {
        this.jsonObjectManager = jsonObjectManager;
    }

    private JsonObjectManager getJsonObjectManager() {
        if (this.jsonObjectManager == null) {
            this.jsonObjectManager = new AndroidJsonObjectManager();
        }
        return this.jsonObjectManager;
    }

    private JSONObject convertMapToJSONObject(Map map) throws IOException {
        HashMap newMap;
        if (this.isWrapNestedMapsAndCollections && AndroidJsonHandler.requiresWrap(map)) {
            newMap = new HashMap();
            for (Object key : map.keySet()) {
                Object value;
                Object newValue = value = map.get(key);
                if (value instanceof Map) {
                    newValue = this.convertMapToJSONObject((Map)value);
                } else if (value instanceof Collection) {
                    newValue = this.convertCollectionToJSONArray((Collection)value);
                } else if (value instanceof Object[]) {
                    newValue = this.convertCollectionToJSONArray(Arrays.asList((Object[])value));
                }
                newMap.put(key, newValue);
            }
        } else {
            newMap = map;
        }
        return this.getJsonObjectManager().newObject(newMap);
    }

    private JSONArray convertCollectionToJSONArray(Collection collection) throws IOException {
        ArrayList newCollection;
        if (this.isWrapNestedMapsAndCollections && AndroidJsonHandler.requiresWrap(collection)) {
            newCollection = new ArrayList();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object value;
                Object newValue = value = iterator.next();
                if (value instanceof Map) {
                    newValue = this.convertMapToJSONObject((Map)value);
                } else if (value instanceof Collection) {
                    newValue = this.convertCollectionToJSONArray((Collection)value);
                }
                newCollection.add(newValue);
            }
        } else {
            newCollection = collection;
        }
        return this.getJsonObjectManager().newArray(newCollection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readerToString(Reader reader) throws IOException {
        StringWriter writer = new StringWriter();
        try {
            int bytesRead;
            char[] buffer = new char[4096];
            while ((bytesRead = reader.read(buffer)) != -1) {
                writer.write(buffer, 0, bytesRead);
            }
            String string = writer.toString();
            return string;
        }
        finally {
            reader.close();
        }
    }

    private static boolean requiresWrap(Map map) {
        for (Object value : map.values()) {
            if (!(value instanceof Collection) && !(value instanceof Map) && !(value instanceof Object[])) continue;
            return true;
        }
        return false;
    }

    private static boolean requiresWrap(Collection collection) {
        for (Object value : collection) {
            if (!(value instanceof Collection) && !(value instanceof Map)) continue;
            return true;
        }
        return false;
    }

    private static class AndroidJsonObjectManager
    implements JsonObjectManager {
        private AndroidJsonObjectManager() {
        }

        @Override
        public String stringify(JSONObject object) {
            return object.toString();
        }

        @Override
        public JSONObject newObject(Map<String, ?> map) {
            return new JSONObject(map);
        }

        @Override
        public JSONArray newArray(Collection<?> collection) {
            return new JSONArray(collection);
        }
    }

    protected static interface JsonObjectManager {
        public String stringify(JSONObject var1);

        public JSONObject newObject(Map<String, ?> var1);

        public JSONArray newArray(Collection<?> var1);
    }
}

