/*
 * Decompiled with CFR 0.152.
 */
package io.keen.client.android;

import android.os.Build;
import io.keen.client.android.JsonHelper;
import io.keen.client.java.KeenJsonHandler;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AndroidJsonHandler
implements KeenJsonHandler {
    private static final int COPY_BUFFER_SIZE = 4096;
    private boolean isWrapNestedMapsAndCollections = Build.VERSION.SDK_INT < 19;

    @Override
    public Map<String, Object> readJson(Reader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException("Reader must not be null");
        }
        String json = AndroidJsonHandler.readerToString(reader);
        try {
            JSONObject jsonObject = new JSONObject(json);
            return JsonHelper.toMap(jsonObject);
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeJson(Writer writer, Map<String, ?> value) throws IOException {
        if (writer == null) {
            throw new IllegalArgumentException("Writer must not be null");
        }
        JSONObject jsonObject = this.convertMapToJSONObject(value);
        writer.write(jsonObject.toString());
        writer.close();
    }

    public void setWrapNestedMapsAndCollections(boolean value) {
        this.isWrapNestedMapsAndCollections = value;
    }

    private JSONObject convertMapToJSONObject(Map map) throws IOException {
        HashMap newMap = null;
        if (this.isWrapNestedMapsAndCollections && AndroidJsonHandler.requiresWrap(map)) {
            newMap = new HashMap();
            for (Object key : map.keySet()) {
                Object value;
                Object newValue = value = map.get(key);
                if (value instanceof Map) {
                    newValue = this.convertMapToJSONObject((Map)value);
                } else if (value instanceof Collection) {
                    newValue = this.convertCollectionToJSONArray((Collection)value);
                }
                newMap.put(key, newValue);
            }
        } else {
            newMap = map;
        }
        return new JSONObject((Map)newMap);
    }

    private JSONArray convertCollectionToJSONArray(Collection collection) throws IOException {
        ArrayList newCollection = null;
        if (this.isWrapNestedMapsAndCollections && AndroidJsonHandler.requiresWrap(collection)) {
            newCollection = new ArrayList();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object value;
                Object newValue = value = iterator.next();
                if (value instanceof Map) {
                    newValue = this.convertMapToJSONObject((Map)value);
                } else if (value instanceof Collection) {
                    newValue = this.convertCollectionToJSONArray((Collection)value);
                }
                newCollection.add(newValue);
            }
        } else {
            newCollection = collection;
        }
        return new JSONArray((Collection)newCollection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readerToString(Reader reader) throws IOException {
        StringWriter writer = new StringWriter();
        try {
            int bytesRead;
            char[] buffer = new char[4096];
            while ((bytesRead = reader.read(buffer)) != -1) {
                writer.write(buffer, 0, bytesRead);
            }
            String string = writer.toString();
            return string;
        }
        finally {
            reader.close();
        }
    }

    private static boolean requiresWrap(Map map) {
        for (Object value : map.values()) {
            if (!(value instanceof Collection) && !(value instanceof Map)) continue;
            return true;
        }
        return false;
    }

    private static boolean requiresWrap(Collection collection) {
        for (Object value : collection) {
            if (!(value instanceof Collection) && !(value instanceof Map)) continue;
            return true;
        }
        return false;
    }
}

