/*
 * Decompiled with CFR 0.152.
 */
package io.keen.client.android;

import io.keen.client.android.JsonHelper;
import io.keen.client.java.KeenJsonHandler;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

class AndroidJsonHandler
implements KeenJsonHandler {
    private static final int COPY_BUFFER_SIZE = 4096;

    AndroidJsonHandler() {
    }

    @Override
    public Map<String, Object> readJson(Reader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException("Reader must not be null");
        }
        String json = AndroidJsonHandler.readerToString(reader);
        try {
            JSONObject jsonObject = new JSONObject(json);
            return JsonHelper.toMap(jsonObject);
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeJson(Writer writer, Map<String, ?> value) throws IOException {
        if (writer == null) {
            throw new IllegalArgumentException("Reader must not be null");
        }
        JSONObject jsonObject = new JSONObject(value);
        writer.write(jsonObject.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readerToString(Reader reader) throws IOException {
        StringWriter writer = new StringWriter();
        try {
            int bytesRead;
            char[] buffer = new char[4096];
            while ((bytesRead = reader.read(buffer)) != -1) {
                writer.write(buffer, 0, bytesRead);
            }
            String string = writer.toString();
            return string;
        }
        finally {
            reader.close();
        }
    }
}

