/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.client.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import io.katharsis.client.KatharsisClient;
import io.katharsis.client.QuerySpecResourceRepositoryStub;
import io.katharsis.client.ResourceRepositoryStub;
import io.katharsis.client.internal.AbstractStub;
import io.katharsis.client.response.ResourceList;
import io.katharsis.queryParams.QueryParams;
import io.katharsis.queryspec.QuerySpec;
import io.katharsis.queryspec.internal.QueryAdapter;
import io.katharsis.queryspec.internal.QueryParamsAdapter;
import io.katharsis.queryspec.internal.QuerySpecAdapter;
import io.katharsis.request.path.JsonPath;
import io.katharsis.request.path.ResourcePath;
import io.katharsis.resource.information.ResourceInformation;
import io.katharsis.response.BaseResponseContext;
import io.katharsis.response.CollectionResponseContext;
import io.katharsis.response.JsonApiResponse;
import io.katharsis.response.ResourceResponseContext;
import io.katharsis.utils.JsonApiUrlBuilder;
import java.io.Serializable;
import java.util.List;

public class ResourceRepositoryStubImpl<T, ID extends Serializable>
extends AbstractStub
implements ResourceRepositoryStub<T, ID>,
QuerySpecResourceRepositoryStub<T, ID> {
    private ResourceInformation resourceInformation;
    private Class<T> resourceClass;

    public ResourceRepositoryStubImpl(KatharsisClient client, Class<T> resourceClass, ResourceInformation resourceInformation, JsonApiUrlBuilder urlBuilder) {
        super(client, urlBuilder);
        this.resourceClass = resourceClass;
        this.resourceInformation = resourceInformation;
    }

    private BaseResponseContext executePost(HttpUrl requestUrl, T resource, QueryAdapter queryAdapter) {
        String requestBodyValue;
        JsonApiResponse response = new JsonApiResponse();
        response.setEntity(resource);
        ResourcePath jsonPath = new ResourcePath(this.resourceInformation.getResourceType());
        ResourceResponseContext context = new ResourceResponseContext(response, (JsonPath)jsonPath, queryAdapter);
        ObjectMapper objectMapper = this.katharsis.getObjectMapper();
        try {
            requestBodyValue = objectMapper.writeValueAsString((Object)context);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
        Request.Builder builder = new Request.Builder().url(requestUrl);
        builder = builder.post(RequestBody.create(null, (String)requestBodyValue));
        return this.execute(builder, true);
    }

    public T findOne(ID id, QueryParams queryParams) {
        HttpUrl url = HttpUrl.parse((String)this.urlBuilder.buildUrl(this.resourceClass, id, queryParams));
        return this.findOne(url);
    }

    @Override
    public List<T> findAll(QueryParams queryParams) {
        HttpUrl url = HttpUrl.parse((String)this.urlBuilder.buildUrl(this.resourceClass, null, queryParams));
        return this.findAll(url);
    }

    @Override
    public List<T> findAll(Iterable<ID> ids, QueryParams queryParams) {
        HttpUrl url = HttpUrl.parse((String)this.urlBuilder.buildUrl(this.resourceClass, ids, queryParams));
        return this.findAll(url);
    }

    @Override
    public <S extends T> S save(S entity) {
        return this.save(entity, new QueryParams());
    }

    @Override
    public <S extends T> S save(S entity, QueryParams queryParams) {
        Object id = null;
        HttpUrl url = HttpUrl.parse((String)this.urlBuilder.buildUrl(this.resourceClass, id, (QuerySpec)null));
        BaseResponseContext context = this.executePost(url, entity, (QueryAdapter)new QueryParamsAdapter(queryParams));
        return (S)context.getResponse().getEntity();
    }

    public void delete(ID id) {
        HttpUrl url = HttpUrl.parse((String)this.urlBuilder.buildUrl(this.resourceClass, id, (QuerySpec)null));
        this.executeDelete(url);
    }

    public Class<T> getResourceClass() {
        return this.resourceClass;
    }

    public T findOne(ID id, QuerySpec querySpec) {
        HttpUrl url = HttpUrl.parse((String)this.urlBuilder.buildUrl(this.resourceClass, id, querySpec));
        return this.findOne(url);
    }

    @Override
    public ResourceList<T> findAll(QuerySpec querySpec) {
        HttpUrl url = HttpUrl.parse((String)this.urlBuilder.buildUrl(this.resourceClass, null, querySpec));
        return this.findAll(url);
    }

    @Override
    public ResourceList<T> findAll(Iterable<ID> ids, QuerySpec queryPaquerySpecrams) {
        HttpUrl url = HttpUrl.parse((String)this.urlBuilder.buildUrl(this.resourceClass, ids, queryPaquerySpecrams));
        return this.findAll(url);
    }

    private ResourceList<T> findAll(HttpUrl url) {
        BaseResponseContext responseContext = this.executeGet(url);
        if (responseContext instanceof CollectionResponseContext) {
            CollectionResponseContext colResponseContext = (CollectionResponseContext)responseContext;
            return this.toList(colResponseContext.getResponse());
        }
        return this.toList(responseContext.getResponse());
    }

    private T findOne(HttpUrl url) {
        BaseResponseContext responseContext = this.executeGet(url);
        return (T)responseContext.getResponse().getEntity();
    }

    @Override
    public <S extends T> S save(S entity, QuerySpec querySpec) {
        Object id = null;
        HttpUrl url = HttpUrl.parse((String)this.urlBuilder.buildUrl(this.resourceClass, id, (QuerySpec)null));
        BaseResponseContext context = this.executePost(url, entity, (QueryAdapter)new QuerySpecAdapter(querySpec, this.katharsis.getRegistry()));
        return (S)context.getResponse().getEntity();
    }
}

