/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.client.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import io.katharsis.client.ClientException;
import io.katharsis.client.KatharsisClient;
import io.katharsis.client.response.ResourceList;
import io.katharsis.errorhandling.ErrorResponse;
import io.katharsis.errorhandling.mapper.ExceptionMapper;
import io.katharsis.errorhandling.mapper.ExceptionMapperRegistry;
import io.katharsis.response.BaseResponseContext;
import io.katharsis.response.JsonApiResponse;
import io.katharsis.response.LinksInformation;
import io.katharsis.response.MetaInformation;
import io.katharsis.utils.JsonApiUrlBuilder;
import io.katharsis.utils.java.Optional;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class AbstractStub {
    private static final String CONTENT_TYPE = "application/vnd.api+json";
    protected KatharsisClient katharsis;
    protected JsonApiUrlBuilder urlBuilder;

    public AbstractStub(KatharsisClient client, JsonApiUrlBuilder urlBuilder) {
        this.katharsis = client;
        this.urlBuilder = urlBuilder;
    }

    protected BaseResponseContext executeGet(HttpUrl requestUrl) {
        Request.Builder builder = new Request.Builder().url(requestUrl);
        return this.execute(builder, true);
    }

    protected BaseResponseContext executeDelete(HttpUrl requestUrl) {
        Request.Builder builder = new Request.Builder().url(requestUrl);
        builder.delete();
        return this.execute(builder, false);
    }

    protected <T> ResourceList<T> toList(JsonApiResponse response) {
        Object entity = response.getEntity();
        List<Object> list = entity instanceof List ? (List<Object>)entity : Arrays.asList(entity);
        LinksInformation linksInformation = response.getLinksInformation();
        MetaInformation metaInformation = response.getMetaInformation();
        return new ResourceList<Object>(list, linksInformation, metaInformation);
    }

    protected BaseResponseContext execute(Request.Builder builder, boolean getResponse) {
        try {
            Request.Builder complementedBuilder = builder.header("Content-Type", CONTENT_TYPE).header("Accept", CONTENT_TYPE);
            Request request = complementedBuilder.build();
            Response response = this.katharsis.getHttpClient().newCall(request).execute();
            if (!response.isSuccessful()) {
                this.handleError(response);
            }
            String body = response.body().string();
            ObjectMapper objectMapper = this.katharsis.getObjectMapper();
            if (getResponse) {
                return (BaseResponseContext)objectMapper.readValue(body, BaseResponseContext.class);
            }
            return null;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private void handleError(Response response) throws IOException {
        String body = response.body().string();
        ErrorResponse errorResponse = null;
        if (body.length() > 0) {
            ObjectMapper objectMapper = this.katharsis.getObjectMapper();
            errorResponse = (ErrorResponse)objectMapper.readValue(body, ErrorResponse.class);
        }
        errorResponse = errorResponse != null ? new ErrorResponse((Iterable)errorResponse.getResponse().getEntity(), response.code()) : new ErrorResponse(null, response.code());
        ExceptionMapperRegistry exceptionMapperRegistry = this.katharsis.getExceptionMapperRegistry();
        Optional mapper = exceptionMapperRegistry.findMapperFor(errorResponse);
        if (mapper.isPresent()) {
            Throwable throwable = ((ExceptionMapper)mapper.get()).fromErrorResponse(errorResponse);
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new ClientException(response.code(), response.message(), throwable);
        }
        throw new ClientException(response.code(), response.message());
    }
}

