/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.client;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.squareup.okhttp.OkHttpClient;
import io.katharsis.client.QuerySpecRelationshipRepositoryStub;
import io.katharsis.client.QuerySpecResourceRepositoryStub;
import io.katharsis.client.RelationshipRepositoryStub;
import io.katharsis.client.ResourceRepositoryStub;
import io.katharsis.client.internal.BaseResponseDeserializer;
import io.katharsis.client.internal.ErrorResponseDeserializer;
import io.katharsis.client.internal.RelationshipRepositoryStubImpl;
import io.katharsis.client.internal.ResourceRepositoryStubImpl;
import io.katharsis.errorhandling.ErrorResponse;
import io.katharsis.errorhandling.mapper.ExceptionMapperLookup;
import io.katharsis.errorhandling.mapper.ExceptionMapperRegistry;
import io.katharsis.errorhandling.mapper.ExceptionMapperRegistryBuilder;
import io.katharsis.jackson.JsonApiModuleBuilder;
import io.katharsis.module.CoreModule;
import io.katharsis.module.Module;
import io.katharsis.module.ModuleRegistry;
import io.katharsis.repository.RelationshipRepository;
import io.katharsis.repository.RepositoryInstanceBuilder;
import io.katharsis.resource.field.ResourceField;
import io.katharsis.resource.field.ResourceFieldNameTransformer;
import io.katharsis.resource.information.ResourceInformation;
import io.katharsis.resource.registry.ConstantServiceUrlProvider;
import io.katharsis.resource.registry.RegistryEntry;
import io.katharsis.resource.registry.ResourceLookup;
import io.katharsis.resource.registry.ResourceRegistry;
import io.katharsis.resource.registry.ServiceUrlProvider;
import io.katharsis.resource.registry.repository.DirectResponseRelationshipEntry;
import io.katharsis.resource.registry.repository.DirectResponseResourceEntry;
import io.katharsis.resource.registry.repository.ResourceEntry;
import io.katharsis.resource.registry.responseRepository.RelationshipRepositoryAdapter;
import io.katharsis.resource.registry.responseRepository.ResourceRepositoryAdapter;
import io.katharsis.response.BaseResponseContext;
import io.katharsis.utils.JsonApiUrlBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Set;

public class KatharsisClient {
    private OkHttpClient client = new OkHttpClient();
    private ObjectMapper objectMapper;
    private ResourceRegistry resourceRegistry;
    private ModuleRegistry moduleRegistry;
    private JsonApiUrlBuilder urlBuilder;
    private boolean initialized = false;
    private ExceptionMapperRegistry exceptionMapperRegistry;

    public KatharsisClient(String serviceUrl, String resourceSearchPackage) {
        this.resourceRegistry = new ResourceRegistry((ServiceUrlProvider)new ConstantServiceUrlProvider(KatharsisClient.normalize(serviceUrl)));
        this.urlBuilder = new JsonApiUrlBuilder(this.resourceRegistry);
        this.objectMapper = new ObjectMapper();
        this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        this.moduleRegistry = new ModuleRegistry();
        this.moduleRegistry.addModule((Module)new CoreModule(resourceSearchPackage, new ResourceFieldNameTransformer()));
        JsonApiModuleBuilder moduleBuilder = new JsonApiModuleBuilder();
        SimpleModule jsonApiModule = moduleBuilder.build(this.resourceRegistry, true);
        jsonApiModule.addDeserializer(BaseResponseContext.class, (JsonDeserializer)new BaseResponseDeserializer(this.resourceRegistry, this.objectMapper));
        jsonApiModule.addDeserializer(ErrorResponse.class, (JsonDeserializer)new ErrorResponseDeserializer());
        this.objectMapper.registerModule((com.fasterxml.jackson.databind.Module)jsonApiModule);
    }

    private static String normalize(String serviceUrl) {
        if (serviceUrl.endsWith("/")) {
            return serviceUrl.substring(0, serviceUrl.length() - 1);
        }
        return serviceUrl;
    }

    protected void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.initModuleRegistry();
        this.initRepositories();
        this.initExceptionMapperRegistry();
    }

    private void initModuleRegistry() {
        this.moduleRegistry.init(this.objectMapper, this.resourceRegistry);
    }

    private void initRepositories() {
        ResourceLookup resourceLookup = this.moduleRegistry.getResourceLookup();
        Set resourceClasses = resourceLookup.getResourceClasses();
        for (Class resourceClass : resourceClasses) {
            this.allocateRepository(resourceClass);
        }
    }

    private void initExceptionMapperRegistry() {
        ExceptionMapperLookup exceptionMapperLookup = this.moduleRegistry.getExceptionMapperLookup();
        this.exceptionMapperRegistry = new ExceptionMapperRegistryBuilder().build(exceptionMapperLookup);
    }

    private <T, ID extends Serializable> void allocateRepository(Class<T> resourceClass) {
        ResourceInformation resourceInformation = this.moduleRegistry.getResourceInformationBuilder().build(resourceClass);
        final ResourceRepositoryStubImpl repositoryStub = new ResourceRepositoryStubImpl(this, resourceClass, resourceInformation, this.urlBuilder);
        RepositoryInstanceBuilder repositoryInstanceBuilder = new RepositoryInstanceBuilder(null, null){

            public Object buildRepository() {
                return repositoryStub;
            }
        };
        DirectResponseResourceEntry resourceEntry = new DirectResponseResourceEntry(repositoryInstanceBuilder);
        Set relationshipFields = resourceInformation.getRelationshipFields();
        ArrayList<3> relationshipEntries = new ArrayList<3>();
        RegistryEntry registryEntry = new RegistryEntry(resourceInformation, (ResourceEntry)resourceEntry, relationshipEntries);
        for (ResourceField relationshipField : relationshipFields) {
            final Class targetClass = relationshipField.getElementType();
            final RelationshipRepositoryStubImpl relationshipRepositoryStub = new RelationshipRepositoryStubImpl(this, resourceClass, targetClass, resourceInformation, this.urlBuilder, registryEntry);
            RepositoryInstanceBuilder<RelationshipRepository> relationshipRepositoryInstanceBuilder = new RepositoryInstanceBuilder<RelationshipRepository>(null, null){

                public RelationshipRepository buildRepository() {
                    return relationshipRepositoryStub;
                }
            };
            DirectResponseRelationshipEntry relationshipEntry = new DirectResponseRelationshipEntry((RepositoryInstanceBuilder)relationshipRepositoryInstanceBuilder){

                public Class<?> getTargetAffiliation() {
                    return targetClass;
                }
            };
            relationshipEntries.add(relationshipEntry);
        }
        this.resourceRegistry.addEntry(resourceClass, registryEntry);
    }

    public <T, ID extends Serializable> ResourceRepositoryStub<T, ID> getRepository(Class<T> resourceClass) {
        this.init();
        RegistryEntry entry = this.resourceRegistry.getEntry(resourceClass);
        ResourceRepositoryAdapter repositoryAdapter = entry.getResourceRepository(null);
        return (ResourceRepositoryStub)repositoryAdapter.getResourceRepository();
    }

    public <T, ID extends Serializable> QuerySpecResourceRepositoryStub<T, ID> getQuerySpecRepository(Class<T> resourceClass) {
        this.init();
        RegistryEntry entry = this.resourceRegistry.getEntry(resourceClass);
        ResourceRepositoryAdapter repositoryAdapter = entry.getResourceRepository(null);
        return (QuerySpecResourceRepositoryStub)repositoryAdapter.getResourceRepository();
    }

    public <T, ID extends Serializable, D, DID extends Serializable> RelationshipRepositoryStub<T, ID, D, DID> getRepository(Class<T> sourceClass, Class<D> targetClass) {
        this.init();
        RegistryEntry entry = this.resourceRegistry.getEntry(sourceClass);
        RelationshipRepositoryAdapter repositoryAdapter = entry.getRelationshipRepositoryForClass(targetClass, null);
        return (RelationshipRepositoryStub)repositoryAdapter.getRelationshipRepository();
    }

    public <T, ID extends Serializable, D, DID extends Serializable> QuerySpecRelationshipRepositoryStub<T, ID, D, DID> getQuerySpecRepository(Class<T> sourceClass, Class<D> targetClass) {
        this.init();
        RegistryEntry entry = this.resourceRegistry.getEntry(sourceClass);
        RelationshipRepositoryAdapter repositoryAdapter = entry.getRelationshipRepositoryForClass(targetClass, null);
        return (QuerySpecRelationshipRepositoryStub)repositoryAdapter.getRelationshipRepository();
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public OkHttpClient getHttpClient() {
        return this.client;
    }

    public ResourceRegistry getRegistry() {
        return this.resourceRegistry;
    }

    public void addModule(Module module) {
        this.moduleRegistry.addModule(module);
    }

    public ExceptionMapperRegistry getExceptionMapperRegistry() {
        return this.exceptionMapperRegistry;
    }
}

