package io.kategory.ank

import kategory.*
import org.intellij.markdown.ast.ASTNode
import java.io.File

const val AnkBlock = "kotlin:ank"
const val AnkSilentBlock = "kotlin:ank:silent"
const val KotlinBlock = "kotlin"

fun ank(source: File, target: File, compilerArgs: ListKW<String>) =
        AnkOps.binding {
            val T = ListKW.traverse()
            val targetDirectory: File = createTarget(source, target).bind()
            val files: ListKW<File> = getFileCandidates(targetDirectory).bind()
            val filesContents: ListKW<String> = files.map(::readFile).k().sequence(T).bind()
            val parsedMarkDowns: ListKW<ASTNode> = filesContents.map(::parseMarkdown).k().sequence(T).bind()
            val allSnippets: ListKW<ListKW<Snippet>> = parsedMarkDowns.mapIndexed { n, tree ->
                extractCode(filesContents.list[n], tree)
            }.k().sequence(T).bind()
            val compilationResults =
                    ListKW(allSnippets.mapIndexed { n, s -> compileCode(files.list[n], s, compilerArgs) }).k().sequence(T).bind()
            val replacedResults: ListKW<String> = compilationResults.mapIndexed { n , c ->  replaceAnkToKotlin(c) }.k().sequence(T).bind()
            val resultingFiles: ListKW<File> = generateFiles(files, replacedResults).bind()
            yields(resultingFiles)
        }

fun <A> ListKW<Free<AnkOpsHK, A>>.sequence(T: Traverse<ListKWHK> = traverse()): Free<AnkOpsHK, ListKW<A>> =
        T.sequence(this, AnkOps).ev().map { it.ev() }