/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb.transaction.client;

import io.kareldb.transaction.client.KarelDbTransaction;
import io.kareldb.transaction.client.KarelDbTransactionManager;
import io.kareldb.version.TxVersionedCache;
import io.kareldb.version.VersionedCache;
import io.kareldb.version.VersionedValue;
import io.kcache.KeyValue;
import io.kcache.KeyValueIterator;
import java.util.Arrays;
import org.apache.omid.transaction.RollbackException;
import org.apache.omid.transaction.Transaction;
import org.apache.omid.transaction.TransactionManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicTransactionTest {
    private static final Logger LOG = LoggerFactory.getLogger(BasicTransactionTest.class);
    private static final String TEST_TABLE = "test-table";
    private Comparable[] rowId1 = new Comparable[]{"row1"};
    private Comparable[] rowId2 = new Comparable[]{"row2"};
    private Comparable[] dataValue1 = new Comparable[]{"testWrite-1"};
    private Comparable[] dataValue2 = new Comparable[]{"testWrite-2"};
    private TransactionManager tm;
    private TxVersionedCache versionedCache;

    @Before
    public void setUp() throws Exception {
        this.tm = KarelDbTransactionManager.newInstance();
        this.versionedCache = new TxVersionedCache(new VersionedCache(TEST_TABLE));
    }

    @After
    public void tearDown() throws Exception {
        this.tm.close();
    }

    @Test
    public void testTimestampsOfTwoRowsInsertedAfterCommitOfSingleTransactionAreEquals() throws Exception {
        Transaction tx1 = this.tm.begin();
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tx1));
        this.versionedCache.put(this.rowId1, this.dataValue1);
        this.versionedCache.put(this.rowId2, this.dataValue2);
        this.tm.commit(tx1);
        Transaction tx2 = this.tm.begin();
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tx2));
        VersionedValue v1 = this.versionedCache.get(this.rowId1);
        VersionedValue v2 = this.versionedCache.get(this.rowId2);
        Assert.assertArrayEquals((Object[])this.dataValue1, (Object[])v1.getValue());
        Assert.assertArrayEquals((Object[])this.dataValue2, (Object[])v2.getValue());
        Assert.assertEquals((long)v1.getCommit(), (long)v2.getCommit());
    }

    @Test
    public void runTestSimple() throws Exception {
        Transaction t1 = this.tm.begin();
        LOG.info("Transaction created " + t1);
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)t1));
        this.versionedCache.put(this.rowId1, this.dataValue1);
        this.tm.commit(t1);
        Transaction tread = this.tm.begin();
        Transaction t2 = this.tm.begin();
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)t2));
        this.versionedCache.replace(this.rowId1, this.dataValue1, this.dataValue2);
        this.tm.commit(t2);
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tread));
        VersionedValue v1 = this.versionedCache.get(this.rowId1);
        Assert.assertArrayEquals((Object[])this.dataValue1, (Object[])v1.getValue());
    }

    @Test
    public void runTestManyVersions() throws Exception {
        Transaction t1 = this.tm.begin();
        LOG.info("Transaction created " + t1);
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)t1));
        this.versionedCache.put(this.rowId1, this.dataValue1);
        this.tm.commit(t1);
        for (int i = 0; i < 5; ++i) {
            Transaction t2 = this.tm.begin();
            KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)t2));
            this.versionedCache.replace(this.rowId1, this.dataValue1, this.dataValue2);
        }
        Transaction tread = this.tm.begin();
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tread));
        VersionedValue v1 = this.versionedCache.get(this.rowId1);
        Assert.assertArrayEquals((Object[])this.dataValue1, (Object[])v1.getValue());
    }

    @Test
    public void runTestInterleave() throws Exception {
        Transaction t1 = this.tm.begin();
        LOG.info("Transaction created " + t1);
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)t1));
        this.versionedCache.put(this.rowId1, this.dataValue1);
        this.tm.commit(t1);
        Transaction t2 = this.tm.begin();
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)t2));
        this.versionedCache.replace(this.rowId1, this.dataValue1, this.dataValue2);
        Transaction tread = this.tm.begin();
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tread));
        VersionedValue v1 = this.versionedCache.get(this.rowId1);
        Assert.assertArrayEquals((Object[])this.dataValue1, (Object[])v1.getValue());
        try {
            this.tm.commit(t2);
        }
        catch (RollbackException rollbackException) {
            // empty catch block
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSameCommitRaisesException() throws Exception {
        Transaction t1 = this.tm.begin();
        this.tm.commit(t1);
        this.tm.commit(t1);
    }

    @Test
    public void testInterleavedScanReturnsTheRightSnapshotResults() throws Exception {
        Comparable[] startRow = new Comparable[]{"row-to-scan0"};
        Comparable[] stopRow = new Comparable[]{"row-to-scan9"};
        Comparable[] randomRow = new Comparable[]{"row-to-scan3"};
        Transaction tx1 = this.tm.begin();
        for (int i = 0; i < 10; ++i) {
            Comparable[] row = new Comparable[]{"row-to-scan" + i};
            KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tx1));
            this.versionedCache.put(row, this.dataValue1);
        }
        this.tm.commit(tx1);
        Transaction tx2 = this.tm.begin();
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tx2));
        this.versionedCache.replace(randomRow, this.dataValue1, this.dataValue2);
        Transaction scanTx = this.tm.begin();
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)scanTx));
        KeyValueIterator iter = this.versionedCache.range(startRow, true, stopRow, true);
        while (iter.hasNext()) {
            KeyValue kv = (KeyValue)iter.next();
            Assert.assertArrayEquals((Object[])this.dataValue1, (Object[])((VersionedValue)kv.value).getValue());
        }
        this.tm.commit(tx2);
        int modifiedRows = 0;
        Transaction newScanTx = this.tm.begin();
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)newScanTx));
        KeyValueIterator newIter = this.versionedCache.range(startRow, true, stopRow, true);
        while (newIter.hasNext()) {
            KeyValue kv = (KeyValue)newIter.next();
            if (!Arrays.equals(this.dataValue2, ((VersionedValue)kv.value).getValue())) continue;
            ++modifiedRows;
        }
        Assert.assertEquals((String)("Expected 1 row modified, but " + modifiedRows + " are."), (long)modifiedRows, (long)1L);
        newIter = this.versionedCache.range(startRow, true, stopRow, true);
        try {
            newIter.remove();
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testInterleavedScanReturnsTheRightSnapshotResultsWhenATransactionAborts() throws Exception {
        Comparable[] startRow = new Comparable[]{"row-to-scan0"};
        Comparable[] stopRow = new Comparable[]{"row-to-scan9"};
        Comparable[] randomRow = new Comparable[]{"row-to-scan3"};
        Transaction tx1 = this.tm.begin();
        for (int i = 0; i < 10; ++i) {
            Comparable[] row = new Comparable[]{"row-to-scan" + i};
            KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tx1));
            this.versionedCache.put(row, this.dataValue1);
        }
        this.tm.commit(tx1);
        Transaction tx2 = this.tm.begin();
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tx2));
        this.versionedCache.replace(randomRow, this.dataValue1, this.dataValue2);
        int modifiedRows = 0;
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tx2));
        KeyValueIterator newIter = this.versionedCache.range(startRow, true, stopRow, true);
        while (newIter.hasNext()) {
            KeyValue kv = (KeyValue)newIter.next();
            if (!Arrays.equals(this.dataValue2, ((VersionedValue)kv.value).getValue())) continue;
            ++modifiedRows;
        }
        Assert.assertEquals((String)("Expected 1 row modified, but " + modifiedRows + " are."), (long)modifiedRows, (long)1L);
        this.tm.rollback(tx2);
        Transaction txScan = this.tm.begin();
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)txScan));
        KeyValueIterator iter = this.versionedCache.range(startRow, true, stopRow, true);
        while (iter.hasNext()) {
            KeyValue kv = (KeyValue)iter.next();
            Assert.assertArrayEquals((Object[])this.dataValue1, (Object[])((VersionedValue)kv.value).getValue());
        }
        newIter = this.versionedCache.range(startRow, true, stopRow, true);
        try {
            newIter.remove();
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

