/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb.transaction.client;

import io.kareldb.transaction.client.KarelDbTransaction;
import io.kareldb.transaction.client.KarelDbTransactionManager;
import io.kareldb.version.TxVersionedCache;
import io.kareldb.version.VersionedCache;
import io.kcache.utils.Streams;
import java.util.Iterator;
import org.apache.omid.transaction.RollbackException;
import org.apache.omid.transaction.Transaction;
import org.apache.omid.transaction.TransactionManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BailisAnomaliesTest {
    private static final Logger LOG = LoggerFactory.getLogger(BailisAnomaliesTest.class);
    private static final String TEST_TABLE = "test-table";
    private Comparable[] rowId1 = new Comparable[]{"row1"};
    private Comparable[] rowId2 = new Comparable[]{"row2"};
    private Comparable[] rowId3 = new Comparable[]{"row3"};
    private Comparable[] dataValue1 = new Comparable[]{Integer.valueOf(10)};
    private Comparable[] dataValue2 = new Comparable[]{Integer.valueOf(20)};
    private Comparable[] dataValue3 = new Comparable[]{Integer.valueOf(30)};
    private TransactionManager tm;
    private TxVersionedCache versionedCache;

    @Before
    public void setUp() throws Exception {
        this.tm = KarelDbTransactionManager.newInstance();
        this.versionedCache = new TxVersionedCache(new VersionedCache(TEST_TABLE));
        Transaction tx = this.tm.begin();
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tx));
        this.versionedCache.put(this.rowId1, this.dataValue1);
        this.versionedCache.put(this.rowId2, this.dataValue2);
        this.tm.commit(tx);
    }

    @After
    public void tearDown() throws Exception {
        this.tm.close();
    }

    @Test
    public void testSIPreventsPredicateManyPrecedersForReadPredicates() throws Exception {
        Transaction tx1 = this.tm.begin();
        Transaction tx2 = this.tm.begin();
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tx1));
        Assert.assertNull((Object)this.versionedCache.get(this.rowId3));
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tx2));
        this.versionedCache.put(this.rowId3, this.dataValue3);
        this.tm.commit(tx2);
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tx1));
        Assert.assertNull((Object)this.versionedCache.get(this.rowId3));
        this.tm.commit(tx1);
    }

    @Test
    public void testSIPreventsPredicateManyPrecedersForWritePredicates() throws Exception {
        Transaction tx1 = this.tm.begin();
        Transaction tx2 = this.tm.begin();
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tx1));
        this.versionedCache.replace(this.rowId1, this.dataValue1, this.dataValue2);
        this.versionedCache.replace(this.rowId2, this.dataValue2, this.dataValue3);
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tx2));
        this.versionedCache.remove(this.rowId1);
        try {
            this.tm.commit(tx1);
        }
        catch (RollbackException rollbackException) {
            // empty catch block
        }
        try {
            this.tm.commit(tx2);
            Assert.fail();
        }
        catch (RollbackException rollbackException) {
            // empty catch block
        }
    }

    @Test
    public void testSIPreventsLostUpdates() throws Exception {
        Transaction tx1 = this.tm.begin();
        Transaction tx2 = this.tm.begin();
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tx1));
        Assert.assertArrayEquals((Object[])this.dataValue1, (Object[])this.versionedCache.get(this.rowId1).getValue());
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tx2));
        Assert.assertArrayEquals((Object[])this.dataValue1, (Object[])this.versionedCache.get(this.rowId1).getValue());
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tx1));
        this.versionedCache.replace(this.rowId1, this.dataValue1, new Comparable[]{Integer.valueOf(11)});
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tx2));
        this.versionedCache.replace(this.rowId1, this.dataValue1, new Comparable[]{Integer.valueOf(11)});
        this.tm.commit(tx1);
        try {
            this.tm.commit(tx2);
            Assert.fail();
        }
        catch (RollbackException rollbackException) {
            // empty catch block
        }
    }

    @Test
    public void testSIPreventsReadSkew() throws Exception {
        Transaction tx1 = this.tm.begin();
        Transaction tx2 = this.tm.begin();
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tx1));
        Assert.assertArrayEquals((Object[])this.dataValue1, (Object[])this.versionedCache.get(this.rowId1).getValue());
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tx2));
        Assert.assertArrayEquals((Object[])this.dataValue1, (Object[])this.versionedCache.get(this.rowId1).getValue());
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tx2));
        Assert.assertArrayEquals((Object[])this.dataValue2, (Object[])this.versionedCache.get(this.rowId2).getValue());
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tx2));
        this.versionedCache.replace(this.rowId1, this.dataValue1, new Comparable[]{Integer.valueOf(12)});
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tx2));
        this.versionedCache.replace(this.rowId2, this.dataValue2, new Comparable[]{Integer.valueOf(18)});
        this.tm.commit(tx2);
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tx1));
        Assert.assertArrayEquals((Object[])this.dataValue2, (Object[])this.versionedCache.get(this.rowId2).getValue());
        this.tm.commit(tx1);
    }

    @Test
    public void testSIPreventsReadSkewUsingWritePredicate() throws Exception {
        Transaction tx1 = this.tm.begin();
        Transaction tx2 = this.tm.begin();
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tx1));
        Assert.assertEquals((long)2L, (long)this.versionedCache.size());
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tx2));
        Assert.assertEquals((long)2L, (long)this.versionedCache.size());
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tx1));
        this.versionedCache.replace(this.rowId1, this.dataValue1, new Comparable[]{Integer.valueOf(12)});
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tx2));
        this.versionedCache.replace(this.rowId2, this.dataValue2, new Comparable[]{Integer.valueOf(18)});
        this.tm.commit(tx2);
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tx1));
        this.versionedCache.remove(this.rowId2);
        try {
            this.tm.commit(tx1);
            Assert.fail((String)"Should be aborted");
        }
        catch (RollbackException rollbackException) {
            // empty catch block
        }
    }

    @Test
    public void testSIDoesNotPreventWriteSkew() throws Exception {
        Transaction tx1 = this.tm.begin();
        Transaction tx2 = this.tm.begin();
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tx1));
        Assert.assertEquals((long)2L, (long)Streams.streamOf((Iterator)this.versionedCache.range(this.rowId1, true, this.rowId2, true)).count());
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tx2));
        Assert.assertEquals((long)2L, (long)Streams.streamOf((Iterator)this.versionedCache.range(this.rowId1, true, this.rowId2, true)).count());
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tx1));
        this.versionedCache.replace(this.rowId1, this.dataValue1, new Comparable[]{Integer.valueOf(11)});
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tx2));
        this.versionedCache.replace(this.rowId2, this.dataValue2, new Comparable[]{Integer.valueOf(21)});
        this.tm.commit(tx1);
        this.tm.commit(tx2);
    }

    @Test
    public void testSIDoesNotPreventAntiDependencyCycles() throws Exception {
        Transaction tx1 = this.tm.begin();
        Transaction tx2 = this.tm.begin();
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tx1));
        Assert.assertArrayEquals((Object[])this.dataValue1, (Object[])this.versionedCache.get(this.rowId1).getValue());
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tx2));
        Assert.assertArrayEquals((Object[])this.dataValue1, (Object[])this.versionedCache.get(this.rowId1).getValue());
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tx1));
        this.versionedCache.put(this.rowId3, this.dataValue3);
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tx2));
        this.versionedCache.put(new Comparable[]{"row4"}, new Comparable[]{Integer.valueOf(42)});
        this.tm.commit(tx1);
        this.tm.commit(tx2);
    }
}

