/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb.transaction;

import com.google.common.collect.Sets;
import io.kareldb.transaction.KarelDbCommitTable;
import io.kareldb.transaction.KarelDbTimestampClient;
import io.kareldb.transaction.KarelDbTimestampStorage;
import io.kcache.Cache;
import io.kcache.utils.InMemoryCache;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.omid.committable.CommitTable;
import org.apache.omid.metrics.MetricsRegistry;
import org.apache.omid.metrics.NullMetricsProvider;
import org.apache.omid.timestamp.storage.TimestampStorage;
import org.apache.omid.tso.Panicker;
import org.apache.omid.tso.RuntimeExceptionPanicker;
import org.apache.omid.tso.TimestampOracle;
import org.apache.omid.tso.TimestampOracleImpl;
import org.apache.omid.tso.client.AbortException;
import org.apache.omid.tso.client.CellId;
import org.apache.omid.tso.client.TSOProtocol;
import org.apache.omid.tso.util.DummyCellIdImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TSOClientSimpleTest {
    private static final CellId c1 = new DummyCellIdImpl(3735928559L);
    private static final CellId c2 = new DummyCellIdImpl(-4276996862L);
    private CommitTable commitTable;
    private TSOProtocol client;

    @Before
    public void setUp() throws IOException {
        this.commitTable = new KarelDbCommitTable((Cache)new InMemoryCache());
        KarelDbTimestampStorage timestampStorage = new KarelDbTimestampStorage((Cache)new InMemoryCache());
        TimestampOracleImpl timestampOracle = new TimestampOracleImpl((MetricsRegistry)new NullMetricsProvider(), (TimestampStorage)timestampStorage, (Panicker)new RuntimeExceptionPanicker());
        timestampOracle.initialize();
        this.client = new KarelDbTimestampClient((TimestampOracle)timestampOracle, this.commitTable.getWriter());
    }

    @Test
    public void testConflicts() throws Exception {
        long tr1 = (Long)this.client.getNewStartTimestamp().get();
        long tr2 = (Long)this.client.getNewStartTimestamp().get();
        this.client.commit(tr1, (Set)Sets.newHashSet((Object[])new CellId[]{c1}), new HashSet()).get();
        try {
            this.client.commit(tr2, (Set)Sets.newHashSet((Object[])new CellId[]{c1, c2}), new HashSet()).get();
            Assert.fail((String)"Shouldn't have committed");
        }
        catch (ExecutionException ee) {
            Assert.assertEquals((String)"Should have aborted", ee.getCause().getClass(), AbortException.class);
        }
    }

    @Test
    public void testWatermarkUpdate() throws Exception {
        CommitTable.Client commitTableClient = this.commitTable.getClient();
        long tr1 = (Long)this.client.getNewStartTimestamp().get();
        this.client.commit(tr1, (Set)Sets.newHashSet((Object[])new CellId[]{c1}), new HashSet()).get();
        long initWatermark = (Long)commitTableClient.readLowWatermark().get();
        long tr2 = (Long)this.client.getNewStartTimestamp().get();
        this.client.commit(tr2, (Set)Sets.newHashSet((Object[])new CellId[]{c1}), new HashSet()).get();
        long newWatermark = (Long)commitTableClient.readLowWatermark().get();
        Assert.assertTrue((String)"new low watermark should be bigger", (newWatermark > initWatermark ? 1 : 0) != 0);
    }
}

