/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb.transaction;

import com.google.common.collect.Sets;
import io.kareldb.transaction.KarelDbCommitTable;
import io.kareldb.transaction.KarelDbTimestampClient;
import io.kareldb.transaction.KarelDbTimestampStorage;
import io.kcache.Cache;
import io.kcache.utils.InMemoryCache;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.omid.committable.CommitTable;
import org.apache.omid.metrics.MetricsRegistry;
import org.apache.omid.metrics.NullMetricsProvider;
import org.apache.omid.timestamp.storage.TimestampStorage;
import org.apache.omid.tso.Panicker;
import org.apache.omid.tso.RuntimeExceptionPanicker;
import org.apache.omid.tso.TimestampOracle;
import org.apache.omid.tso.TimestampOracleImpl;
import org.apache.omid.tso.client.AbortException;
import org.apache.omid.tso.client.CellId;
import org.apache.omid.tso.client.TSOProtocol;
import org.apache.omid.tso.util.DummyCellIdImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSOClientRowAndCellLevelConflictTest {
    private static final Logger LOG = LoggerFactory.getLogger(TSOClientRowAndCellLevelConflictTest.class);
    private CommitTable commitTable;
    private TSOProtocol client;

    @Before
    public void setUp() throws IOException {
        this.commitTable = new KarelDbCommitTable((Cache)new InMemoryCache());
        KarelDbTimestampStorage timestampStorage = new KarelDbTimestampStorage((Cache)new InMemoryCache());
        TimestampOracleImpl timestampOracle = new TimestampOracleImpl((MetricsRegistry)new NullMetricsProvider(), (TimestampStorage)timestampStorage, (Panicker)new RuntimeExceptionPanicker());
        timestampOracle.initialize();
        this.client = new KarelDbTimestampClient((TimestampOracle)timestampOracle, this.commitTable.getWriter());
    }

    @Test
    public void testCellLevelConflictAnalysisConflict() throws Exception {
        DummyCellIdImpl c1 = new DummyCellIdImpl(3735928559L, 3735928558L);
        DummyCellIdImpl c2 = new DummyCellIdImpl(3735928559L, 3735928558L);
        HashSet testWriteSet1 = Sets.newHashSet((Object[])new CellId[]{c1});
        HashSet testWriteSet2 = Sets.newHashSet((Object[])new CellId[]{c2});
        long ts1 = (Long)this.client.getNewStartTimestamp().get();
        long ts2 = (Long)this.client.getNewStartTimestamp().get();
        this.client.commit(ts1, (Set)testWriteSet1).get();
        try {
            this.client.commit(ts2, (Set)testWriteSet2).get();
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)"Transaction should be aborted", (boolean)(e.getCause() instanceof AbortException));
            return;
        }
        Assert.assertTrue((String)"Transaction should be aborted", (boolean)false);
    }

    @Test
    public void testCellLevelConflictAnalysisCommit() throws Exception {
        DummyCellIdImpl c1 = new DummyCellIdImpl(3735928559L, 3735928558L);
        DummyCellIdImpl c2 = new DummyCellIdImpl(4276996862L, 3735928559L);
        HashSet testWriteSet1 = Sets.newHashSet((Object[])new CellId[]{c1});
        HashSet testWriteSet2 = Sets.newHashSet((Object[])new CellId[]{c2});
        long ts1 = (Long)this.client.getNewStartTimestamp().get();
        long ts2 = (Long)this.client.getNewStartTimestamp().get();
        this.client.commit(ts1, (Set)testWriteSet1).get();
        try {
            this.client.commit(ts2, (Set)testWriteSet2).get();
        }
        catch (ExecutionException e) {
            Assert.assertFalse((String)"Transaction should be committed", (boolean)(e.getCause() instanceof AbortException));
            return;
        }
        Assert.assertTrue((String)"Transaction should be committed", (boolean)true);
    }
}

