/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb.transaction;

import com.google.common.collect.Sets;
import io.kareldb.transaction.KarelDbCommitTable;
import io.kareldb.transaction.KarelDbTimestampClient;
import io.kareldb.transaction.KarelDbTimestampStorage;
import io.kcache.Cache;
import io.kcache.utils.InMemoryCache;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.omid.committable.CommitTable;
import org.apache.omid.metrics.MetricsRegistry;
import org.apache.omid.metrics.NullMetricsProvider;
import org.apache.omid.timestamp.storage.TimestampStorage;
import org.apache.omid.tso.Panicker;
import org.apache.omid.tso.RuntimeExceptionPanicker;
import org.apache.omid.tso.TimestampOracle;
import org.apache.omid.tso.TimestampOracleImpl;
import org.apache.omid.tso.client.AbortException;
import org.apache.omid.tso.client.CellId;
import org.apache.omid.tso.client.TSOProtocol;
import org.apache.omid.tso.util.DummyCellIdImpl;
import org.apache.phoenix.thirdparty.com.google.common.base.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSOClientBasicTest {
    private static final Logger LOG = LoggerFactory.getLogger(TSOClientBasicTest.class);
    private static final CellId c1 = new DummyCellIdImpl(3735928559L);
    private static final CellId c2 = new DummyCellIdImpl(4276996862L);
    private CommitTable commitTable;
    private CommitTable.Client commitTableClient;
    private TSOProtocol tsoClient;
    private TSOProtocol justAnotherTSOClient;

    @Before
    public void setUp() throws Exception {
        this.commitTable = new KarelDbCommitTable((Cache)new InMemoryCache());
        this.commitTableClient = this.commitTable.getClient();
        KarelDbTimestampStorage timestampStorage = new KarelDbTimestampStorage((Cache)new InMemoryCache());
        TimestampOracleImpl timestampOracle = new TimestampOracleImpl((MetricsRegistry)new NullMetricsProvider(), (TimestampStorage)timestampStorage, (Panicker)new RuntimeExceptionPanicker());
        timestampOracle.initialize();
        this.tsoClient = new KarelDbTimestampClient((TimestampOracle)timestampOracle, this.commitTable.getWriter());
        this.justAnotherTSOClient = new KarelDbTimestampClient((TimestampOracle)timestampOracle, this.commitTable.getWriter());
    }

    @Test
    public void testTimestampsOrderingGrowMonotonically() throws Exception {
        long startTsTx1;
        long referenceTimestamp = startTsTx1 = ((Long)this.tsoClient.getNewStartTimestamp().get()).longValue();
        long startTsTx2 = (Long)this.tsoClient.getNewStartTimestamp().get();
        Assert.assertTrue((String)"Should grow monotonically", (startTsTx2 >= (referenceTimestamp += 50L) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Two timestamps obtained consecutively should grow", (startTsTx2 > startTsTx1 ? 1 : 0) != 0);
        long commitTsTx2 = (Long)this.tsoClient.commit(startTsTx2, (Set)Sets.newHashSet((Object[])new CellId[]{c1})).get();
        Assert.assertTrue((String)"Should grow monotonically", (commitTsTx2 >= (referenceTimestamp += 50L) ? 1 : 0) != 0);
        long commitTsTx1 = (Long)this.tsoClient.commit(startTsTx1, (Set)Sets.newHashSet((Object[])new CellId[]{c2})).get();
        Assert.assertTrue((String)"Should grow monotonically", (commitTsTx1 >= (referenceTimestamp += 50L) ? 1 : 0) != 0);
        long startTsTx3 = (Long)this.tsoClient.getNewStartTimestamp().get();
        Assert.assertTrue((String)"Should grow monotonically", (startTsTx3 >= (referenceTimestamp += 50L) ? 1 : 0) != 0);
    }

    @Test
    public void testSimpleTransactionWithNoWriteSetCanCommit() throws Exception {
        long startTsTx1 = (Long)this.tsoClient.getNewStartTimestamp().get();
        long commitTsTx1 = (Long)this.tsoClient.commit(startTsTx1, (Set)Sets.newHashSet()).get();
        Assert.assertTrue((commitTsTx1 > startTsTx1 ? 1 : 0) != 0);
    }

    @Test
    public void testTransactionWithMassiveWriteSetCanCommit() throws Exception {
        long startTs = (Long)this.tsoClient.getNewStartTimestamp().get();
        HashSet<DummyCellIdImpl> cells = new HashSet<DummyCellIdImpl>();
        for (int i = 0; i < 1000000; ++i) {
            cells.add(new DummyCellIdImpl((long)i));
        }
        long commitTs = (Long)this.tsoClient.commit(startTs, cells).get();
        Assert.assertTrue((String)"Commit TS should be higher than Start TS", (commitTs > startTs ? 1 : 0) != 0);
    }

    @Test
    public void testMultipleSerialCommitsDoNotConflict() throws Exception {
        long startTsTx1 = (Long)this.tsoClient.getNewStartTimestamp().get();
        long commitTsTx1 = (Long)this.tsoClient.commit(startTsTx1, (Set)Sets.newHashSet((Object[])new CellId[]{c1})).get();
        Assert.assertTrue((String)"Commit TS must be greater than Start TS", (commitTsTx1 > startTsTx1 ? 1 : 0) != 0);
        long startTsTx2 = (Long)this.tsoClient.getNewStartTimestamp().get();
        Assert.assertTrue((String)"TS should grow monotonically", (startTsTx2 > commitTsTx1 ? 1 : 0) != 0);
        long commitTsTx2 = (Long)this.tsoClient.commit(startTsTx2, (Set)Sets.newHashSet((Object[])new CellId[]{c1, c2})).get();
        Assert.assertTrue((String)"Commit TS must be greater than Start TS", (commitTsTx2 > startTsTx2 ? 1 : 0) != 0);
        long startTsTx3 = (Long)this.tsoClient.getNewStartTimestamp().get();
        long commitTsTx3 = (Long)this.tsoClient.commit(startTsTx3, (Set)Sets.newHashSet((Object[])new CellId[]{c2})).get();
        Assert.assertTrue((String)"Commit TS must be greater than Start TS", (commitTsTx3 > startTsTx3 ? 1 : 0) != 0);
    }

    @Test
    public void testCommitWritesToCommitTable() throws Exception {
        long commitTsForTx1;
        long startTsForTx1 = (Long)this.tsoClient.getNewStartTimestamp().get();
        long startTsForTx2 = (Long)this.tsoClient.getNewStartTimestamp().get();
        Assert.assertTrue((String)"Start TS should grow", (startTsForTx2 > startTsForTx1 ? 1 : 0) != 0);
        if (!this.tsoClient.isLowLatency()) {
            Assert.assertFalse((String)"Commit TS for TX1 shouldn't appear in Commit Table", (boolean)((Optional)this.commitTableClient.getCommitTimestamp(startTsForTx1).get()).isPresent());
        }
        Assert.assertTrue((String)"Commit TS should be higher than Start TS for the same tx", ((commitTsForTx1 = ((Long)this.tsoClient.commit(startTsForTx1, (Set)Sets.newHashSet((Object[])new CellId[]{c1})).get()).longValue()) > startTsForTx1 ? 1 : 0) != 0);
        if (!this.tsoClient.isLowLatency()) {
            Long commitTs1InCommitTable = ((CommitTable.CommitTimestamp)((Optional)this.commitTableClient.getCommitTimestamp(startTsForTx1).get()).get()).getValue();
            Assert.assertNotNull((String)"Tx is committed, should return as such from Commit Table", (Object)commitTs1InCommitTable);
            Assert.assertEquals((String)"getCommitTimestamp() & commit() should report same Commit TS value for same tx", (long)commitTsForTx1, (long)commitTs1InCommitTable);
            Assert.assertTrue((String)"Commit TS should be higher than tx's Start TS", (commitTs1InCommitTable > startTsForTx2 ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((String)"Commit TS should be higher than tx's Start TS", (commitTsForTx1 > startTsForTx2 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testTwoConcurrentTxWithOverlappingWritesetsHaveConflicts() throws Exception {
        long startTsTx1 = (Long)this.tsoClient.getNewStartTimestamp().get();
        long startTsTx2 = (Long)this.tsoClient.getNewStartTimestamp().get();
        Assert.assertTrue((String)"Second TX should have higher TS", (startTsTx2 > startTsTx1 ? 1 : 0) != 0);
        long commitTsTx1 = (Long)this.tsoClient.commit(startTsTx1, (Set)Sets.newHashSet((Object[])new CellId[]{c1})).get();
        Assert.assertTrue((String)"Commit TS must be higher than Start TS for the same tx", (commitTsTx1 > startTsTx1 ? 1 : 0) != 0);
        try {
            this.tsoClient.commit(startTsTx2, (Set)Sets.newHashSet((Object[])new CellId[]{c1, c2})).get();
            Assert.fail((String)"Second TX should fail on commit");
        }
        catch (ExecutionException ee) {
            Assert.assertEquals((String)"Should have aborted", AbortException.class, ee.getCause().getClass());
        }
    }

    @Test
    public void testTransactionStartedBeforeFenceAborts() throws Exception {
        long startTsTx1 = (Long)this.tsoClient.getNewStartTimestamp().get();
        long fenceID = (Long)this.tsoClient.getFence(c1.getTableId()).get();
        Assert.assertTrue((String)"Fence ID should be higher thank Tx1ID", (fenceID > startTsTx1 ? 1 : 0) != 0);
        try {
            this.tsoClient.commit(startTsTx1, (Set)Sets.newHashSet((Object[])new CellId[]{c1, c2})).get();
            Assert.fail((String)"TX should fail on commit");
        }
        catch (ExecutionException ee) {
            Assert.assertEquals((String)"Should have aborted", AbortException.class, ee.getCause().getClass());
        }
    }

    @Test
    public void testTransactionStartedBeforeNonOverlapFenceCommits() throws Exception {
        long startTsTx1 = (Long)this.tsoClient.getNewStartTimestamp().get();
        this.tsoClient.getFence(7L).get();
        try {
            this.tsoClient.commit(startTsTx1, (Set)Sets.newHashSet((Object[])new CellId[]{c1, c2})).get();
        }
        catch (ExecutionException ee) {
            Assert.fail((String)"TX should successfully commit");
        }
    }

    @Test
    public void testTransactionStartedAfterFenceCommits() throws Exception {
        this.tsoClient.getFence(c1.getTableId()).get();
        long startTsTx1 = (Long)this.tsoClient.getNewStartTimestamp().get();
        try {
            this.tsoClient.commit(startTsTx1, (Set)Sets.newHashSet((Object[])new CellId[]{c1, c2})).get();
        }
        catch (ExecutionException ee) {
            Assert.fail((String)"TX should successfully commit");
        }
    }

    @Test
    public void testConflictsAndMonotonicallyTimestampGrowthWithTwoDifferentTSOClients() throws Exception {
        long startTsTx1Client1 = (Long)this.tsoClient.getNewStartTimestamp().get();
        long startTsTx2Client1 = (Long)this.tsoClient.getNewStartTimestamp().get();
        long startTsTx3Client1 = (Long)this.tsoClient.getNewStartTimestamp().get();
        Long commitTSTx1 = (Long)this.tsoClient.commit(startTsTx1Client1, (Set)Sets.newHashSet((Object[])new CellId[]{c1})).get();
        try {
            this.tsoClient.commit(startTsTx3Client1, (Set)Sets.newHashSet((Object[])new CellId[]{c1, c2})).get();
            Assert.fail((String)"Second commit should fail as conflicts with the previous concurrent one");
        }
        catch (ExecutionException ee) {
            Assert.assertEquals((String)"Should have aborted", AbortException.class, ee.getCause().getClass());
        }
        long startTsTx4Client2 = (Long)this.justAnotherTSOClient.getNewStartTimestamp().get();
        Assert.assertFalse((String)"Tx3 didn't commit", (boolean)((Optional)this.commitTableClient.getCommitTimestamp(startTsTx3Client1).get()).isPresent());
        if (!this.tsoClient.isLowLatency()) {
            commitTSTx1 = ((CommitTable.CommitTimestamp)((Optional)this.commitTableClient.getCommitTimestamp(startTsTx1Client1).get()).get()).getValue();
        }
        Assert.assertTrue((String)"Tx1 committed after Tx2 started", (commitTSTx1 > startTsTx2Client1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Tx1 committed before Tx4 started on the other TSO client", (commitTSTx1 < startTsTx4Client2 ? 1 : 0) != 0);
    }
}

