/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb.transaction;

import com.google.common.base.Preconditions;
import io.kareldb.transaction.client.KarelDbTransactionManager;
import io.kareldb.version.TxVersionedCache;
import io.kareldb.version.VersionedCache;
import io.kareldb.version.VersionedValue;
import java.util.Arrays;
import org.apache.omid.transaction.RollbackException;
import org.apache.omid.transaction.Transaction;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotIsolationTest {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotIsolationTest.class);

    @Test
    public void testSnapshotIsolation() throws Exception {
        String userTableName = "MY_TX_TABLE";
        Object[] initialData = new Comparable[]{Long.valueOf(0L)};
        Comparable[] dataValue1 = new Comparable[]{Long.valueOf(1L)};
        Comparable[] dataValue2 = new Comparable[]{Long.valueOf(2L)};
        try (KarelDbTransactionManager tm = KarelDbTransactionManager.newInstance();){
            TxVersionedCache versionedCache = new TxVersionedCache(new VersionedCache(userTableName));
            Comparable[] rowId = new Comparable[]{Long.valueOf(100L)};
            Transaction tx0 = tm.begin();
            versionedCache.put(rowId, (Comparable[])initialData);
            tm.commit(tx0);
            LOG.info("Initial Transaction {} COMMITTED.", (Object)tx0);
            Transaction tx1 = tm.begin();
            LOG.info("Transaction {} STARTED", (Object)tx1);
            versionedCache.replace(rowId, (Comparable[])initialData, dataValue1);
            LOG.info("Transaction {} updates base value in its own Snapshot", (Object)tx1);
            Transaction tx2 = tm.begin();
            LOG.info("Concurrent Transaction {} STARTED", (Object)tx2);
            VersionedValue tx2GetResult = versionedCache.get(rowId);
            Assert.assertArrayEquals((String)"As Tx1 is not yet committed, Tx2 should read the value set by Tx0 not the value written by Tx1", (Object[])tx2GetResult.getValue(), (Object[])initialData);
            tm.commit(tx1);
            LOG.info("Transaction {} COMMITTED.", (Object)tx1);
            tx2GetResult = versionedCache.get(rowId);
            LOG.info("Concurrent Transaction {} should read again base value in its Snapshot | Value read = {}", (Object)tx2, (Object)Arrays.toString(tx2GetResult.getValue()));
            Assert.assertArrayEquals((String)"Tx2 must read the initial value written by Tx0", (Object[])tx2GetResult.getValue(), (Object[])initialData);
            versionedCache.replace(rowId, tx2GetResult.getValue(), dataValue2);
            try {
                LOG.info("Concurrent Transaction {} TRYING TO COMMIT", (Object)tx2);
                tm.commit(tx2);
                Preconditions.checkState((boolean)false, (Object)"Should have thrown RollbackException");
            }
            catch (RollbackException e) {
                LOG.info("Concurrent Transaction {} ROLLED-BACK : {}", (Object)tx2, (Object)e.getMessage());
            }
        }
    }
}

