/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb.jdbc;

import io.kareldb.jdbc.BaseJDBCTestCase;
import io.kareldb.jdbc.JDBC;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.junit.Test;

public class JoinTest
extends BaseJDBCTestCase {
    private static final String SYNTAX_ERROR = "42X01";
    private static final String AMBIGUOUS_COLNAME = "42X03";
    private static final String COLUMN_NOT_IN_SCOPE = "42X04";
    private static final String NON_COMPARABLE = "42818";
    private static final String NO_COLUMNS = "42X81";
    private static final String TABLE_NAME_NOT_IN_SCOPE = "42X10";
    private static final String VALUES_WITH_NULL = "42X07";

    @Test
    public void testCrossJoins() throws SQLException {
        this.setAutoCommit(false);
        String[][] T1 = new String[][]{{"1", "one"}, {"2", "two"}, {"3", null}, {"5", "five"}, {"6", "six"}};
        String[][] T2 = new String[][]{{"1", null}, {"2", "II"}, {"4", "IV"}};
        Statement s = this.createStatement();
        s.execute("create table t1(c1 varchar, c2 varchar(10))");
        this.fillTable("insert into t1 values (?,?)", T1);
        s.execute("create table t2(c1 varchar, c2 varchar(10))");
        this.fillTable("insert into t2 values (?,?)", T2);
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 cross join t2"), JoinTest.cross(T1, T2));
        JoinTest.assertStatementError(SYNTAX_ERROR, s, "select * from t1 cross join t1 USING(c1)");
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 a cross join t1 b"), JoinTest.cross(T1, T1));
        JDBC.assertUnorderedResultSet(s.executeQuery("select t2.*, t1.* from t1 cross join t2"), JoinTest.cross(T2, T1));
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 cross join t2 cross join t1 t3"), JoinTest.cross(T1, JoinTest.cross(T2, T1)));
        JDBC.assertUnorderedResultSet(s.executeQuery("select t1.c2 from t1 cross join t2"), JoinTest.project(new int[]{1}, JoinTest.cross(T1, T2)));
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from t1 cross join t2"), Integer.toString(T1.length * T2.length));
        String[][] expectedInnerJoin = new String[][]{{"1", "one", "1", null}, {"2", "two", "2", "II"}};
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 cross join t2 where t1.c1=t2.c1"), expectedInnerJoin);
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 inner join t2 on t1.c1=t2.c1"), expectedInnerJoin);
        JDBC.assertFullResultSet(s.executeQuery("select t1.c1, count(t1.c2) from t1 cross join t2 group by t1.c1 order by t1.c1"), new String[][]{{"1", "3"}, {"2", "3"}, {"3", "0"}, {"5", "3"}, {"6", "3"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from (values 1,2) v1 cross join (values 'a','b') v2"), new String[][]{{"1", "a"}, {"1", "b"}, {"2", "a"}, {"2", "b"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 a cross join t2 b inner join t2 c on 1=1"), JoinTest.cross(T1, JoinTest.cross(T2, T2)));
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 a inner join t2 b on 1=1 cross join t2 c"), JoinTest.cross(T1, JoinTest.cross(T2, T2)));
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from t2 a cross join t1 b right join t2 c on a.c1=c.c1"), Integer.toString(T1.length * T2.length));
        String[][] expectedCorrectlyNested = new String[][]{{null, null, null, null, "4", "IV"}};
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t2 a cross join t1 b right join t2 c on b.c1=c.c1 where c.c1='4'"), expectedCorrectlyNested);
        JoinTest.assertStatementError(AMBIGUOUS_COLNAME, s, "select * from t1 cross join t1");
        JoinTest.assertStatementError(AMBIGUOUS_COLNAME, s, "select c1 from t1 cross join t2");
        JoinTest.assertStatementError(SYNTAX_ERROR, s, "select * from t1 cross join t2 on t1.c1 = t2.c2");
        JoinTest.assertStatementError(SYNTAX_ERROR, s, "select * from t1 inner join t2 cross join t2 t3");
        JoinTest.assertStatementError(SYNTAX_ERROR, s, "select * from t1 left join t2 cross join t2 t3");
        JoinTest.assertStatementError(SYNTAX_ERROR, s, "select * from t1 right join t2 cross join t2 t3");
        JoinTest.assertStatementError(SYNTAX_ERROR, s, "select * from t1 cross join t2 inner join t2 t3");
    }

    private void fillTable(String sql, String[][] data) throws SQLException {
        boolean id = false;
        PreparedStatement ins = this.prepareStatement(sql);
        for (String[] datum : data) {
            for (int j = 0; j < datum.length; ++j) {
                ins.setString(j + 1, datum[j]);
            }
            ins.executeUpdate();
        }
        ins.close();
    }

    private static String[][] cross(String[][] t1, String[][] t2) {
        String[][] result = new String[t1.length * t2.length][];
        for (int i = 0; i < result.length; ++i) {
            String[] r1 = t1[i / t2.length];
            String[] r2 = t2[i % t2.length];
            result[i] = new String[r1.length + r2.length];
            System.arraycopy(r1, 0, result[i], 0, r1.length);
            System.arraycopy(r2, 0, result[i], r1.length, r2.length);
        }
        return result;
    }

    private static String[][] project(int[] cols, String[][] rows) {
        String[][] result = new String[rows.length][cols.length];
        for (int i = 0; i < rows.length; ++i) {
            for (int j = 0; j < cols.length; ++j) {
                result[i][j] = rows[i][cols[j]];
            }
        }
        return result;
    }

    private static String[][] reverse(String[][] rows) {
        String[][] result = new String[rows.length][];
        for (int i = 0; i < rows.length; ++i) {
            result[i] = rows[rows.length - 1 - i];
        }
        return result;
    }

    public void testUsingClause() throws SQLException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("create table t1(a int, b int, c int)");
        s.execute("create table t2(b int, c int, d int)");
        s.execute("create table t3(d int, e varchar(5), f int)");
        s.execute("insert into t1 values (1,2,3),(2,3,4),(4,4,4)");
        s.execute("insert into t2 values (1,2,3),(2,3,4),(5,5,5)");
        s.execute("insert into t3 values (2,'abc',3),(4,'def',5),(6,null,null)");
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 join t2 using (b)"), new String[][]{{"2", "1", "3", "3", "4"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 inner join t2 using (b)"), new String[][]{{"2", "1", "3", "3", "4"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 left outer join t2 using (b)"), new String[][]{{"2", "1", "3", "3", "4"}, {"3", "2", "4", null, null}, {"4", "4", "4", null, null}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 right join t2 using (b)"), new String[][]{{"2", "1", "3", "3", "4"}, {"1", null, null, "2", "3"}, {"5", null, null, "5", "5"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 right outer join t2 using (b)"), new String[][]{{"2", "1", "3", "3", "4"}, {"1", null, null, "2", "3"}, {"5", null, null, "5", "5"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 join t2 using (b, c)"), new String[][]{{"2", "3", "1", "4"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 join t2 using (c, b)"), new String[][]{{"3", "2", "1", "4"}});
        JDBC.assertSingleValueResultSet(s.executeQuery("select t1.* from t1 join t2 using (b, c)"), "1");
        JDBC.assertSingleValueResultSet(s.executeQuery("select t2.* from t1 join t2 using (b, c)"), "4");
        JDBC.assertUnorderedResultSet(s.executeQuery("select t1.*, t2.* from t1 join t2 using (b, c)"), new String[][]{{"1", "4"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select t1.* from t1 left join t2 using (b, c)"), new String[][]{{"1"}, {"2"}, {"4"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select t1.* from t1 right join t2 using (b, c)"), new String[][]{{"1"}, {null}, {null}});
        JDBC.assertSingleValueResultSet(s.executeQuery("select t3.e from t1 join t2 using (b) join t3 using (d)"), "def");
        JDBC.assertSingleValueResultSet(s.executeQuery("select t3.e from t1 join t2 join t3 using (d) using (b)"), "def");
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 left join t2 using (b) right join t3 using (d)"), new String[][]{{"2", null, null, null, null, "abc", "3"}, {"4", "2", "1", "3", "3", "def", "5"}, {null, null, null, null, null, null, null}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 left join t2 right join t3 using (d) using (b)"), new String[][]{{"2", "1", "3", "4", "3", "def", "5"}, {"3", "2", "4", null, null, null, null}, {"4", "4", "4", null, null, null, null}});
        JDBC.assertSingleValueResultSet(s.executeQuery("select a from t1 join t2 using (b, c)"), "1");
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 join t2 using (\"B\")"), new String[][]{{"2", "1", "3", "3", "4"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select b from t1 left join t2 using (b)"), new String[][]{{"2"}, {"3"}, {"4"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select b from t1 right join t2 using (b)"), new String[][]{{"1"}, {"2"}, {"5"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select d, t2.d, t3.d from t2 left join t3 using (d)"), new String[][]{{"3", "3", null}, {"4", "4", "4"}, {"5", "5", null}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select d, t2.d, t3.d from t2 right join t3 using (d)"), new String[][]{{"2", null, "2"}, {"4", "4", "4"}, {null, null, null}});
        JDBC.assertEmpty(s.executeQuery("select * from t2 left join t3 using (d) where d is null"));
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t2 right join t3 using (d) where d is null"), new String[][]{{null, null, null, null, null}});
        JDBC.assertFullResultSet(s.executeQuery("select c from t1 left join t2 using (b, c) order by c desc nulls last"), new String[][]{{"4"}, {"4"}, {"3"}});
        JDBC.assertFullResultSet(s.executeQuery("select c from t1 left join t2 using (b, c) order by t1.c desc nulls last"), new String[][]{{"4"}, {"4"}, {"3"}});
        JDBC.assertFullResultSet(s.executeQuery("select c from t1 left join t2 using (b, c) order by t2.c desc nulls last"), new String[][]{{"3"}, {"4"}, {"4"}});
        JDBC.assertSingleValueResultSet(s.executeQuery("select c from t1 right join t2 using (b, c) order by c desc nulls last fetch next row only"), "5");
        JDBC.assertSingleValueResultSet(s.executeQuery("select c from t1 right join t2 using (b, c) order by t1.c desc nulls last fetch next row only"), "3");
        JDBC.assertSingleValueResultSet(s.executeQuery("select c from t1 right join t2 using (b, c) order by t2.c desc nulls last fetch next row only"), "5");
        JDBC.assertFullResultSet(s.executeQuery("select b, count(t2.b) from t1 left join t2 using (b) group by b order by b"), new String[][]{{"2", "1"}, {"3", "0"}, {"4", "0"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 table_a(col1, col2, col3) inner join t3 table_b(col1, col2, col3) using (col1)"), new String[][]{{"2", "3", "4", "abc", "3"}, {"4", "4", "4", "def", "5"}});
        JoinTest.assertStatementError(AMBIGUOUS_COLNAME, s, "select b from t1 join t2 using (b) join t3 using(c)");
        JoinTest.assertStatementError(AMBIGUOUS_COLNAME, s, "select b from t1 join t2 using (c)");
        JoinTest.assertStatementError(AMBIGUOUS_COLNAME, s, "select * from t1 join t2 using (b) order by c");
        JoinTest.assertStatementError(SYNTAX_ERROR, s, "select * from t1 join t2 using (t1.b)");
        JoinTest.assertStatementError(SYNTAX_ERROR, s, "select * from t1 join t2 using b");
        JoinTest.assertStatementError(SYNTAX_ERROR, s, "select * from t1 join t2 using ()");
        JoinTest.assertStatementError(NON_COMPARABLE, s, "select * from t2 a(x,y,z) join t3 b(x,y,z) using(y)");
        JoinTest.assertStatementError(COLUMN_NOT_IN_SCOPE, s, "select t3.e from t1 join t2 join t3 using (b) using (d)");
        JoinTest.assertStatementError(COLUMN_NOT_IN_SCOPE, s, "select * from t1 join t2 using (a)");
        JoinTest.assertStatementError(COLUMN_NOT_IN_SCOPE, s, "select * from t1 join t2 using (d)");
        JoinTest.assertStatementError(COLUMN_NOT_IN_SCOPE, s, "select * from t1 join t2 using (a,d)");
        JoinTest.assertStatementError(COLUMN_NOT_IN_SCOPE, s, "select * from t1 join t2 using (a,b,c)");
        JoinTest.assertStatementError(COLUMN_NOT_IN_SCOPE, s, "select * from t1 join t2 using (x)");
        JoinTest.assertStatementError(COLUMN_NOT_IN_SCOPE, s, "select * from t1 join t2 using (b,c,x)");
        JoinTest.assertStatementError(AMBIGUOUS_COLNAME, s, "select * from (t1 cross join t2) join t2 tt2 using(b)");
        JoinTest.assertStatementError(NO_COLUMNS, s, "select x.* from t1 x inner join t1 y using (a,b,c)");
        JoinTest.assertStatementError(NO_COLUMNS, s, "select x.* from t1 x left join t1 y using (a,b,c)");
        JoinTest.assertStatementError(NO_COLUMNS, s, "select x.* from t1 x right join t1 y using (a,b,c)");
        JoinTest.assertStatementError(NO_COLUMNS, s, "select x.*, y.* from t1 x inner join t1 y using (a, b, c)");
        JoinTest.assertStatementError(TABLE_NAME_NOT_IN_SCOPE, s, "select xyz.* from t1 join t2 using (b)");
    }

    @Test
    public void testNaturalJoin() throws SQLException {
        this.setAutoCommit(false);
        String[][] T1 = new String[][]{{"1", "2", "3"}, {"4", "5", "6"}, {"7", "8", "9"}};
        String[][] T2 = new String[][]{{"4", "3", "2"}, {"1", "2", "3"}, {"3", "2", "1"}};
        String[][] T3 = new String[][]{{"4", "100"}};
        Statement s = this.createStatement();
        s.execute("create table t1(a varchar, b varchar, c varchar)");
        s.execute("create table t2(d varchar, c varchar, b varchar)");
        s.execute("create table t3(d varchar, e varchar)");
        this.fillTable("insert into t1 values (?,?,?)", T1);
        this.fillTable("insert into t2 values (?,?,?)", T2);
        this.fillTable("insert into t3 values (?,?)", T3);
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t2 natural join t3"), new String[][]{{"4", "3", "2", "100"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t3 natural join t2"), new String[][]{{"4", "100", "3", "2"}});
        ResultSet rs = s.executeQuery("select * from t1 natural join t2");
        JDBC.assertColumnNames(rs, "B", "C", "A", "D");
        JDBC.assertUnorderedResultSet(rs, new String[][]{{"2", "3", "1", "4"}});
        rs = s.executeQuery("select * from t2 natural join t1");
        JDBC.assertColumnNames(rs, "C", "B", "D", "A");
        JDBC.assertUnorderedResultSet(rs, new String[][]{{"3", "2", "4", "1"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 natural join t3"), JoinTest.cross(T1, T3));
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 as a(c1, c2, c3) natural join t2 as b(c4, c5, c6)"), JoinTest.cross(T1, T2));
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from (values 1,2) v1(x) natural join (values 'a','b') v2(y)"), new String[][]{{"1", "a"}, {"1", "b"}, {"2", "a"}, {"2", "b"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from (select * from t1) table1 natural join (select * from t2) table2"), new String[][]{{"2", "3", "1", "4"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 natural join t2 natural join t3"), new String[][]{{"4", "2", "3", "1", "100"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 natural join t2 cross join t3"), new String[][]{{"2", "3", "1", "4", "4", "100"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 natural join t2 inner join t3 on 1=1"), new String[][]{{"2", "3", "1", "4", "4", "100"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 cross join t2 natural join t3"), new String[][]{{"4", "1", "2", "3", "3", "2", "100"}, {"4", "4", "5", "6", "3", "2", "100"}, {"4", "7", "8", "9", "3", "2", "100"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 inner join t2 on 1=1 natural join t3"), new String[][]{{"4", "1", "2", "3", "3", "2", "100"}, {"4", "4", "5", "6", "3", "2", "100"}, {"4", "7", "8", "9", "3", "2", "100"}});
        s.execute("create table insert_src (c1 varchar, c2 varchar, c3 varchar, c4 varchar)");
        s.execute("insert into insert_src select * from t1 natural join t2");
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from insert_src"), new String[][]{{"2", "3", "1", "4"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 natural inner join t2"), new String[][]{{"2", "3", "1", "4"}});
        String[][] ljRows = new String[][]{{"2", "3", "1", "4"}, {"5", "6", "4", null}, {"8", "9", "7", null}};
        JoinTest.assertStatementError(SYNTAX_ERROR, s, "select * from t1 natural join t2 on t1.b=t2.b");
        JoinTest.assertStatementError(SYNTAX_ERROR, s, "select * from t1 natural join t2 using (b)");
        JoinTest.assertStatementError(SYNTAX_ERROR, s, "select * from t1 natural cross join t2");
        JoinTest.assertStatementError(AMBIGUOUS_COLNAME, s, "select * from t1 t(d,x,y) natural join (t2 cross join t3)");
    }

    public void testSubqueryInON() throws SQLException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("create table t1(a varchar)");
        s.execute("insert into t1 values '1','2','3'");
        s.execute("create table t2(b varchar)");
        s.execute("insert into t2 values '1','2'");
        s.execute("create table t3(c varchar)");
        s.execute("insert into t3 values '2','3'");
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 join t2 on a = some (select c from t3)"), new String[][]{{"2", "1"}, {"2", "2"}, {"3", "1"}, {"3", "2"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 left join t2 on a = b and b not in (select c from t3)"), new String[][]{{"1", "1"}, {"2", null}, {"3", null}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t3 join t2 on exists (select * from t2 join t1 on exists (select * from t3 where c = a))"), new String[][]{{"2", "1"}, {"2", "2"}, {"3", "1"}, {"3", "2"}});
        JDBC.assertSingleValueResultSet(s.executeQuery("select a from t1 join t2 on a = (select count(*) from t3) and a = b"), "2");
        JDBC.assertEmpty(s.executeQuery("select * from t1 join t2 on exists (select * from t3 x left join t3 y on 1=0 where y.c=1)"));
    }

    static void insertTourRow(PreparedStatement ps, String a, String b) throws SQLException {
        ps.setString(1, a);
        ps.setString(2, b);
        ps.execute();
    }

    static void insertTourRow(PreparedStatement ps, int a, String b, String c) throws SQLException {
        ps.setInt(1, a);
        ps.setString(2, b);
        ps.setString(3, c);
        ps.execute();
    }
}

