/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb.jdbc;

import io.kareldb.jdbc.BaseJDBCTestCase;
import io.kareldb.jdbc.JDBC;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.calcite.util.TestUtil;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicTest
extends BaseJDBCTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(BasicTest.class);

    @Test
    public void testBasicAutoCommitOff() throws SQLException {
        this.testBasic(false);
    }

    @Test
    public void testBasicAutoCommitOn() throws SQLException {
        this.testBasic(true);
    }

    private void testBasic(boolean autoCommit) throws SQLException {
        try (Connection connection = this.createConnection();){
            connection.setAutoCommit(autoCommit);
            Statement s = connection.createStatement();
            boolean b = s.execute("create table t (i int not null, constraint pk primary key (i))");
            Assert.assertThat((Object)b, (Matcher)CoreMatchers.is((Object)false));
            int x = s.executeUpdate("insert into t values 1");
            Assert.assertThat((Object)x, (Matcher)CoreMatchers.is((Object)1));
            x = s.executeUpdate("insert into t values 3");
            Assert.assertThat((Object)x, (Matcher)CoreMatchers.is((Object)1));
            ResultSet resultSet = s.executeQuery("select * from t where i = 1");
            String[][] expectedRows = new String[][]{{"1"}};
            JDBC.assertFullResultSet(resultSet, expectedRows);
            resultSet.close();
            PreparedStatement ps = connection.prepareStatement("select * from t where i = ?");
            ps.setInt(1, 1);
            resultSet = ps.executeQuery();
            expectedRows = new String[][]{{"1"}};
            JDBC.assertFullResultSet(resultSet, expectedRows);
            resultSet.close();
            resultSet = s.executeQuery("select * from t");
            expectedRows = new String[][]{{"1"}, {"3"}};
            JDBC.assertFullResultSet(resultSet, expectedRows);
            resultSet.close();
            resultSet = s.executeQuery("select * from t where i > 1");
            expectedRows = new String[][]{{"3"}};
            JDBC.assertFullResultSet(resultSet, expectedRows);
            resultSet.close();
            resultSet = s.executeQuery("select * from t where i < 3");
            expectedRows = new String[][]{{"1"}};
            JDBC.assertFullResultSet(resultSet, expectedRows);
            resultSet.close();
            x = s.executeUpdate("delete from t where i = 3");
            Assert.assertThat((Object)x, (Matcher)CoreMatchers.is((Object)1));
            resultSet = s.executeQuery("select * from t");
            expectedRows = new String[][]{{"1"}};
            JDBC.assertFullResultSet(resultSet, expectedRows);
            resultSet.close();
            s = connection.createStatement();
            b = s.execute("create table t2 (i int not null, j int not null, k varchar, constraint pk primary key (j, i))");
            Assert.assertThat((Object)b, (Matcher)CoreMatchers.is((Object)false));
            x = s.executeUpdate("insert into t2 values (1, 2, 'hi')");
            Assert.assertThat((Object)x, (Matcher)CoreMatchers.is((Object)1));
            x = s.executeUpdate("insert into t2 values (3, 4, 'world')");
            Assert.assertThat((Object)x, (Matcher)CoreMatchers.is((Object)1));
            resultSet = s.executeQuery("select * from t2");
            expectedRows = new String[][]{{"1", "2", "hi"}, {"3", "4", "world"}};
            JDBC.assertFullResultSet(resultSet, expectedRows);
            resultSet.close();
            x = s.executeUpdate("update t2 set i = 10 where i = 3");
            Assert.assertThat((Object)x, (Matcher)CoreMatchers.is((Object)1));
            resultSet = s.executeQuery("select * from t2");
            expectedRows = new String[][]{{"1", "2", "hi"}, {"10", "4", "world"}};
            JDBC.assertFullResultSet(resultSet, expectedRows);
            resultSet.close();
            x = s.executeUpdate("delete from t2 where i = 10");
            Assert.assertThat((Object)x, (Matcher)CoreMatchers.is((Object)1));
            resultSet = s.executeQuery("select * from t2");
            expectedRows = new String[][]{{"1", "2", "hi"}};
            JDBC.assertFullResultSet(resultSet, expectedRows);
            resultSet.close();
            b = s.execute("alter table t2 add m varchar null, add n int null");
            Assert.assertThat((Object)b, (Matcher)CoreMatchers.is((Object)false));
            x = s.executeUpdate("insert into t2 values (5, 6, 'world', 'why', 7)");
            Assert.assertThat((Object)x, (Matcher)CoreMatchers.is((Object)1));
            resultSet = s.executeQuery("select * from t2");
            expectedRows = new String[][]{{"1", "2", "hi", null, null}, {"5", "6", "world", "why", "7"}};
            JDBC.assertFullResultSet(resultSet, expectedRows);
            resultSet.close();
            b = s.execute("alter table t2 drop n");
            Assert.assertThat((Object)b, (Matcher)CoreMatchers.is((Object)false));
            resultSet = s.executeQuery("select * from t2");
            expectedRows = new String[][]{{"1", "2", "hi", null}, {"5", "6", "world", "why"}};
            JDBC.assertFullResultSet(resultSet, expectedRows);
            resultSet.close();
            x = s.executeUpdate("update t2 set k = 'yall' where i = 5");
            Assert.assertThat((Object)x, (Matcher)CoreMatchers.is((Object)1));
            resultSet = s.executeQuery("select * from t2");
            expectedRows = new String[][]{{"1", "2", "hi", null}, {"5", "6", "yall", "why"}};
            JDBC.assertFullResultSet(resultSet, expectedRows);
            resultSet.close();
            x = s.executeUpdate("update t2 set i = 7 where i = 5");
            Assert.assertThat((Object)x, (Matcher)CoreMatchers.is((Object)1));
            resultSet = s.executeQuery("select * from t2");
            expectedRows = new String[][]{{"1", "2", "hi", null}, {"7", "6", "yall", "why"}};
            JDBC.assertFullResultSet(resultSet, expectedRows);
            resultSet.close();
            s.close();
        }
    }

    @Test
    public void testIsolation() throws SQLException {
        try (Connection connection = this.createConnection();
             Connection connection2 = this.createConnection();){
            Statement s = connection.createStatement();
            boolean b = s.execute("create table t3 (i int not null, j int not null, k varchar, constraint pk primary key (j, i))");
            Assert.assertThat((Object)b, (Matcher)CoreMatchers.is((Object)false));
            connection.commit();
            int x = s.executeUpdate("insert into t3 values (1, 2, 'hi')");
            Assert.assertThat((Object)x, (Matcher)CoreMatchers.is((Object)1));
            x = s.executeUpdate("insert into t3 values (3, 4, 'world')");
            Assert.assertThat((Object)x, (Matcher)CoreMatchers.is((Object)1));
            ResultSet resultSet = s.executeQuery("select * from t3");
            String[][] expectedRows = new String[][]{{"1", "2", "hi"}, {"3", "4", "world"}};
            JDBC.assertFullResultSet(resultSet, expectedRows);
            resultSet.close();
            Statement s2 = connection2.createStatement();
            x = s2.executeUpdate("insert into t3 values (5, 6, 'bye')");
            resultSet = s2.executeQuery("select * from t3");
            expectedRows = new String[][]{{"5", "6", "bye"}};
            JDBC.assertFullResultSet(resultSet, expectedRows);
            resultSet.close();
            resultSet = s.executeQuery("select * from t3");
            expectedRows = new String[][]{{"1", "2", "hi"}, {"3", "4", "world"}};
            JDBC.assertFullResultSet(resultSet, expectedRows);
            resultSet.close();
            x = s.executeUpdate("delete from t3 where i = 3");
            Assert.assertThat((Object)x, (Matcher)CoreMatchers.is((Object)1));
            resultSet = s.executeQuery("select * from t3");
            expectedRows = new String[][]{{"1", "2", "hi"}};
            JDBC.assertFullResultSet(resultSet, expectedRows);
            resultSet.close();
            connection2.commit();
            connection.commit();
            x = s2.executeUpdate("insert into t3 values (7, 8, 'bye')");
            resultSet = s2.executeQuery("select * from t3");
            expectedRows = new String[][]{{"1", "2", "hi"}, {"5", "6", "bye"}, {"7", "8", "bye"}};
            JDBC.assertFullResultSet(resultSet, expectedRows);
            resultSet.close();
        }
    }

    private void output(ResultSet resultSet, PrintStream out) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        int columnCount = metaData.getColumnCount();
        block0: while (resultSet.next()) {
            int i = 1;
            while (true) {
                out.print(resultSet.getString(i));
                if (i >= columnCount) {
                    out.println();
                    continue block0;
                }
                out.print(", ");
                ++i;
            }
        }
    }

    private Void output(ResultSet resultSet) {
        try {
            this.output(resultSet, System.out);
        }
        catch (SQLException e) {
            throw TestUtil.rethrow((Throwable)e);
        }
        return null;
    }
}

