/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb.transaction.client;

import io.kareldb.transaction.client.KarelDbTransaction;
import io.kareldb.transaction.client.KarelDbTransactionManager;
import io.kareldb.version.TxVersionedCache;
import io.kareldb.version.VersionedCache;
import io.kcache.utils.Streams;
import java.util.Iterator;
import org.apache.omid.transaction.Transaction;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateScanTest {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateScanTest.class);
    private static final String TEST_TABLE = "test-table";
    private Comparable[] dataValue1 = new Comparable[]{"testWrite-1"};

    @Test
    public void testGet() throws Exception {
        int[] lInts;
        KarelDbTransactionManager tm = KarelDbTransactionManager.newInstance();
        TxVersionedCache versionedCache = new TxVersionedCache(new VersionedCache(TEST_TABLE));
        Transaction t = tm.begin();
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)t));
        for (int lInt : lInts = new int[]{100, 243, 2342, 22, 1, 5, 43, 56}) {
            versionedCache.put(new Comparable[]{Integer.valueOf(lInt)}, this.dataValue1);
        }
        Comparable[] key = new Comparable[]{Integer.valueOf(22)};
        int count = (int)Streams.streamOf((Iterator)versionedCache.range(key, true, key, true)).count();
        Assert.assertEquals((String)"Count is wrong", (long)count, (long)1L);
        tm.commit(t);
        t = tm.begin();
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)t));
        count = (int)Streams.streamOf((Iterator)versionedCache.range(key, true, key, true)).count();
        Assert.assertEquals((String)"Count is wrong", (long)count, (long)1L);
        tm.commit(t);
    }

    @Test
    public void testScan() throws Exception {
        int[] lInts;
        KarelDbTransactionManager tm = KarelDbTransactionManager.newInstance();
        TxVersionedCache versionedCache = new TxVersionedCache(new VersionedCache(TEST_TABLE));
        Transaction t = tm.begin();
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)t));
        for (int lInt : lInts = new int[]{100, 243, 2342, 22, 1, 5, 43, 56}) {
            versionedCache.put(new Comparable[]{Integer.valueOf(lInt)}, this.dataValue1);
        }
        int count = (int)Streams.streamOf((Iterator)versionedCache.all()).count();
        Assert.assertEquals((String)"Count is wrong", (long)count, (long)lInts.length);
        tm.commit(t);
        t = tm.begin();
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)t));
        count = (int)Streams.streamOf((Iterator)versionedCache.all()).count();
        Assert.assertEquals((String)"Count is wrong", (long)count, (long)lInts.length);
        tm.commit(t);
    }

    @Test
    public void testScanUncommitted() throws Exception {
        int[] lIntsC;
        int[] lIntsB;
        int[] lIntsA;
        KarelDbTransactionManager tm = KarelDbTransactionManager.newInstance();
        TxVersionedCache versionedCache = new TxVersionedCache(new VersionedCache(TEST_TABLE));
        Transaction t = tm.begin();
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)t));
        for (int element : lIntsA = new int[]{100, 243, 2342, 22, 1, 5, 43, 56}) {
            versionedCache.put(new Comparable[]{Integer.valueOf(element)}, this.dataValue1);
        }
        tm.commit(t);
        Transaction tu = tm.begin();
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tu));
        for (int item : lIntsB = new int[]{105, 24, 4342, 32, 7, 3, 30, 40}) {
            versionedCache.put(new Comparable[]{Integer.valueOf(item)}, this.dataValue1);
        }
        t = tm.begin();
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)t));
        for (int value : lIntsC = new int[]{109, 224, 242, 2, 16, 59, 23, 26}) {
            versionedCache.put(new Comparable[]{Integer.valueOf(value)}, this.dataValue1);
        }
        tm.commit(t);
        t = tm.begin();
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)t));
        int count = (int)Streams.streamOf((Iterator)versionedCache.all()).count();
        Assert.assertEquals((String)"Count is wrong", (long)count, (long)(lIntsA.length + lIntsC.length));
    }
}

