/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb.transaction.client;

import io.kareldb.transaction.client.KarelDbTransaction;
import io.kareldb.transaction.client.KarelDbTransactionManager;
import io.kareldb.version.TxVersionedCache;
import io.kareldb.version.VersionedCache;
import io.kcache.utils.Streams;
import java.util.Iterator;
import org.apache.omid.transaction.RollbackException;
import org.apache.omid.transaction.Transaction;
import org.apache.omid.transaction.TransactionManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionConflictTest {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionConflictTest.class);
    private static final String TEST_TABLE = "test-table";
    private static final String TEST_TABLE2 = "test-table2";
    private Comparable[] rowId1 = new Comparable[]{"row1"};
    private Comparable[] rowId2 = new Comparable[]{"row2"};
    private Comparable[] dataValue1 = new Comparable[]{"testWrite-1"};
    private Comparable[] dataValue2 = new Comparable[]{"testWrite-2"};
    private TransactionManager tm;
    private TxVersionedCache versionedCache;
    private TxVersionedCache versionedCache2;

    @Before
    public void setUp() throws Exception {
        this.tm = KarelDbTransactionManager.newInstance();
        this.versionedCache = new TxVersionedCache(new VersionedCache(TEST_TABLE));
        this.versionedCache2 = new TxVersionedCache(new VersionedCache(TEST_TABLE2));
    }

    @After
    public void tearDown() throws Exception {
        this.tm.close();
    }

    @Test
    public void runTestWriteWriteConflict() throws Exception {
        Transaction t1 = this.tm.begin();
        LOG.info("Transaction created " + t1);
        Transaction t2 = this.tm.begin();
        LOG.info("Transaction created " + t2);
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)t1));
        this.versionedCache.put(this.rowId1, this.dataValue1);
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)t2));
        this.versionedCache.put(this.rowId1, this.dataValue2);
        this.tm.commit(t2);
        try {
            this.tm.commit(t1);
            Assert.fail((String)"Transaction should not commit successfully");
        }
        catch (RollbackException rollbackException) {
            // empty catch block
        }
    }

    @Test
    public void runTestMultiTableConflict() throws Exception {
        Transaction t1 = this.tm.begin();
        LOG.info("Transaction created " + t1);
        Transaction t2 = this.tm.begin();
        LOG.info("Transaction created " + t2);
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)t1));
        this.versionedCache.put(this.rowId1, this.dataValue1);
        this.versionedCache2.put(this.rowId1, this.dataValue1);
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)t2));
        this.versionedCache.put(this.rowId1, this.dataValue2);
        this.versionedCache2.put(this.rowId1, this.dataValue2);
        this.tm.commit(t2);
        boolean aborted = false;
        try {
            this.tm.commit(t1);
            Assert.fail((String)"Transaction committed successfully");
        }
        catch (RollbackException e) {
            aborted = true;
        }
        Assert.assertTrue((String)"Transaction didn't raise exception", (boolean)aborted);
        Transaction t3 = this.tm.begin();
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)t3));
        Assert.assertArrayEquals((Object[])this.dataValue2, (Object[])this.versionedCache2.get(this.rowId1).getValue());
    }

    @Test
    public void runTestCleanupAfterConflict() throws Exception {
        Transaction t1 = this.tm.begin();
        LOG.info("Transaction created " + t1);
        Transaction t2 = this.tm.begin();
        LOG.info("Transaction created " + t2);
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)t1));
        this.versionedCache.put(this.rowId1, this.dataValue1);
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)t2));
        this.versionedCache.put(this.rowId1, this.dataValue2);
        this.tm.commit(t1);
        boolean aborted = false;
        try {
            this.tm.commit(t2);
            Assert.fail((String)"Transaction committed successfully");
        }
        catch (RollbackException e) {
            aborted = true;
        }
        Assert.assertTrue((String)"Transaction didn't raise exception", (boolean)aborted);
        Transaction t3 = this.tm.begin();
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)t3));
        Assert.assertArrayEquals((Object[])this.dataValue1, (Object[])this.versionedCache.get(this.rowId1).getValue());
    }

    @Test
    public void testCleanupWithDeleteRow() throws Exception {
        int rowcount = 10;
        int count = 0;
        Transaction t1 = this.tm.begin();
        LOG.info("Transaction created " + t1);
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)t1));
        for (int i = 0; i < rowcount; ++i) {
            this.versionedCache.put(new Comparable[]{"test-del" + i}, this.dataValue1);
        }
        this.tm.commit(t1);
        Transaction t2 = this.tm.begin();
        LOG.info("Transaction created " + t2);
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)t2));
        this.versionedCache.remove(new Comparable[]{"test-del3"});
        count = this.countRows(this.versionedCache);
        Assert.assertEquals((String)"Wrong count", (long)count, (long)(rowcount - 1));
        Transaction t3 = this.tm.begin();
        LOG.info("Transaction created " + t3);
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)t3));
        this.versionedCache.replace(new Comparable[]{"test-del3"}, this.dataValue1, this.dataValue2);
        this.tm.commit(t3);
        boolean aborted = false;
        try {
            this.tm.commit(t2);
            Assert.fail((String)"Didn't abort");
        }
        catch (RollbackException e) {
            aborted = true;
        }
        Assert.assertTrue((String)"Didn't raise exception", (boolean)aborted);
        Transaction tscan = this.tm.begin();
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tscan));
        count = this.countRows(this.versionedCache);
        Assert.assertEquals((String)"Wrong count", (long)count, (long)rowcount);
    }

    public int countRows(TxVersionedCache cache) {
        return (int)Streams.streamOf((Iterator)cache.all()).count();
    }

    @Test
    public void testBatchedCleanup() throws Exception {
        int rowcount = 10;
        boolean count = false;
        Transaction t1 = this.tm.begin();
        LOG.info("Transaction created " + t1);
        Transaction t2 = this.tm.begin();
        LOG.info("Transaction created " + t2);
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)t1));
        this.versionedCache.put(this.rowId1, this.dataValue1);
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)t2));
        this.versionedCache.put(this.rowId1, this.dataValue2);
        for (int i = 0; i < rowcount; ++i) {
            this.versionedCache.put(new Comparable[]{"test-del" + i}, this.dataValue2);
            this.versionedCache2.put(new Comparable[]{"test-del" + i}, this.dataValue2);
        }
        Assert.assertEquals((String)"Unexpected size for read.", (long)this.countRows(this.versionedCache), (long)(rowcount + 1));
        Assert.assertEquals((String)"Unexpected size for read.", (long)this.countRows(this.versionedCache2), (long)rowcount);
        this.tm.commit(t1);
        boolean aborted = false;
        try {
            this.tm.commit(t2);
            Assert.fail((String)"Transaction commited successfully");
        }
        catch (RollbackException e) {
            aborted = true;
        }
        Assert.assertTrue((String)"Transaction didn't raise exception", (boolean)aborted);
        Transaction tscan = this.tm.begin();
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tscan));
        Assert.assertEquals((String)"Unexpected size for read.", (long)this.countRows(this.versionedCache), (long)1L);
        Assert.assertEquals((String)"Unexpected size for read.", (long)this.countRows(this.versionedCache2), (long)0L);
    }
}

