/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb.transaction.client;

import io.kareldb.transaction.client.KarelDbTransaction;
import io.kareldb.transaction.client.KarelDbTransactionManager;
import io.kareldb.version.TxVersionedCache;
import io.kareldb.version.VersionedCache;
import org.apache.omid.transaction.Transaction;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiplePutTest {
    private static final Logger LOG = LoggerFactory.getLogger(MultiplePutTest.class);
    private static final String TEST_TABLE = "test-table";

    @Test
    public void testManyManyPutsInDifferentRowsAreInTheTableAfterCommit() throws Exception {
        int NUM_ROWS_TO_ADD = 50;
        KarelDbTransactionManager tm = KarelDbTransactionManager.newInstance();
        TxVersionedCache versionedCache = new TxVersionedCache(new VersionedCache(TEST_TABLE));
        Transaction tx = tm.begin();
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tx));
        for (int i = 0; i <= 50; ++i) {
            versionedCache.put(new Comparable[]{Integer.valueOf(i)}, new Comparable[]{"testData" + i});
        }
        tm.commit(tx);
        tx = tm.begin();
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tx));
        Assert.assertArrayEquals((Object[])new Comparable[]{"testData0"}, (Object[])versionedCache.get(new Comparable[]{Integer.valueOf(0)}).getValue());
        Assert.assertArrayEquals((Object[])new Comparable[]{"testData50"}, (Object[])versionedCache.get(new Comparable[]{Integer.valueOf(50)}).getValue());
    }

    @Test
    public void testGetFromNonExistentRowAfterMultiplePutsReturnsNoResult() throws Exception {
        int NUM_ROWS_TO_ADD = 10;
        KarelDbTransactionManager tm = KarelDbTransactionManager.newInstance();
        TxVersionedCache versionedCache = new TxVersionedCache(new VersionedCache(TEST_TABLE));
        Transaction tx = tm.begin();
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tx));
        for (int i = 0; i <= 10; ++i) {
            versionedCache.put(new Comparable[]{Integer.valueOf(i)}, new Comparable[]{"testData" + i});
        }
        tm.commit(tx);
        tx = tm.begin();
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tx));
        Assert.assertNull((Object)versionedCache.get(new Comparable[]{Integer.valueOf(15)}));
    }
}

