/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb.transaction.client;

import io.kareldb.transaction.client.KarelDbTransaction;
import io.kareldb.transaction.client.KarelDbTransactionManager;
import io.kareldb.version.TxVersionedCache;
import io.kareldb.version.VersionedCache;
import io.kcache.KeyValueIterator;
import io.kcache.utils.Streams;
import java.util.Iterator;
import org.apache.omid.transaction.Transaction;
import org.apache.omid.transaction.TransactionManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeletionTest {
    private static final Logger LOG = LoggerFactory.getLogger(DeletionTest.class);
    private static final String TEST_TABLE = "test-table";
    private Comparable[] dataValue1 = new Comparable[]{"testWrite-1"};
    private TransactionManager tm;
    private TxVersionedCache versionedCache;

    @Before
    public void setUp() throws Exception {
        this.tm = KarelDbTransactionManager.newInstance();
        this.versionedCache = new TxVersionedCache(new VersionedCache(TEST_TABLE));
    }

    @After
    public void tearDown() throws Exception {
        this.tm.close();
    }

    @Test
    public void runTestDeleteRow() throws Exception {
        Transaction t1 = this.tm.begin();
        LOG.info("Transaction created " + t1);
        int rowsWritten = 10;
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)t1));
        this.writeRows(this.versionedCache, rowsWritten);
        this.tm.commit(t1);
        Transaction t2 = this.tm.begin();
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)t2));
        this.versionedCache.remove(new Comparable[]{"test-del0"});
        Transaction tscan = this.tm.begin();
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tscan));
        KeyValueIterator iter = this.versionedCache.range(new Comparable[]{"test-del0"}, true, new Comparable[]{"test-del9"}, true);
        int rowsRead = (int)Streams.streamOf((Iterator)iter).count();
        Assert.assertEquals((String)("Expected " + rowsWritten + " rows but " + rowsRead + " found"), (long)rowsRead, (long)rowsWritten);
        this.tm.commit(t2);
        tscan = this.tm.begin();
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tscan));
        iter = this.versionedCache.range(new Comparable[]{"test-del0"}, true, new Comparable[]{"test-del9"}, true);
        rowsRead = (int)Streams.streamOf((Iterator)iter).count();
        Assert.assertEquals((String)("Expected " + (rowsWritten - 1) + " rows but " + rowsRead + " found"), (long)rowsRead, (long)(rowsWritten - 1));
    }

    private void writeRows(TxVersionedCache versionCache, int rowcount) {
        for (int i = 0; i < rowcount; ++i) {
            Comparable[] row = new Comparable[]{"test-del" + i};
            versionCache.put(row, this.dataValue1);
        }
    }
}

