/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb.file;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import io.kareldb.KarelDbEngine;
import java.io.PrintStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.function.Consumer;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.util.Sources;
import org.apache.calcite.util.TestUtil;
import org.apache.calcite.util.Util;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TableTest {
    @After
    public void tearDown() throws Exception {
        KarelDbEngine.closeInstance();
    }

    private void close(Connection connection, Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testBadDirectory() throws SQLException {
        Properties info = new Properties();
        info.put("model", "inline:{\n  version: '1.0',\n   schemas: [\n     {\n       type: 'custom',\n       name: 'bad',\n       factory: 'io.kareldb.schema.SchemaFactory',\n       operand: {\n         kind: 'io.kareldb.csv.CsvSchema',\n         directory: '/does/not/exist'\n       }\n     }\n   ]\n}");
        Connection connection = DriverManager.getConnection("jdbc:kareldb:", info);
        ResultSet tables = connection.getMetaData().getTables(null, null, null, null);
        tables.next();
        tables.close();
        connection.close();
    }

    @Test
    public void testSelect() throws SQLException {
        this.sql("model", "select * from EMPS").ok();
    }

    @Test
    public void testCreateTable() throws SQLException {
        try (Connection connection = DriverManager.getConnection("jdbc:kareldb:", new PropBuilder().set(CalciteConnectionProperty.MODEL, this.jsonPath("model")).set(CalciteConnectionProperty.PARSER_FACTORY, "org.apache.calcite.sql.ddl.ExtensionDdlExecutor#PARSER_FACTORY").build());){
            Statement s = connection.createStatement();
            boolean b = s.execute("create table t (i int not null, constraint pk primary key (i))");
            Assert.assertThat((Object)b, (Matcher)CoreMatchers.is((Object)false));
            int x = s.executeUpdate("insert into t values 1");
            Assert.assertThat((Object)x, (Matcher)CoreMatchers.is((Object)1));
            x = s.executeUpdate("insert into t values 3");
            Assert.assertThat((Object)x, (Matcher)CoreMatchers.is((Object)1));
            ResultSet resultSet = s.executeQuery("select * from t");
            this.output(resultSet);
            resultSet.close();
            x = s.executeUpdate("delete from t where i = 3");
            Assert.assertThat((Object)x, (Matcher)CoreMatchers.is((Object)1));
            resultSet = s.executeQuery("select * from t");
            this.output(resultSet);
            resultSet.close();
            s = connection.createStatement();
            b = s.execute("create table t2 (i int not null, j int not null, k varchar, constraint pk primary key (j, i))");
            Assert.assertThat((Object)b, (Matcher)CoreMatchers.is((Object)false));
            x = s.executeUpdate("insert into t2 values (1, 2, 'hi')");
            Assert.assertThat((Object)x, (Matcher)CoreMatchers.is((Object)1));
            x = s.executeUpdate("insert into t2 values (3, 4, 'world')");
            Assert.assertThat((Object)x, (Matcher)CoreMatchers.is((Object)1));
            resultSet = s.executeQuery("select * from t2");
            this.output(resultSet);
            resultSet.close();
            x = s.executeUpdate("delete from t2 where i = 3");
            Assert.assertThat((Object)x, (Matcher)CoreMatchers.is((Object)1));
            resultSet = s.executeQuery("select * from t2");
            this.output(resultSet);
            resultSet.close();
            String sql = "select * from EMPS";
            resultSet = s.executeQuery(sql);
            this.output(resultSet);
            resultSet.close();
            s.close();
        }
    }

    @Test
    public void testAvroSelect() throws SQLException {
        this.sql("avro", "select * from \"users\"").ok();
        this.sql("avro", "select \"name\" from \"users\"").ok();
    }

    @Test
    public void testAvroCreateTable() throws SQLException {
        try (Connection connection = DriverManager.getConnection("jdbc:kareldb:", new PropBuilder().set(CalciteConnectionProperty.MODEL, this.jsonPath("avro")).set(CalciteConnectionProperty.PARSER_FACTORY, "org.apache.calcite.sql.ddl.ExtensionDdlExecutor#PARSER_FACTORY").build());){
            Statement s = connection.createStatement();
            boolean b = s.execute("create table t (i int not null, constraint pk primary key (i))");
            Assert.assertThat((Object)b, (Matcher)CoreMatchers.is((Object)false));
            int x = s.executeUpdate("insert into t values 1");
            Assert.assertThat((Object)x, (Matcher)CoreMatchers.is((Object)1));
            x = s.executeUpdate("insert into t values 3");
            Assert.assertThat((Object)x, (Matcher)CoreMatchers.is((Object)1));
            ResultSet resultSet = s.executeQuery("select * from t");
            this.output(resultSet);
            resultSet.close();
            x = s.executeUpdate("delete from t where i = 3");
            Assert.assertThat((Object)x, (Matcher)CoreMatchers.is((Object)1));
            resultSet = s.executeQuery("select * from t");
            this.output(resultSet);
            resultSet.close();
            s = connection.createStatement();
            b = s.execute("create table t2 (i int not null, j int not null, k varchar, constraint pk primary key (j, i))");
            Assert.assertThat((Object)b, (Matcher)CoreMatchers.is((Object)false));
            x = s.executeUpdate("insert into t2 values (1, 2, 'hi')");
            Assert.assertThat((Object)x, (Matcher)CoreMatchers.is((Object)1));
            x = s.executeUpdate("insert into t2 values (3, 4, 'world')");
            Assert.assertThat((Object)x, (Matcher)CoreMatchers.is((Object)1));
            resultSet = s.executeQuery("select * from t2");
            this.output(resultSet);
            resultSet.close();
            resultSet = s.executeQuery("select * from t2 where i = 1 and j = 2");
            this.output(resultSet);
            resultSet.close();
            resultSet = s.executeQuery("select * from t2 where i >= 1 and j >= 2 and i < 3 and j < 4");
            this.output(resultSet);
            resultSet.close();
            x = s.executeUpdate("delete from t2 where i = 3");
            Assert.assertThat((Object)x, (Matcher)CoreMatchers.is((Object)1));
            resultSet = s.executeQuery("select * from t2");
            this.output(resultSet);
            resultSet.close();
            String sql = "select * from \"users\"";
            resultSet = s.executeQuery(sql);
            this.output(resultSet);
            resultSet.close();
            s.close();
        }
    }

    @Test
    public void testInsertOne() throws SQLException {
        Properties info = new Properties();
        info.put("model", this.jsonPath("model"));
        try (Connection connection = DriverManager.getConnection("jdbc:kareldb:", info);){
            String sql = "insert into EMPS (empno, name, deptno, gender, city,\n  empid, age, slacker, manager, joinedat)\nvalues(140, 'Bob', 140, 'F', 'Belmont',\n  140, 140, true, false, date '1970-01-01')";
            Statement statement = connection.createStatement();
            statement.executeUpdate(sql);
            sql = "select * from EMPS";
            ResultSet resultSet = statement.executeQuery(sql);
            this.output(resultSet);
            resultSet.close();
            statement.close();
        }
    }

    @Test
    public void testSelectLongMultiplyInteger() throws SQLException {
        String sql = "select empno * 3 as e3\nfrom long_emps where empno = 100";
        this.sql("bug", "select empno * 3 as e3\nfrom long_emps where empno = 100").checking(resultSet -> {
            try {
                Assert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)true));
                Long o = (Long)resultSet.getObject(1);
                Assert.assertThat((Object)o, (Matcher)CoreMatchers.is((Object)300L));
                Assert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)false));
            }
            catch (SQLException e) {
                throw TestUtil.rethrow((Throwable)e);
            }
        }).ok();
    }

    @Test
    public void testPushDownProjectDumb() throws SQLException {
        String sql = "explain plan for select * from EMPS";
        String expected = "PLAN=EnumerableTableScan(table=[[SALES, EMPS]])\n";
        this.sql("model", "explain plan for select * from EMPS").returns("PLAN=EnumerableTableScan(table=[[SALES, EMPS]])\n").ok();
    }

    @Test
    public void testFilterableSelect() throws SQLException {
        this.sql("filterable-model", "select name from EMPS").ok();
    }

    @Test
    public void testFilterableSelectStar() throws SQLException {
        this.sql("filterable-model", "select * from EMPS").ok();
    }

    @Test
    public void testFilterableWhere() throws SQLException {
        String sql = "select empno, gender, name from EMPS where name = 'Eric'";
        this.sql("filterable-model", "select empno, gender, name from EMPS where name = 'Eric'").returns("EMPNO=110; GENDER=M; NAME=Eric").ok();
    }

    @Test
    public void testFilterableWhere2() throws SQLException {
        String sql = "select empno, gender, name from EMPS\n where gender = 'F' and empno > 125";
        this.sql("filterable-model", "select empno, gender, name from EMPS\n where gender = 'F' and empno > 125").returns("EMPNO=130; GENDER=F; NAME=Alice").ok();
    }

    @Test
    public void testFilterableWhere3() throws SQLException {
        String sql = "select empno, gender, name from EMPS\n where gender <> 'M' and empno > 125";
        this.sql("filterable-model", "select empno, gender, name from EMPS\n where gender <> 'M' and empno > 125").returns("EMPNO=130; GENDER=F; NAME=Alice").ok();
    }

    @Test
    public void testFilterableWhereWithNot1() throws SQLException {
        this.sql("filterable-model", "select name, empno from EMPS where name like '%E%' and city not like '%W%' ").returns("NAME=Eric; EMPNO=110").ok();
    }

    @Test
    public void testFilterableWhereWithNot2() throws SQLException {
        this.sql("filterable-model", "select name, empno from EMPS where name like '%i%' and name not like '%W%' ").returns("NAME=Eric; EMPNO=110", "NAME=Alice; EMPNO=130").ok();
    }

    private Fluent sql(String model, String sql) {
        return new Fluent(model, sql, this::output);
    }

    private static Consumer<ResultSet> expect(String ... expected) {
        return resultSet -> {
            try {
                ArrayList<String> lines = new ArrayList<String>();
                TableTest.collect(lines, resultSet);
                Assert.assertEquals(Arrays.asList(expected), lines);
            }
            catch (SQLException e) {
                throw TestUtil.rethrow((Throwable)e);
            }
        };
    }

    private static Consumer<ResultSet> expectUnordered(String ... expected) {
        ImmutableList expectedLines = Ordering.natural().immutableSortedCopy(Arrays.asList(expected));
        return arg_0 -> TableTest.lambda$expectUnordered$2((List)expectedLines, arg_0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSql(String sql, String model, Consumer<ResultSet> fn) throws SQLException {
        Connection connection = null;
        Statement statement = null;
        try {
            Properties info = new Properties();
            info.put("model", this.jsonPath(model));
            connection = DriverManager.getConnection("jdbc:kareldb:", info);
            statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(sql);
            fn.accept(resultSet);
            this.close(connection, statement);
        }
        catch (Throwable throwable) {
            this.close(connection, statement);
            throw throwable;
        }
    }

    private String jsonPath(String model) {
        return this.resourcePath(model + ".json");
    }

    private String resourcePath(String path) {
        return Sources.of((URL)TableTest.class.getResource("/" + path)).file().getAbsolutePath();
    }

    private static void collect(List<String> result, ResultSet resultSet) throws SQLException {
        StringBuilder buf = new StringBuilder();
        while (resultSet.next()) {
            buf.setLength(0);
            int n = resultSet.getMetaData().getColumnCount();
            String sep = "";
            for (int i = 1; i <= n; ++i) {
                buf.append(sep).append(resultSet.getMetaData().getColumnLabel(i)).append("=").append(resultSet.getString(i));
                sep = "; ";
            }
            result.add(Util.toLinux((String)buf.toString()));
        }
    }

    private void output(ResultSet resultSet, PrintStream out) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        int columnCount = metaData.getColumnCount();
        block0: while (resultSet.next()) {
            int i = 1;
            while (true) {
                out.print(resultSet.getString(i));
                if (i >= columnCount) {
                    out.println();
                    continue block0;
                }
                out.print(", ");
                ++i;
            }
        }
    }

    @Test
    public void testWackyColumns() throws SQLException {
        String sql = "select * from wacky_column_names where false";
        this.sql("bug", "select * from wacky_column_names where false").returns(new String[0]).ok();
        String sql2 = "select \"joined at\", \"naME\"\nfrom wacky_column_names\nwhere \"2gender\" = 'F'";
        this.sql("bug", "select \"joined at\", \"naME\"\nfrom wacky_column_names\nwhere \"2gender\" = 'F'").returns("joined at=2005-09-07; naME=Wilma", "joined at=2007-01-01; naME=Alice").ok();
    }

    @Test
    public void testGroupByTimestampAdd() throws SQLException {
        String sql = "select count(*) as c,\n  {fn timestampadd(SQL_TSI_DAY, 1, JOINEDAT) } as t\nfrom EMPS group by {fn timestampadd(SQL_TSI_DAY, 1, JOINEDAT ) } ";
        this.sql("model", "select count(*) as c,\n  {fn timestampadd(SQL_TSI_DAY, 1, JOINEDAT) } as t\nfrom EMPS group by {fn timestampadd(SQL_TSI_DAY, 1, JOINEDAT ) } ").returnsUnordered("C=1; T=1996-08-04", "C=1; T=2005-09-08", "C=1; T=2007-01-02", "C=1; T=2001-01-02").ok();
        String sql2 = "select count(*) as c,\n  {fn timestampadd(SQL_TSI_MONTH, 1, JOINEDAT) } as t\nfrom EMPS group by {fn timestampadd(SQL_TSI_MONTH, 1, JOINEDAT ) } ";
        this.sql("model", "select count(*) as c,\n  {fn timestampadd(SQL_TSI_MONTH, 1, JOINEDAT) } as t\nfrom EMPS group by {fn timestampadd(SQL_TSI_MONTH, 1, JOINEDAT ) } ").returnsUnordered("C=1; T=2005-10-07", "C=1; T=2007-02-01", "C=1; T=2001-02-01", "C=1; T=1996-09-03").ok();
    }

    @Test
    public void testUnionGroupByWithoutGroupKey() {
        String sql = "select count(*) as c1 from EMPS group by NAME\nunion\nselect count(*) as c1 from EMPS group by NAME";
        this.sql("model", "select count(*) as c1 from EMPS group by NAME\nunion\nselect count(*) as c1 from EMPS group by NAME").ok();
    }

    private String range(int first, int count) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            sb.append(i == 0 ? "(" : ", ").append(first + i);
        }
        return sb.append(')').toString();
    }

    @Test
    public void testDateType() throws SQLException {
        Properties info = new Properties();
        info.put("model", this.jsonPath("bug"));
        try (Connection connection = DriverManager.getConnection("jdbc:kareldb:", info);){
            ResultSet res = connection.getMetaData().getColumns(null, null, "DATE", "JOINEDAT");
            res.next();
            Assert.assertEquals((long)res.getInt("DATA_TYPE"), (long)91L);
            res = connection.getMetaData().getColumns(null, null, "DATE", "JOINTIME");
            res.next();
            Assert.assertEquals((long)res.getInt("DATA_TYPE"), (long)92L);
            res = connection.getMetaData().getColumns(null, null, "DATE", "JOINTIMES");
            res.next();
            Assert.assertEquals((long)res.getInt("DATA_TYPE"), (long)93L);
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("select \"JOINEDAT\", \"JOINTIME\", \"JOINTIMES\" from \"DATE\" where EMPNO = 100");
            resultSet.next();
            Assert.assertEquals(Date.class, resultSet.getDate(1).getClass());
            Assert.assertEquals((Object)Date.valueOf("1996-08-03"), (Object)resultSet.getDate(1));
            Assert.assertEquals(Time.class, resultSet.getTime(2).getClass());
            Assert.assertEquals((Object)Time.valueOf("00:01:02"), (Object)resultSet.getTime(2));
            Assert.assertEquals(Timestamp.class, resultSet.getTimestamp(3).getClass());
            Assert.assertEquals((Object)Timestamp.valueOf("1996-08-03 00:01:02"), (Object)resultSet.getTimestamp(3));
        }
    }

    @Test
    public void testDateType2() throws SQLException {
        Properties info = new Properties();
        info.put("model", this.jsonPath("bug"));
        try (Connection connection = DriverManager.getConnection("jdbc:kareldb:", info);){
            Statement statement = connection.createStatement();
            String sql = "select * from \"DATE\"\nwhere EMPNO >= 140 and EMPNO < 200";
            ResultSet resultSet = statement.executeQuery("select * from \"DATE\"\nwhere EMPNO >= 140 and EMPNO < 200");
            int n = 0;
            block13: while (resultSet.next()) {
                ++n;
                int empId = resultSet.getInt(1);
                String date = resultSet.getString(2);
                String time = resultSet.getString(3);
                String timestamp = resultSet.getString(4);
                Assert.assertThat((Object)date, (Matcher)CoreMatchers.is((Object)"2015-12-31"));
                switch (empId) {
                    case 140: {
                        Assert.assertThat((Object)time, (Matcher)CoreMatchers.is((Object)"07:15:56"));
                        Assert.assertThat((Object)timestamp, (Matcher)CoreMatchers.is((Object)"2015-12-31 07:15:56"));
                        continue block13;
                    }
                    case 150: {
                        Assert.assertThat((Object)time, (Matcher)CoreMatchers.is((Object)"13:31:21"));
                        Assert.assertThat((Object)timestamp, (Matcher)CoreMatchers.is((Object)"2015-12-31 13:31:21"));
                        continue block13;
                    }
                }
                throw new AssertionError();
            }
            Assert.assertThat((Object)n, (Matcher)CoreMatchers.is((Object)2));
            resultSet.close();
            statement.close();
        }
    }

    @Test
    public void testTimestampGroupBy() throws SQLException {
        Properties info = new Properties();
        info.put("model", this.jsonPath("bug"));
        String sql = "select \"EMPNO\", \"JOINTIMES\"\nfrom (select * from \"DATE\" limit 1)\ngroup by \"EMPNO\",\"JOINTIMES\"";
        try (Connection connection = DriverManager.getConnection("jdbc:kareldb:", info);
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery("select \"EMPNO\", \"JOINTIMES\"\nfrom (select * from \"DATE\" limit 1)\ngroup by \"EMPNO\",\"JOINTIMES\"");){
            Assert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)true));
            Timestamp timestamp = resultSet.getTimestamp(2);
            Assert.assertThat((Object)timestamp, (Matcher)CoreMatchers.isA(Timestamp.class));
            Assert.assertThat((Object)timestamp, (Matcher)CoreMatchers.is((Object)Timestamp.valueOf("1996-08-03 00:01:02.0")));
        }
    }

    @Test
    public void testTimestampOrderBy() throws SQLException {
        Properties info = new Properties();
        info.put("model", this.jsonPath("bug"));
        String sql = "select \"EMPNO\",\"JOINTIMES\" from \"DATE\"\norder by \"JOINTIMES\"";
        try (Connection connection = DriverManager.getConnection("jdbc:kareldb:", info);
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery("select \"EMPNO\",\"JOINTIMES\" from \"DATE\"\norder by \"JOINTIMES\"");){
            Assert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)true));
            Timestamp timestamp = resultSet.getTimestamp(2);
            Assert.assertThat((Object)timestamp, (Matcher)CoreMatchers.is((Object)Timestamp.valueOf("1996-08-03 00:01:02")));
        }
    }

    @Test
    public void testTimestampGroupByAndOrderBy() throws SQLException {
        Properties info = new Properties();
        info.put("model", this.jsonPath("bug"));
        String sql = "select \"EMPNO\", \"JOINTIMES\" from \"DATE\"\ngroup by \"EMPNO\",\"JOINTIMES\" order by \"JOINTIMES\"";
        try (Connection connection = DriverManager.getConnection("jdbc:kareldb:", info);
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery("select \"EMPNO\", \"JOINTIMES\" from \"DATE\"\ngroup by \"EMPNO\",\"JOINTIMES\" order by \"JOINTIMES\"");){
            Assert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)true));
            Timestamp timestamp = resultSet.getTimestamp(2);
            Assert.assertThat((Object)timestamp, (Matcher)CoreMatchers.is((Object)Timestamp.valueOf("1996-08-03 00:01:02")));
        }
    }

    @Test
    public void testFilterOnNullableTimestamp() throws Exception {
        Properties info = new Properties();
        info.put("model", this.jsonPath("bug"));
        try (Connection connection = DriverManager.getConnection("jdbc:kareldb:", info);){
            Statement statement = connection.createStatement();
            String sql1 = "select JOINEDAT from \"DATE\"\nwhere JOINEDAT < {d '2000-01-01'}\nor JOINEDAT >= {d '2017-01-01'}";
            ResultSet joinedAt = statement.executeQuery("select JOINEDAT from \"DATE\"\nwhere JOINEDAT < {d '2000-01-01'}\nor JOINEDAT >= {d '2017-01-01'}");
            Assert.assertThat((Object)joinedAt.next(), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)joinedAt.getDate(1), (Matcher)CoreMatchers.is((Object)Date.valueOf("1996-08-03")));
            String sql2 = "select JOINTIME from \"DATE\"\nwhere JOINTIME >= {t '07:00:00'}\nand JOINTIME < {t '08:00:00'}";
            ResultSet joinTime = statement.executeQuery("select JOINTIME from \"DATE\"\nwhere JOINTIME >= {t '07:00:00'}\nand JOINTIME < {t '08:00:00'}");
            Assert.assertThat((Object)joinTime.next(), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)joinTime.getTime(1), (Matcher)CoreMatchers.is((Object)Time.valueOf("07:15:56")));
            String sql3 = "select JOINTIMES,\n  {fn timestampadd(SQL_TSI_DAY, 1, JOINTIMES)}\nfrom \"DATE\"\nwhere (JOINTIMES >= {ts '2003-01-01 00:00:00'}\nand JOINTIMES < {ts '2006-01-01 00:00:00'})\nor (JOINTIMES >= {ts '2003-01-01 00:00:00'}\nand JOINTIMES < {ts '2007-01-01 00:00:00'})";
            ResultSet joinTimes = statement.executeQuery("select JOINTIMES,\n  {fn timestampadd(SQL_TSI_DAY, 1, JOINTIMES)}\nfrom \"DATE\"\nwhere (JOINTIMES >= {ts '2003-01-01 00:00:00'}\nand JOINTIMES < {ts '2006-01-01 00:00:00'})\nor (JOINTIMES >= {ts '2003-01-01 00:00:00'}\nand JOINTIMES < {ts '2007-01-01 00:00:00'})");
            Assert.assertThat((Object)joinTimes.next(), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)joinTimes.getTimestamp(1), (Matcher)CoreMatchers.is((Object)Timestamp.valueOf("2005-09-07 00:00:00")));
            Assert.assertThat((Object)joinTimes.getTimestamp(2), (Matcher)CoreMatchers.is((Object)Timestamp.valueOf("2005-09-08 00:00:00")));
            String sql4 = "select JOINTIMES, extract(year from JOINTIMES)\nfrom \"DATE\"";
            ResultSet joinTimes2 = statement.executeQuery("select JOINTIMES, extract(year from JOINTIMES)\nfrom \"DATE\"");
            Assert.assertThat((Object)joinTimes2.next(), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)joinTimes2.getTimestamp(1), (Matcher)CoreMatchers.is((Object)Timestamp.valueOf("1996-08-03 00:01:02")));
        }
    }

    @Test
    public void testFilterOnNullableTimestamp2() throws Exception {
        Properties info = new Properties();
        info.put("model", this.jsonPath("bug"));
        try (Connection connection = DriverManager.getConnection("jdbc:kareldb:", info);){
            Statement statement = connection.createStatement();
            String sql1 = "select extract(year from JOINTIMES)\nfrom \"DATE\"\nwhere extract(year from JOINTIMES) in (2006, 2007)";
            ResultSet joinTimes = statement.executeQuery("select extract(year from JOINTIMES)\nfrom \"DATE\"\nwhere extract(year from JOINTIMES) in (2006, 2007)");
            Assert.assertThat((Object)joinTimes.next(), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)joinTimes.getInt(1), (Matcher)CoreMatchers.is((Object)2007));
            String sql2 = "select extract(year from JOINTIMES),\n  count(0) from \"DATE\"\nwhere extract(year from JOINTIMES) between 2007 and 2016\ngroup by extract(year from JOINTIMES)";
            ResultSet joinTimes2 = statement.executeQuery("select extract(year from JOINTIMES),\n  count(0) from \"DATE\"\nwhere extract(year from JOINTIMES) between 2007 and 2016\ngroup by extract(year from JOINTIMES)");
            Assert.assertThat((Object)joinTimes2.next(), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)joinTimes2.getInt(1), (Matcher)CoreMatchers.is((Object)2007));
            Assert.assertThat((Object)joinTimes2.getLong(2), (Matcher)CoreMatchers.is((Object)1L));
            Assert.assertThat((Object)joinTimes2.next(), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)joinTimes2.getInt(1), (Matcher)CoreMatchers.is((Object)2015));
            Assert.assertThat((Object)joinTimes2.getLong(2), (Matcher)CoreMatchers.is((Object)2L));
        }
    }

    @Test
    public void testNonNullFilterOnDateType() throws SQLException {
        Properties info = new Properties();
        info.put("model", this.jsonPath("bug"));
        try (Connection connection = DriverManager.getConnection("jdbc:kareldb:", info);){
            Statement statement = connection.createStatement();
            String sql1 = "select JOINEDAT from \"DATE\"\nwhere JOINEDAT is not null";
            ResultSet joinedAt = statement.executeQuery("select JOINEDAT from \"DATE\"\nwhere JOINEDAT is not null");
            Assert.assertThat((Object)joinedAt.next(), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat(joinedAt.getDate(1).getClass(), (Matcher)CoreMatchers.equalTo(Date.class));
            Assert.assertThat((Object)joinedAt.getDate(1), (Matcher)CoreMatchers.is((Object)Date.valueOf("1996-08-03")));
            String sql2 = "select JOINTIME from \"DATE\"\nwhere JOINTIME is not null";
            ResultSet joinTime = statement.executeQuery("select JOINTIME from \"DATE\"\nwhere JOINTIME is not null");
            Assert.assertThat((Object)joinTime.next(), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat(joinTime.getTime(1).getClass(), (Matcher)CoreMatchers.equalTo(Time.class));
            Assert.assertThat((Object)joinTime.getTime(1), (Matcher)CoreMatchers.is((Object)Time.valueOf("00:01:02")));
            String sql3 = "select JOINTIMES from \"DATE\"\nwhere JOINTIMES is not null";
            ResultSet joinTimes = statement.executeQuery("select JOINTIMES from \"DATE\"\nwhere JOINTIMES is not null");
            Assert.assertThat((Object)joinTimes.next(), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat(joinTimes.getTimestamp(1).getClass(), (Matcher)CoreMatchers.equalTo(Timestamp.class));
            Assert.assertThat((Object)joinTimes.getTimestamp(1), (Matcher)CoreMatchers.is((Object)Timestamp.valueOf("1996-08-03 00:01:02")));
        }
    }

    @Test
    public void testGreaterThanFilterOnDateType() throws SQLException {
        Properties info = new Properties();
        info.put("model", this.jsonPath("bug"));
        try (Connection connection = DriverManager.getConnection("jdbc:kareldb:", info);){
            Statement statement = connection.createStatement();
            String sql1 = "select JOINEDAT from \"DATE\"\nwhere JOINEDAT > {d '1990-01-01'}";
            ResultSet joinedAt = statement.executeQuery("select JOINEDAT from \"DATE\"\nwhere JOINEDAT > {d '1990-01-01'}");
            Assert.assertThat((Object)joinedAt.next(), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat(joinedAt.getDate(1).getClass(), (Matcher)CoreMatchers.equalTo(Date.class));
            Assert.assertThat((Object)joinedAt.getDate(1), (Matcher)CoreMatchers.is((Object)Date.valueOf("1996-08-03")));
            String sql2 = "select JOINTIME from \"DATE\"\nwhere JOINTIME > {t '00:00:00'}";
            ResultSet joinTime = statement.executeQuery("select JOINTIME from \"DATE\"\nwhere JOINTIME > {t '00:00:00'}");
            Assert.assertThat((Object)joinTime.next(), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat(joinTime.getTime(1).getClass(), (Matcher)CoreMatchers.equalTo(Time.class));
            Assert.assertThat((Object)joinTime.getTime(1), (Matcher)CoreMatchers.is((Object)Time.valueOf("00:01:02")));
            String sql3 = "select JOINTIMES from \"DATE\"\nwhere JOINTIMES > {ts '1990-01-01 00:00:00'}";
            ResultSet joinTimes = statement.executeQuery("select JOINTIMES from \"DATE\"\nwhere JOINTIMES > {ts '1990-01-01 00:00:00'}");
            Assert.assertThat((Object)joinTimes.next(), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat(joinTimes.getTimestamp(1).getClass(), (Matcher)CoreMatchers.equalTo(Timestamp.class));
            Assert.assertThat((Object)joinTimes.getTimestamp(1), (Matcher)CoreMatchers.is((Object)Timestamp.valueOf("1996-08-03 00:01:02")));
        }
    }

    private Void output(ResultSet resultSet) {
        try {
            this.output(resultSet, System.out);
        }
        catch (SQLException e) {
            throw TestUtil.rethrow((Throwable)e);
        }
        return null;
    }

    private static /* synthetic */ void lambda$expectUnordered$2(List expectedLines, ResultSet resultSet) {
        try {
            ArrayList<String> lines = new ArrayList<String>();
            TableTest.collect(lines, resultSet);
            Collections.sort(lines);
            Assert.assertEquals((Object)expectedLines, lines);
        }
        catch (SQLException e) {
            throw TestUtil.rethrow((Throwable)e);
        }
    }

    static class PropBuilder {
        final Properties properties = new Properties();

        PropBuilder() {
        }

        PropBuilder set(CalciteConnectionProperty p, String v) {
            this.properties.setProperty(p.camelName(), v);
            return this;
        }

        Properties build() {
            return this.properties;
        }
    }

    private class Fluent {
        private final String model;
        private final String sql;
        private final Consumer<ResultSet> expect;

        Fluent(String model, String sql, Consumer<ResultSet> expect) {
            this.model = model;
            this.sql = sql;
            this.expect = expect;
        }

        Fluent ok() {
            try {
                TableTest.this.checkSql(this.sql, this.model, this.expect);
                return this;
            }
            catch (SQLException e) {
                throw TestUtil.rethrow((Throwable)e);
            }
        }

        Fluent checking(Consumer<ResultSet> expect) {
            return new Fluent(this.model, this.sql, expect);
        }

        Fluent returns(String ... expectedLines) {
            return this.checking(TableTest.expect(expectedLines));
        }

        Fluent returnsUnordered(String ... expectedLines) {
            return this.checking(TableTest.expectUnordered(expectedLines));
        }
    }
}

