/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb.csv;

import au.com.bytecode.opencsv.CSVReader;
import io.kareldb.KarelDbEngine;
import io.kareldb.schema.ColumnDef;
import io.kareldb.schema.ColumnType;
import io.kareldb.schema.FilterableTable;
import io.kareldb.schema.RelDef;
import io.kareldb.schema.Schema;
import io.kareldb.schema.Table;
import io.kareldb.version.VersionedCache;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.calcite.avatica.util.Base64;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.model.ModelHandler;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.util.Source;
import org.apache.calcite.util.Sources;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.omid.transaction.Transaction;

public class CsvTable
extends FilterableTable {
    private final VersionedCache rows;
    private static final FastDateFormat TIME_FORMAT_DATE;
    private static final FastDateFormat TIME_FORMAT_TIME;
    private static final FastDateFormat TIME_FORMAT_TIMESTAMP;

    public CsvTable(Schema schema, String name, RelDef rowType) {
        super(schema, name, rowType);
        this.rows = new VersionedCache(name);
    }

    public VersionedCache getRows() {
        return this.rows;
    }

    public void init() {
        String fileName = (String)this.getConfigs().get("file");
        Source source = this.getSource(this.getConfigs(), fileName);
        if (source == null) {
            return;
        }
        RelDataType rowType = this.getRowType();
        Collection modifiableCollection = this.getModifiableCollection();
        try (CSVReader reader = CsvTable.openCsv(source);){
            Transaction tx = KarelDbEngine.getInstance().beginTx();
            reader.readNext();
            ArrayList columnDefs = new ArrayList(Schema.toColumnDefs((RelDataType)rowType).values());
            List<ColumnType> columnTypes = columnDefs.stream().map(ColumnDef::getColumnType).collect(Collectors.toList());
            RowConverter<?> rowConverter = CsvTable.converter(columnTypes);
            String[] strings = reader.readNext();
            while (strings != null) {
                Object row = rowConverter.convertRow(strings);
                modifiableCollection.add(row);
                strings = reader.readNext();
            }
            KarelDbEngine.getInstance().commitTx(tx);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void sync() {
    }

    private Source getSource(Map<String, ?> operand, String fileName) {
        File file;
        File base;
        if (fileName == null) {
            return null;
        }
        Path path = Paths.get(fileName, new String[0]);
        String directory = (String)operand.get("directory");
        if (directory != null) {
            path = Paths.get(directory, path.toString());
        }
        if ((base = (File)operand.get(ModelHandler.ExtraOperand.BASE_DIRECTORY.camelName)) != null) {
            path = Paths.get(base.getPath(), path.toString());
        }
        return (file = path.toFile()).exists() ? Sources.of((File)path.toFile()) : null;
    }

    private static CSVReader openCsv(Source source) throws IOException {
        Reader fileReader = source.reader();
        return new CSVReader(fileReader);
    }

    private static RowConverter<?> converter(List<ColumnType> fieldTypes) {
        int[] fields = Table.identityList((int)fieldTypes.size());
        if (fields.length == 1) {
            int field = fields[0];
            return new SingleColumnRowConverter(fieldTypes.get(field), field);
        }
        return new ArrayRowConverter(fieldTypes, fields);
    }

    public void close() {
    }

    static {
        TimeZone gmt = TimeZone.getTimeZone("GMT");
        TIME_FORMAT_DATE = FastDateFormat.getInstance((String)"yyyy-MM-dd", (TimeZone)gmt);
        TIME_FORMAT_TIME = FastDateFormat.getInstance((String)"HH:mm:ss", (TimeZone)gmt);
        TIME_FORMAT_TIMESTAMP = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss", (TimeZone)gmt);
    }

    private static class SingleColumnRowConverter
    extends RowConverter<Object> {
        private final ColumnType fieldType;
        private final int fieldIndex;

        private SingleColumnRowConverter(ColumnType fieldType, int fieldIndex) {
            this.fieldType = fieldType;
            this.fieldIndex = fieldIndex;
        }

        @Override
        public Object convertRow(String[] strings) {
            return this.convert(this.fieldType, strings[this.fieldIndex]);
        }
    }

    private static class ArrayRowConverter
    extends RowConverter<Object[]> {
        private final ColumnType[] fieldTypes;
        private final int[] fields;

        ArrayRowConverter(List<ColumnType> fieldTypes, int[] fields) {
            this.fieldTypes = fieldTypes.toArray(new ColumnType[0]);
            this.fields = fields;
        }

        @Override
        public Object[] convertRow(String[] strings) {
            Object[] objects = new Object[this.fields.length];
            for (int i = 0; i < this.fields.length; ++i) {
                int field = this.fields[i];
                objects[i] = this.convert(this.fieldTypes[field], strings[field]);
            }
            return objects;
        }
    }

    static abstract class RowConverter<E> {
        RowConverter() {
        }

        abstract E convertRow(String[] var1);

        protected Object convert(ColumnType fieldType, String string) {
            if (fieldType == null) {
                return string;
            }
            switch (fieldType) {
                case BOOLEAN: {
                    if (string.length() == 0) {
                        return null;
                    }
                    return Boolean.parseBoolean(string);
                }
                case INT: {
                    if (string.length() == 0) {
                        return null;
                    }
                    return Integer.parseInt(string);
                }
                case LONG: {
                    if (string.length() == 0) {
                        return null;
                    }
                    return Long.parseLong(string);
                }
                case FLOAT: {
                    if (string.length() == 0) {
                        return null;
                    }
                    return Float.valueOf(Float.parseFloat(string));
                }
                case DOUBLE: {
                    if (string.length() == 0) {
                        return null;
                    }
                    return Double.parseDouble(string);
                }
                case BYTES: {
                    if (string.length() == 0) {
                        return new ByteString(new byte[0]);
                    }
                    try {
                        return new ByteString(Base64.decode((String)string));
                    }
                    catch (IOException e) {
                        return null;
                    }
                }
                case DECIMAL: {
                    if (string.length() == 0) {
                        return null;
                    }
                    return new BigDecimal(string);
                }
                case DATE: {
                    if (string.length() == 0) {
                        return null;
                    }
                    try {
                        Date date = TIME_FORMAT_DATE.parse(string);
                        return (int)(date.getTime() / 86400000L);
                    }
                    catch (ParseException e) {
                        return null;
                    }
                }
                case TIME: {
                    if (string.length() == 0) {
                        return null;
                    }
                    try {
                        Date date = TIME_FORMAT_TIME.parse(string);
                        return (int)date.getTime();
                    }
                    catch (ParseException e) {
                        return null;
                    }
                }
                case TIMESTAMP: {
                    if (string.length() == 0) {
                        return null;
                    }
                    try {
                        Date date = TIME_FORMAT_TIMESTAMP.parse(string);
                        return date.getTime();
                    }
                    catch (ParseException e) {
                        return null;
                    }
                }
            }
            return string;
        }
    }
}

