/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb.csv;

import au.com.bytecode.opencsv.CSVReader;
import io.kareldb.csv.CsvTable;
import io.kareldb.schema.ColumnDef;
import io.kareldb.schema.ColumnType;
import io.kareldb.schema.RelDef;
import io.kareldb.schema.Schema;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.model.ModelHandler;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.schema.Table;
import org.apache.calcite.sql.ddl.SqlAlterTableExtension;
import org.apache.calcite.util.Source;
import org.apache.calcite.util.Sources;

public class CsvSchema
extends Schema {
    private final Map<String, Table> tableMap = new HashMap<String, Table>();
    private File directoryFile;

    public Map<String, Table> getTableMap() {
        return this.tableMap;
    }

    public void configure(Map<String, ?> operand) {
        super.configure(operand);
        String directory = (String)operand.get("directory");
        File base = (File)operand.get(ModelHandler.ExtraOperand.BASE_DIRECTORY.camelName);
        File directoryFile = new File(directory);
        if (base != null && !directoryFile.isAbsolute()) {
            directoryFile = new File(base, directory);
        }
        this.directoryFile = directoryFile;
    }

    public void init() {
        Source baseSource = Sources.of((File)this.directoryFile);
        File[] files = this.directoryFile.listFiles((dir, name) -> {
            String nameSansGz = CsvSchema.trim(name, ".gz");
            return nameSansGz.endsWith(".csv");
        });
        if (files == null) {
            System.out.println("directory " + this.directoryFile + " not found");
            files = new File[]{};
        }
        HashMap<String, Object> configs = new HashMap<String, Object>(this.getConfigs());
        for (File file : files) {
            Source source = Sources.of((File)file);
            Source sourceSansGz = source.trim(".gz");
            Source sourceSansCsv = sourceSansGz.trimOrNull(".csv");
            if (sourceSansCsv == null) continue;
            configs.put("file", source.file().getName());
            String name2 = sourceSansCsv.relative(baseSource).path();
            RelDataType rowType = CsvSchema.getRowType(source);
            List keyFields = Collections.singletonList(rowType.getFieldNames().get(0));
            RelDef relDef = new RelDef(rowType, keyFields, Collections.emptyList());
            this.createTable(name2, configs, relDef);
        }
    }

    public void sync() {
    }

    public io.kareldb.schema.Table createTable(String tableName, Map<String, Object> operand, RelDef rowType) {
        CsvTable table = new CsvTable(this, tableName, rowType);
        table.configure(operand != null ? operand : this.getConfigs());
        table.init();
        this.tableMap.put(tableName, (Table)table);
        return table;
    }

    public void alterTable(String tableName, List<SqlAlterTableExtension.Action> actions, RelDef rowType) {
        throw new UnsupportedOperationException();
    }

    public boolean dropTable(String tableName) {
        return this.tableMap.remove(tableName) != null;
    }

    public void close() {
    }

    private static String trim(String s, String suffix) {
        String trimmed = CsvSchema.trimOrNull(s, suffix);
        return trimmed != null ? trimmed : s;
    }

    private static String trimOrNull(String s, String suffix) {
        return s.endsWith(suffix) ? s.substring(0, s.length() - suffix.length()) : null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RelDataType getRowType(Source source) {
        try (CSVReader reader = CsvSchema.openCsv(source);){
            String[] strings = reader.readNext();
            LinkedHashMap<String, ColumnDef> types = CsvSchema.toColumnDefs(strings);
            RelDataType relDataType = Schema.toRowType(types, Collections.emptyList()).getRowType();
            return relDataType;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static CSVReader openCsv(Source source) throws IOException {
        Reader fileReader = source.reader();
        return new CSVReader(fileReader);
    }

    private static LinkedHashMap<String, ColumnDef> toColumnDefs(String[] strings) {
        LinkedHashMap<String, ColumnDef> columnDefs = new LinkedHashMap<String, ColumnDef>();
        if (strings == null) {
            strings = new String[]{"EmptyFileHasNoColumns:boolean"};
        }
        for (String string : strings) {
            ColumnDef columnDef;
            String name;
            int colon = string.indexOf(58);
            if (colon >= 0) {
                name = string.substring(0, colon);
                String typeString = string.substring(colon + 1);
                columnDef = new ColumnDef(ColumnType.of((String)typeString));
                if (columnDef == null) {
                    System.out.println("WARNING: Found unknown type: " + typeString + " in file:  for column: " + name + ". Will assume the type of column is string");
                }
            } else {
                name = string;
                columnDef = null;
            }
            columnDefs.put(name, columnDef);
        }
        if (columnDefs.isEmpty()) {
            columnDefs.put("line", null);
        }
        return columnDefs;
    }
}

