/*
 * Decompiled with CFR 0.152.
 */
package io.kanuka.generator;

import io.kanuka.ContextModule;
import io.kanuka.Factory;
import io.kanuka.core.DependencyMeta;
import io.kanuka.generator.BeanReader;
import io.kanuka.generator.MetaData;
import io.kanuka.generator.MetaDataOrdering;
import io.kanuka.generator.ProcessingContext;
import io.kanuka.generator.SimpleBeanWriter;
import io.kanuka.generator.SimpleFactoryWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.inject.Singleton;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

public class Processor
extends AbstractProcessor {
    private ProcessingContext processingContext;
    private Elements elementUtils;
    private Map<String, MetaData> metaData = new LinkedHashMap<String, MetaData>();
    private List<BeanReader> beanReaders = new ArrayList<BeanReader>();
    private Set<String> readBeans = new HashSet<String>();

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.RELEASE_8;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.processingContext = new ProcessingContext(processingEnv);
        this.elementUtils = processingEnv.getElementUtils();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> annotations = new LinkedHashSet<String>();
        annotations.add(ContextModule.class.getCanonicalName());
        annotations.add(Factory.class.getCanonicalName());
        annotations.add(Singleton.class.getCanonicalName());
        annotations.add("io.dinject.controller.Controller");
        return annotations;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<Object> controllers = Collections.emptySet();
        TypeElement typeElement = this.elementUtils.getTypeElement("io.dinject.controller.Controller");
        if (typeElement != null) {
            controllers = roundEnv.getElementsAnnotatedWith(typeElement);
        }
        Set<? extends Element> factoryBeans = roundEnv.getElementsAnnotatedWith(Factory.class);
        Set<? extends Element> beans = roundEnv.getElementsAnnotatedWith(Singleton.class);
        this.readModule(roundEnv);
        this.readChangedBeans(factoryBeans, true);
        this.readChangedBeans(beans, false);
        this.readChangedBeans(controllers, false);
        this.mergeMetaData();
        this.writeBeanHelpers();
        if (roundEnv.processingOver()) {
            this.writeBeanFactory();
        }
        return false;
    }

    private void writeBeanHelpers() {
        for (BeanReader beanReader : this.beanReaders) {
            try {
                if (beanReader.isWrittenToFile()) continue;
                SimpleBeanWriter writer = new SimpleBeanWriter(beanReader, this.processingContext);
                writer.write();
                beanReader.setWrittenToFile();
            }
            catch (FilerException e) {
                this.processingContext.logWarn("FilerException to write $di class " + beanReader.getBeanType() + " " + e.getMessage(), new Object[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.processingContext.logError(beanReader.getBeanType(), "Failed to write $di class", new Object[0]);
            }
        }
    }

    private void writeBeanFactory() {
        MetaDataOrdering ordering = new MetaDataOrdering(this.metaData.values(), this.processingContext);
        int remaining = ordering.processQueue();
        if (remaining > 0) {
            this.processingContext.logWarn("there are " + remaining + " beans with unsatisfied dependencies (assuming external dependencies)", new Object[0]);
            ordering.warnOnDependencies();
        }
        try {
            SimpleFactoryWriter factoryWriter = new SimpleFactoryWriter(ordering, this.processingContext);
            factoryWriter.write();
        }
        catch (FilerException e) {
            this.processingContext.logWarn("FilerException trying to write factory " + e.getMessage(), new Object[0]);
        }
        catch (IOException e) {
            this.processingContext.logError("Failed to write factory " + e.getMessage(), new Object[0]);
        }
    }

    private void readChangedBeans(Set<? extends Element> beans, boolean factory) {
        for (Element element : beans) {
            if (!(element instanceof TypeElement)) {
                this.processingContext.logError("unexpected type [" + element + "]", new Object[0]);
                continue;
            }
            if (this.readBeans.add(element.toString())) {
                this.readBeanMeta((TypeElement)element, factory);
                continue;
            }
            this.processingContext.logDebug("skipping already processed bean " + element, new Object[0]);
        }
    }

    private void mergeMetaData() {
        for (BeanReader beanReader : this.beanReaders) {
            String simpleName = beanReader.getSimpleName();
            MetaData metaData = this.metaData.get(simpleName);
            if (metaData == null) {
                this.addMeta(beanReader);
                continue;
            }
            this.updateMeta(metaData, beanReader);
        }
    }

    private void addMeta(BeanReader beanReader) {
        MetaData meta = beanReader.createMeta();
        this.metaData.put(meta.getType(), meta);
        for (MetaData methodMeta : beanReader.createFactoryMethodMeta()) {
            this.metaData.put(methodMeta.getType(), methodMeta);
        }
    }

    private void updateMeta(MetaData metaData, BeanReader beanReader) {
        metaData.update(beanReader);
    }

    private void readBeanMeta(TypeElement typeElement, boolean factory) {
        if (typeElement.getKind() == ElementKind.ANNOTATION_TYPE) {
            this.processingContext.logWarn("skipping annotation type " + typeElement, new Object[0]);
            return;
        }
        BeanReader beanReader = new BeanReader(typeElement, this.processingContext);
        beanReader.read(factory);
        this.beanReaders.add(beanReader);
    }

    private void readModule(RoundEnvironment roundEnv) {
        Element element;
        ContextModule annotation;
        Iterator<? extends Element> iterator;
        Set<? extends Element> elementsAnnotatedWith;
        TypeElement factoryType;
        String factory = this.processingContext.loadMetaInfServices();
        if (factory != null && (factoryType = this.elementUtils.getTypeElement(factory)) != null) {
            this.readFactory(factoryType);
        }
        if (!(elementsAnnotatedWith = roundEnv.getElementsAnnotatedWith(ContextModule.class)).isEmpty() && (iterator = elementsAnnotatedWith.iterator()).hasNext() && (annotation = (element = iterator.next()).getAnnotation(ContextModule.class)) != null) {
            this.processingContext.setContextDetails(annotation.name(), annotation.dependsOn(), element);
        }
    }

    private void readFactory(TypeElement factoryType) {
        ContextModule module = factoryType.getAnnotation(ContextModule.class);
        this.processingContext.setContextDetails(module.name(), module.dependsOn(), factoryType);
        List<? extends Element> elements = factoryType.getEnclosedElements();
        if (elements != null) {
            for (Element element : elements) {
                Name simpleName;
                ElementKind kind = element.getKind();
                if (ElementKind.METHOD != kind || !(simpleName = element.getSimpleName()).toString().startsWith("build")) continue;
                DependencyMeta meta = element.getAnnotation(DependencyMeta.class);
                if (meta == null) {
                    this.processingContext.logError("Missing @DependencyMeta on method " + simpleName.toString(), new Object[0]);
                    continue;
                }
                this.metaData.put(meta.type(), new MetaData(meta));
            }
        }
    }
}

