/*
 * Decompiled with CFR 0.152.
 */
package io.kanuka.generator;

import io.kanuka.generator.Append;
import io.kanuka.generator.MetaData;
import io.kanuka.generator.ProcessingContext;
import io.kanuka.generator.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.inject.Named;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

class MethodReader {
    private final ProcessingContext processingContext;
    private final ExecutableElement element;
    private final String factoryType;
    private final TypeMirror returnType;
    private final String returnTypeRaw;
    private final boolean isVoid;
    private final List<MethodParam> params = new ArrayList<MethodParam>();
    private final List<String> interfaceTypes = new ArrayList<String>();
    private final String factoryShortName;
    private final boolean isFactory;
    private String addForType;

    MethodReader(ProcessingContext processingContext, ExecutableElement element, TypeElement beanType, boolean isFactory) {
        this.isFactory = isFactory;
        this.processingContext = processingContext;
        this.element = element;
        this.returnType = element.getReturnType();
        this.returnTypeRaw = this.returnType.toString();
        this.factoryType = beanType.getQualifiedName().toString();
        this.factoryShortName = Util.shortName(this.factoryType);
        this.isVoid = this.returnTypeRaw.equals("void");
        this.initInterfaces();
    }

    private void initInterfaces() {
        Element element = this.processingContext.asElement(this.returnType);
        if (element instanceof TypeElement) {
            TypeElement te = (TypeElement)element;
            if (te.getKind() == ElementKind.INTERFACE) {
                this.interfaceTypes.add(te.getQualifiedName().toString());
            }
            for (TypeMirror typeMirror : te.getInterfaces()) {
                this.interfaceTypes.add(typeMirror.toString());
            }
            if (this.interfaceTypes.size() == 1) {
                this.addForType = this.interfaceTypes.get(0);
            }
        }
    }

    void read() {
        List<? extends VariableElement> ps = this.element.getParameters();
        for (VariableElement variableElement : ps) {
            this.params.add(new MethodParam(variableElement));
        }
    }

    List<MethodParam> getParams() {
        return this.params;
    }

    String getName() {
        return this.element.getSimpleName().toString();
    }

    MetaData createMeta() {
        MetaData metaData = new MetaData(this.returnTypeRaw);
        metaData.setMethod(this.fullBuildMethod());
        ArrayList<String> dependsOn = new ArrayList<String>(this.params.size() + 1);
        dependsOn.add(this.factoryType);
        for (MethodParam param : this.params) {
            dependsOn.add(param.paramType);
        }
        metaData.setDependsOn(dependsOn);
        metaData.setProvides(new ArrayList<String>());
        return metaData;
    }

    private String fullBuildMethod() {
        return this.factoryType + "$di.build_" + this.element.getSimpleName().toString();
    }

    String builderGetFactory() {
        return String.format("      %s factory = builder.get(%s.class);", this.factoryShortName, this.factoryShortName);
    }

    String builderBuildBean() {
        String methodName = this.element.getSimpleName().toString();
        StringBuilder sb = new StringBuilder();
        if (this.isVoid) {
            sb.append(String.format("      factory.%s(", methodName));
        } else {
            sb.append(String.format("      %s bean = factory.%s(", Util.shortName(this.returnTypeRaw), methodName));
        }
        for (int i = 0; i < this.params.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.params.get(i).builderGetDependency());
        }
        sb.append(");");
        return sb.toString();
    }

    void builderBuildAddBean(Append writer) {
        if (!this.isVoid) {
            writer.append("      builder.register(bean, null");
            for (String anInterface : this.interfaceTypes) {
                writer.append(", ").append(Util.shortName(anInterface)).append(".class");
            }
            writer.append(");").eol();
        }
    }

    void addImports(Set<String> importTypes) {
        for (MethodParam param : this.params) {
            param.addImports(importTypes);
        }
        if (this.isFactory) {
            importTypes.add(this.returnTypeRaw);
        }
    }

    void buildAddFor(Append writer) {
        writer.append("    if (builder.isAddBeanFor(");
        if (this.addForType != null) {
            writer.append(this.addForType).append(".class, ");
        }
        if (this.isVoid) {
            writer.append("Void.class)) {").eol();
        } else {
            writer.append(Util.shortName(this.returnTypeRaw)).append(".class)) {").eol();
        }
    }

    static class MethodParam {
        private final String rawType;
        private final String named;
        private final boolean listType;
        private final boolean optionalType;
        private final String paramType;

        MethodParam(VariableElement p) {
            TypeMirror type = p.asType();
            this.rawType = type.toString();
            this.named = this.readNamed(p);
            this.listType = Util.isList(this.rawType);
            boolean bl = this.optionalType = !this.listType && Util.isOptional(this.rawType);
            this.paramType = this.optionalType ? Util.extractOptionalType(this.rawType) : (this.listType ? Util.extractList(this.rawType) : this.rawType);
        }

        private String readNamed(VariableElement p) {
            Named named = p.getAnnotation(Named.class);
            return named == null ? null : named.value();
        }

        String builderGetDependency() {
            StringBuilder sb = new StringBuilder();
            if (this.listType) {
                sb.append("builder.getList(");
            } else if (this.optionalType) {
                sb.append("builder.getOptional(");
            } else {
                sb.append("builder.get(");
            }
            sb.append(Util.shortName(this.paramType)).append(".class");
            if (this.named != null) {
                sb.append(",\"").append(this.named).append("\"");
            }
            sb.append(")");
            return sb.toString();
        }

        String getDependsOn() {
            return this.paramType;
        }

        void addImports(Set<String> importTypes) {
            importTypes.add(this.paramType);
        }
    }
}

