/*
 * Decompiled with CFR 0.152.
 */
package io.kanuka.generator;

import io.kanuka.Bean;
import io.kanuka.Factory;
import io.kanuka.generator.Append;
import io.kanuka.generator.FieldReader;
import io.kanuka.generator.MetaData;
import io.kanuka.generator.MethodReader;
import io.kanuka.generator.ProcessingContext;
import io.kanuka.generator.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Generated;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

class BeanReader {
    private static Set<String> EXCLUDED_ANNOTATIONS = new HashSet<String>();
    private final TypeElement beanType;
    private final ProcessingContext processingContext;
    private final String shortName;
    private String name;
    private MethodReader injectConstructor;
    private final List<MethodReader> otherConstructors = new ArrayList<MethodReader>();
    private List<MethodReader> factoryMethods = new ArrayList<MethodReader>();
    private Element postConstructMethod;
    private Element preDestroyMethod;
    private final List<FieldReader> injectFields = new ArrayList<FieldReader>();
    private final List<String> interfaceTypes = new ArrayList<String>();
    private String addForType;
    private Set<String> importTypes = new TreeSet<String>();
    private MethodReader constructor;
    private String registrationTypes;
    private boolean writtenToFile;

    BeanReader(TypeElement beanType, ProcessingContext processingContext) {
        this.beanType = beanType;
        this.shortName = beanType.getSimpleName().toString();
        this.processingContext = processingContext;
        this.initInterfaces();
        this.initAddFor();
    }

    private void initAddFor() {
        if (this.interfaceTypes.size() == 1) {
            this.addForType = Util.shortName(Util.unwrapProvider(this.interfaceTypes.get(0)));
        }
    }

    private void initInterfaces() {
        StringBuilder sb = new StringBuilder();
        for (TypeMirror typeMirror : this.beanType.getInterfaces()) {
            String type = Util.unwrapProvider(typeMirror.toString());
            this.interfaceTypes.add(type);
            this.importTypes.add(type);
            sb.append(", ").append(Util.shortName(type)).append(".class");
        }
        for (AnnotationMirror annotationMirror : this.beanType.getAnnotationMirrors()) {
            String annotationType = annotationMirror.getAnnotationType().toString();
            if (!this.includeAnnotation(annotationType)) continue;
            this.importTypes.add(annotationType);
            sb.append(", ").append(Util.shortName(annotationType)).append(".class");
        }
        this.registrationTypes = sb.toString();
    }

    TypeElement getBeanType() {
        return this.beanType;
    }

    String getName() {
        return this.name;
    }

    Element getPostConstructMethod() {
        return this.postConstructMethod;
    }

    Element getPreDestroyMethod() {
        return this.preDestroyMethod;
    }

    List<FieldReader> getInjectFields() {
        return this.injectFields;
    }

    void read(boolean factory) {
        this.readNamed();
        for (Element element : this.beanType.getEnclosedElements()) {
            ElementKind kind = element.getKind();
            switch (kind) {
                case CONSTRUCTOR: {
                    this.readConstructor(element);
                    break;
                }
                case FIELD: {
                    this.readField(element);
                    break;
                }
                case METHOD: {
                    this.readMethod(element, factory);
                }
            }
        }
        this.constructor = this.findConstructor();
        if (this.constructor != null) {
            this.constructor.addImports(this.importTypes);
        }
        for (MethodReader methodReader : this.factoryMethods) {
            methodReader.addImports(this.importTypes);
        }
    }

    private MethodReader findConstructor() {
        if (this.injectConstructor != null) {
            return this.injectConstructor;
        }
        if (this.otherConstructors.size() == 1) {
            return this.otherConstructors.get(0);
        }
        return null;
    }

    List<String> getDependsOn() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.constructor != null) {
            for (MethodReader.MethodParam param : this.constructor.getParams()) {
                list.add(param.getDependsOn());
            }
        }
        return list;
    }

    List<MethodReader> getFactoryMethods() {
        return this.factoryMethods;
    }

    List<String> getInterfaces() {
        return this.interfaceTypes;
    }

    String getInterfacesAndAnnotations() {
        return this.registrationTypes;
    }

    private boolean includeAnnotation(String annotationType) {
        return !EXCLUDED_ANNOTATIONS.contains(annotationType);
    }

    private void readNamed() {
        Named named = this.beanType.getAnnotation(Named.class);
        if (named != null) {
            this.name = named.value();
        }
    }

    private void readConstructor(Element element) {
        ExecutableElement ex = (ExecutableElement)element;
        MethodReader methodReader = new MethodReader(this.processingContext, ex, this.beanType, false);
        methodReader.read();
        Inject inject = element.getAnnotation(Inject.class);
        if (inject != null) {
            this.injectConstructor = methodReader;
        } else {
            this.otherConstructors.add(methodReader);
        }
    }

    private void readField(Element element) {
        Inject inject = element.getAnnotation(Inject.class);
        if (inject != null) {
            this.injectFields.add(new FieldReader(element));
        }
    }

    private void readMethod(Element element, boolean factory) {
        PreDestroy pdMarker;
        PostConstruct pcMarker;
        Bean beanMarker;
        ExecutableElement methodElement = (ExecutableElement)element;
        if (factory && (beanMarker = element.getAnnotation(Bean.class)) != null) {
            this.addFactoryMethod(methodElement);
        }
        if ((pcMarker = element.getAnnotation(PostConstruct.class)) != null) {
            this.postConstructMethod = element;
        }
        if ((pdMarker = element.getAnnotation(PreDestroy.class)) != null) {
            this.preDestroyMethod = element;
        }
    }

    private void addFactoryMethod(ExecutableElement methodElement) {
        MethodReader methodReader = new MethodReader(this.processingContext, methodElement, this.beanType, true);
        methodReader.read();
        this.factoryMethods.add(methodReader);
    }

    String getSimpleName() {
        return this.beanType.getSimpleName().toString();
    }

    boolean isLifecycleRequired() {
        return this.postConstructMethod != null || this.preDestroyMethod != null;
    }

    List<MetaData> createFactoryMethodMeta() {
        if (this.factoryMethods.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<MetaData> metaList = new ArrayList<MetaData>(this.factoryMethods.size());
        for (MethodReader factoryMethod : this.factoryMethods) {
            metaList.add(factoryMethod.createMeta());
        }
        return metaList;
    }

    MetaData createMeta() {
        MetaData metaData = new MetaData(this.beanType.getQualifiedName().toString());
        metaData.update(this);
        return metaData;
    }

    boolean isFieldInjectionRequired() {
        return !this.injectFields.isEmpty();
    }

    void buildAddFor(Append writer) {
        writer.append("    if (builder.isAddBeanFor(");
        if (this.addForType != null) {
            writer.append(this.addForType).append(".class, ");
        }
        writer.append(this.shortName).append(".class)) {").eol();
    }

    private Set<String> importTypes() {
        if (this.isLifecycleRequired()) {
            this.importTypes.add("io.kanuka.core.BeanLifecycle");
        }
        this.importTypes.add("javax.annotation.Generated");
        this.importTypes.add("io.kanuka.core.Builder");
        this.importTypes.add(this.beanType.getQualifiedName().toString());
        return this.importTypes;
    }

    void writeImports(Append writer) {
        for (String importType : this.importTypes()) {
            writer.append("import %s;", importType).eol();
        }
        writer.eol();
    }

    MethodReader getConstructor() {
        return this.constructor;
    }

    boolean isWrittenToFile() {
        return this.writtenToFile;
    }

    void setWrittenToFile() {
        this.writtenToFile = true;
    }

    static {
        EXCLUDED_ANNOTATIONS.add(Singleton.class.getName());
        EXCLUDED_ANNOTATIONS.add(Named.class.getName());
        EXCLUDED_ANNOTATIONS.add(Factory.class.getName());
        EXCLUDED_ANNOTATIONS.add(Generated.class.getName());
        EXCLUDED_ANNOTATIONS.add("kotlin.Metadata");
        EXCLUDED_ANNOTATIONS.add("io.dinject.controller.Path");
    }
}

