/*
 * Decompiled with CFR 0.152.
 */
package io.kanuka.generator;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import javax.annotation.processing.Filer;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

class ProcessingContext {
    private static final String META_INF_FACTORY = "META-INF/services/io.kanuka.core.BeanContextFactory";
    private final ProcessingEnvironment processingEnv;
    private final Messager messager;
    private final Filer filer;
    private final Elements elementUtils;
    private final Types typeUtils;
    private String contextName;
    private String[] contextDependsOn;
    private String contextPackage;
    private String metaInfServicesLine;

    ProcessingContext(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
        this.messager = processingEnv.getMessager();
        this.filer = processingEnv.getFiler();
        this.elementUtils = processingEnv.getElementUtils();
        this.typeUtils = processingEnv.getTypeUtils();
    }

    void logError(Element e, String msg, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format(msg, args), e);
    }

    void logError(String msg, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format(msg, args));
    }

    void logWarn(String msg, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.WARNING, String.format(msg, args));
    }

    void logDebug(String msg, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.NOTE, String.format(msg, args));
    }

    String loadMetaInfServices() {
        if (this.metaInfServicesLine == null) {
            this.metaInfServicesLine = this.loadMetaInf();
        }
        return this.metaInfServicesLine;
    }

    private String loadMetaInf() {
        try {
            Reader reader;
            LineNumberReader lineReader;
            String line;
            FileObject fileObject = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", META_INF_FACTORY);
            if (fileObject != null && (line = (lineReader = new LineNumberReader(reader = fileObject.openReader(true))).readLine()) != null) {
                return line.trim();
            }
        }
        catch (FileNotFoundException fileObject) {
        }
        catch (FilerException e) {
            this.logDebug("FilerException reading services file", new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logWarn("Error reading services file: " + e.getMessage(), new Object[0]);
        }
        return null;
    }

    JavaFileObject createWriter(String cls, Element origin) throws IOException {
        return this.filer.createSourceFile(cls, origin);
    }

    FileObject createMetaInfWriter() throws IOException {
        return this.filer.createResource(StandardLocation.CLASS_OUTPUT, "", META_INF_FACTORY, new Element[0]);
    }

    void setContextDetails(String name, String[] dependsOn, Element contextElement) {
        this.contextName = name;
        this.contextDependsOn = dependsOn;
        PackageElement pkg = this.elementUtils.getPackageOf(contextElement);
        this.logWarn("using package from element " + pkg, new Object[0]);
        this.contextPackage = pkg == null ? null : pkg.getQualifiedName().toString();
    }

    String getContextName() {
        return this.contextName;
    }

    String[] getContextDependsOn() {
        return this.contextDependsOn;
    }

    String getContextPackage() {
        return this.contextPackage;
    }

    Element asElement(TypeMirror returnType) {
        return this.typeUtils.asElement(returnType);
    }
}

