/*
 * Decompiled with CFR 0.152.
 */
package io.kanuka.generator;

import io.kanuka.generator.Util;
import javax.inject.Named;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;

class FieldReader {
    private final Element element;
    private final String name;

    FieldReader(Element element) {
        this.element = element;
        this.name = this.readName();
    }

    private String readName() {
        Named named = this.element.getAnnotation(Named.class);
        return named == null ? null : named.value();
    }

    String getFieldName() {
        return this.element.getSimpleName().toString();
    }

    String builderGetDependency() {
        boolean optionalType;
        TypeMirror type = this.element.asType();
        String rawType = type.toString();
        boolean listType = Util.isList(rawType);
        boolean bl = optionalType = !listType && Util.isOptional(rawType);
        if (optionalType) {
            rawType = Util.extractOptionalType(rawType);
        } else if (listType) {
            rawType = Util.extractList(rawType);
        }
        StringBuilder sb = new StringBuilder();
        if (listType) {
            sb.append("b.getList(");
        } else if (optionalType) {
            sb.append("b.getOptional(");
        } else {
            sb.append("b.get(");
        }
        sb.append(rawType).append(".class");
        if (this.name != null) {
            sb.append(",\"").append(this.name).append("\"");
        }
        sb.append(")");
        return sb.toString();
    }
}

