/*
 * Decompiled with CFR 0.152.
 */
package io.kanuka.generator;

import io.kanuka.core.DependencyMeta;
import io.kanuka.generator.BeanReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class MetaData {
    private static final String NEWLINE = "\n";
    private final String type;
    private String method;
    private boolean wired;
    private List<String> provides;
    private List<String> dependsOn;

    MetaData(DependencyMeta meta) {
        this.type = meta.type();
        this.method = meta.method();
        this.provides = this.asList(meta.provides());
        this.dependsOn = this.asList(meta.dependsOn());
    }

    MetaData(String type) {
        this.type = type;
        this.provides = new ArrayList<String>();
        this.dependsOn = new ArrayList<String>();
    }

    boolean noDepends() {
        return this.dependsOn == null || this.dependsOn.isEmpty();
    }

    boolean isWired() {
        return this.wired;
    }

    void setWired() {
        this.wired = true;
    }

    private List<String> asList(String[] content) {
        if (content == null || content.length == 0) {
            return new ArrayList<String>();
        }
        return Arrays.asList(content);
    }

    void update(BeanReader beanReader) {
        this.provides = beanReader.getInterfaces();
        this.dependsOn = beanReader.getDependsOn();
    }

    String getType() {
        return this.type;
    }

    List<String> getProvides() {
        return this.provides;
    }

    List<String> getDependsOn() {
        return this.dependsOn;
    }

    String getTopPackage() {
        if (this.method == null || this.method.isEmpty()) {
            return this.trimPackage(this.type);
        }
        return null;
    }

    private boolean higherPackage(String interfacePackage, String topPackage) {
        if (interfacePackage.length() > topPackage.length()) {
            return false;
        }
        return topPackage.startsWith(interfacePackage);
    }

    private String trimPackage(String cls) {
        int pos = cls.lastIndexOf(46);
        return pos == -1 ? "" : cls.substring(0, pos);
    }

    String getShortType() {
        int pos = this.type.lastIndexOf(46);
        return pos == -1 ? this.type : this.type.substring(pos + 1);
    }

    String buildMethod() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("  @DependencyMeta(type=\"").append(this.type).append("\"");
        if (this.method != null && !this.method.isEmpty()) {
            sb.append(", method=\"").append(this.method).append("\"");
        }
        if (!this.provides.isEmpty()) {
            this.appendProvides(sb, "provides", this.provides);
        }
        if (!this.dependsOn.isEmpty()) {
            this.appendProvides(sb, "dependsOn", this.dependsOn);
        }
        sb.append(")").append(NEWLINE);
        sb.append("  protected void build").append(this.getShortType()).append("() {").append(NEWLINE);
        if (this.method == null || this.method.isEmpty()) {
            sb.append("    ").append(this.type).append("$di.build(builder);").append(NEWLINE);
        } else {
            sb.append("    ").append(this.method).append("(builder);").append(NEWLINE);
        }
        sb.append("  }").append(NEWLINE);
        return sb.toString();
    }

    private void appendProvides(StringBuilder sb, String attribute, List<String> types) {
        sb.append(",").append(attribute).append("={");
        for (int i = 0; i < types.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("\"");
            sb.append(types.get(i));
            sb.append("\"");
        }
        sb.append("}");
    }

    void setProvides(List<String> provides) {
        this.provides = provides;
    }

    void setDependsOn(List<String> dependsOn) {
        this.dependsOn = dependsOn;
    }

    void setMethod(String method) {
        this.method = method;
    }
}

