/*
 * Decompiled with CFR 0.152.
 */
package io.kanuka.generator;

import io.kanuka.Bean;
import io.kanuka.Factory;
import io.kanuka.generator.FieldReader;
import io.kanuka.generator.MetaData;
import io.kanuka.generator.MethodReader;
import io.kanuka.generator.ProcessingContext;
import io.kanuka.generator.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

class BeanReader {
    private final TypeElement beanType;
    private final ProcessingContext processingContext;
    private String name;
    private MethodReader injectConstructor;
    private final List<MethodReader> otherConstructors = new ArrayList<MethodReader>();
    private List<MethodReader> factoryMethods = new ArrayList<MethodReader>();
    private Element postConstructMethod;
    private Element preDestroyMethod;
    private String providerParamType;
    private final List<FieldReader> injectFields = new ArrayList<FieldReader>();
    private final List<String> interfaceTypes = new ArrayList<String>();

    BeanReader(TypeElement beanType, ProcessingContext processingContext) {
        this.beanType = beanType;
        this.processingContext = processingContext;
        this.initInterfaces();
    }

    private void initInterfaces() {
        for (TypeMirror typeMirror : this.beanType.getInterfaces()) {
            this.interfaceTypes.add(this.checkProvider(typeMirror.toString()));
        }
    }

    private String checkProvider(String interfaceType) {
        if (Util.isProvider(interfaceType)) {
            this.providerParamType = Util.extractProviderType(interfaceType);
        }
        return interfaceType;
    }

    TypeElement getBeanType() {
        return this.beanType;
    }

    String getName() {
        return this.name;
    }

    Element getPostConstructMethod() {
        return this.postConstructMethod;
    }

    Element getPreDestroyMethod() {
        return this.preDestroyMethod;
    }

    List<FieldReader> getInjectFields() {
        return this.injectFields;
    }

    void read(boolean factory) {
        this.readNamed();
        for (Element element : this.beanType.getEnclosedElements()) {
            ElementKind kind = element.getKind();
            switch (kind) {
                case CONSTRUCTOR: {
                    this.readConstructor(element);
                    break;
                }
                case FIELD: {
                    this.readField(element);
                    break;
                }
                case METHOD: {
                    this.readMethod(element, factory);
                }
            }
        }
    }

    List<String> getDependsOn() {
        ArrayList<String> list = new ArrayList<String>();
        MethodReader methodReader = this.obtainConstructor();
        if (methodReader != null) {
            List<MethodReader.MethodParam> params = methodReader.getParams();
            for (MethodReader.MethodParam param : params) {
                list.add(param.getDependsOn());
            }
        }
        return list;
    }

    List<MethodReader> getFactoryMethods() {
        return this.factoryMethods;
    }

    List<String> getInterfaces() {
        return this.interfaceTypes;
    }

    String getIsAddBeanFor() {
        if (this.interfaceTypes.size() == 1) {
            return this.interfaceTypes.get(0);
        }
        return this.beanType.getQualifiedName().toString();
    }

    String getInterfacesAndAnnotations() {
        StringBuilder sb = new StringBuilder();
        for (String string : this.interfaceTypes) {
            sb.append(",\"").append(string).append("\"");
        }
        for (AnnotationMirror annotationMirror : this.beanType.getAnnotationMirrors()) {
            String annotationType = annotationMirror.getAnnotationType().toString();
            if (!this.includeAnnotation(annotationType)) continue;
            sb.append(",\"").append(annotationType).append("\"");
        }
        return sb.toString();
    }

    private boolean includeAnnotation(String annotationType) {
        return !Singleton.class.getName().equals(annotationType) && !Named.class.getName().equals(annotationType) && !Factory.class.getName().equals(annotationType);
    }

    private void readNamed() {
        Named named = this.beanType.getAnnotation(Named.class);
        if (named != null) {
            this.name = named.value();
        }
    }

    private void readConstructor(Element element) {
        ExecutableElement ex = (ExecutableElement)element;
        MethodReader methodReader = new MethodReader(this.processingContext, ex, this.beanType);
        methodReader.read();
        Inject inject = element.getAnnotation(Inject.class);
        if (inject != null) {
            this.injectConstructor = methodReader;
        } else {
            this.otherConstructors.add(methodReader);
        }
    }

    private void readField(Element element) {
        Inject inject = element.getAnnotation(Inject.class);
        if (inject != null) {
            this.injectFields.add(new FieldReader(element));
        }
    }

    private void readMethod(Element element, boolean factory) {
        PreDestroy pdMarker;
        PostConstruct pcMarker;
        Bean beanMarker;
        ExecutableElement methodElement = (ExecutableElement)element;
        if (factory && (beanMarker = element.getAnnotation(Bean.class)) != null) {
            this.addFactoryMethod(methodElement);
        }
        if (this.providerParamType != null && this.isProviderMethod(methodElement)) {
            this.addFactoryMethod(methodElement);
        }
        if ((pcMarker = element.getAnnotation(PostConstruct.class)) != null) {
            this.postConstructMethod = element;
        }
        if ((pdMarker = element.getAnnotation(PreDestroy.class)) != null) {
            this.preDestroyMethod = element;
        }
    }

    private void addFactoryMethod(ExecutableElement methodElement) {
        MethodReader methodReader = new MethodReader(this.processingContext, methodElement, this.beanType);
        methodReader.read();
        this.factoryMethods.add(methodReader);
    }

    private boolean isProviderMethod(ExecutableElement methodElement) {
        return this.providerParamType.equals(methodElement.getReturnType().toString()) && "get".equals(methodElement.getSimpleName().toString());
    }

    String getSimpleName() {
        return this.beanType.getSimpleName().toString();
    }

    boolean isLifecycleRequired() {
        return this.postConstructMethod != null || this.preDestroyMethod != null;
    }

    List<MetaData> createFactoryMethodMeta() {
        if (this.factoryMethods.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<MetaData> metaList = new ArrayList<MetaData>(this.factoryMethods.size());
        for (MethodReader factoryMethod : this.factoryMethods) {
            metaList.add(factoryMethod.createMeta());
        }
        return metaList;
    }

    MetaData createMeta() {
        MetaData metaData = new MetaData(this.beanType.getQualifiedName().toString());
        metaData.update(this);
        return metaData;
    }

    MethodReader obtainConstructor() {
        if (this.injectConstructor != null) {
            return this.injectConstructor;
        }
        if (this.otherConstructors.size() == 1) {
            return this.otherConstructors.get(0);
        }
        return null;
    }

    boolean isFieldInjectionRequired() {
        return !this.injectFields.isEmpty();
    }
}

