/*
 * Decompiled with CFR 0.152.
 */
package io.kanuka.generator;

import io.kanuka.generator.Append;
import io.kanuka.generator.MetaData;
import io.kanuka.generator.MetaDataOrdering;
import io.kanuka.generator.ProcessingContext;
import java.io.IOException;
import java.io.Writer;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;

class SimpleFactoryWriter {
    private final MetaDataOrdering ordering;
    private final ProcessingContext processingContext;
    private final String factoryPackage;
    private final String factoryShortName;
    private final String factoryFullName;
    private final String contextName;
    private Append writer;

    SimpleFactoryWriter(MetaDataOrdering ordering, ProcessingContext processingContext) {
        this.ordering = ordering;
        this.processingContext = processingContext;
        this.factoryPackage = ordering.getTopPackage();
        this.contextName = this.deriveContextName();
        this.factoryShortName = "_di$Factory";
        this.factoryFullName = this.factoryPackage + "." + this.factoryShortName;
    }

    private String deriveContextName() {
        String name = this.processingContext.getContextName();
        return name != null ? name : this.factoryPackage;
    }

    void write() throws IOException {
        this.writer = new Append(this.createFileWriter());
        this.writePackage();
        this.writeStartClass();
        this.writeCreateMethod();
        this.writeBuildMethods();
        this.writeEndClass();
        this.writer.close();
        this.writeServicesFile();
    }

    private void writeServicesFile() {
        try {
            FileObject jfo = this.processingContext.createMetaInfWriter();
            if (jfo != null) {
                Writer writer = jfo.openWriter();
                writer.write(this.factoryFullName);
                writer.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.processingContext.logError("Failed to write services file " + e.getMessage(), new Object[0]);
        }
    }

    private void writeBuildMethods() {
        for (MetaData metaData : this.ordering.getOrdered()) {
            this.writer.append(metaData.buildMethod()).eol();
        }
    }

    private void writeCreateMethod() {
        this.writer.append("  @Override").eol();
        this.writer.append("  public BeanContext createContext(Builder parent) {").eol();
        this.writer.append("    builder.setParent(parent);").eol();
        for (MetaData metaData : this.ordering.getOrdered()) {
            this.writer.append("    build%s();", metaData.getShortType()).eol();
        }
        this.writer.append("    return builder.build();").eol();
        this.writer.append("  }").eol();
        this.writer.eol();
    }

    private void writePackage() {
        this.writer.append("package %s;", this.factoryPackage).eol().eol();
        this.writer.append("import io.kanuka.BeanContext;").eol();
        this.writer.append("import io.kanuka.ContextModule;").eol();
        this.writer.append("import io.kanuka.core.BeanContextFactory;").eol();
        this.writer.append("import io.kanuka.core.BuilderFactory;").eol();
        this.writer.append("import io.kanuka.core.Builder;").eol();
        this.writer.append("import io.kanuka.core.DependencyMeta;").eol();
        this.writer.eol();
    }

    private void writeStartClass() {
        String dependsAnnotation = "";
        String dependsBuilder = "";
        String dependsOn = this.moduleDependsOn();
        if (dependsOn != null) {
            dependsAnnotation = " ,dependsOn = {" + dependsOn + "}";
            dependsBuilder = "," + dependsOn;
        }
        this.writer.append("@ContextModule(name=\"%s\"%s)", this.contextName, dependsAnnotation).eol();
        this.writer.append("public class %s implements BeanContextFactory {", this.factoryShortName).eol().eol();
        this.writer.append("  private final Builder builder;").eol().eol();
        this.writer.append("  public %s() {", this.factoryShortName).eol();
        this.writer.append("    this.builder = BuilderFactory.newBuilder(\"%s\"%s);", this.contextName, dependsBuilder).eol();
        this.writer.append("  }").eol().eol();
        this.writer.append("  @Override").eol();
        this.writer.append("  public String getName() {").eol();
        this.writer.append("    return builder.getName();").eol();
        this.writer.append("  }").eol().eol();
        this.writer.append("  @Override").eol();
        this.writer.append("  public String[] getDependsOn() {").eol();
        this.writer.append("    return builder.getDependsOn();").eol();
        this.writer.append("  }").eol().eol();
    }

    private String moduleDependsOn() {
        String[] contextDependsOn = this.processingContext.getContextDependsOn();
        if (contextDependsOn == null || contextDependsOn.length == 0) {
            return null;
        }
        StringBuilder dependsOn = new StringBuilder();
        int c = 0;
        for (String moduleDependency : contextDependsOn) {
            if (c > 0) {
                dependsOn.append(",");
            }
            dependsOn.append("\"").append(moduleDependency).append("\"");
        }
        return dependsOn.toString();
    }

    private void writeEndClass() {
        this.writer.append("}").eol();
    }

    private Writer createFileWriter() throws IOException {
        JavaFileObject jfo = this.processingContext.createWriter(this.factoryFullName, null);
        return jfo.openWriter();
    }
}

