/*
 * Decompiled with CFR 0.152.
 */
package io.kanuka.generator;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

class ProcessingContext {
    private static final String META_INF_FACTORY = "META-INF/services/io.kanuka.core.BeanContextFactory";
    private final ProcessingEnvironment processingEnv;
    private final Messager messager;
    private final Filer filer;
    private String contextName;
    private String[] contextDependsOn;

    ProcessingContext(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
        this.messager = processingEnv.getMessager();
        this.filer = processingEnv.getFiler();
    }

    void logError(Element e, String msg, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format(msg, args), e);
    }

    void logError(String msg, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format(msg, args));
    }

    void logWarn(String msg, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.WARNING, String.format(msg, args));
    }

    void logDebug(String msg, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.NOTE, String.format(msg, args));
    }

    String loadMetaInfServices() {
        try {
            Reader reader;
            LineNumberReader lineReader;
            String line;
            FileObject fileObject = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", META_INF_FACTORY);
            if (fileObject != null && (line = (lineReader = new LineNumberReader(reader = fileObject.openReader(true))).readLine()) != null) {
                return line.trim();
            }
        }
        catch (FileNotFoundException e) {
            this.logDebug("no services file yet", new Object[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logError("Error reading services file: " + e.getMessage(), new Object[0]);
        }
        return null;
    }

    JavaFileObject createWriter(String cls, Element origin) throws IOException {
        return this.filer.createSourceFile(cls, origin);
    }

    FileObject createMetaInfWriter() throws IOException {
        return this.filer.createResource(StandardLocation.CLASS_OUTPUT, "", META_INF_FACTORY, new Element[0]);
    }

    void setContextDetails(String name, String[] dependsOn) {
        this.contextName = name;
        this.contextDependsOn = dependsOn;
    }

    public String getContextName() {
        return this.contextName;
    }

    public String[] getContextDependsOn() {
        return this.contextDependsOn;
    }
}

