/*
 * Decompiled with CFR 0.152.
 */
package io.kanuka.generator;

import io.kanuka.generator.MetaData;
import io.kanuka.generator.Util;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Named;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

class MethodReader {
    private final ExecutableElement element;
    private final String factoryType;
    private final String returnTypeRaw;
    private final List<MethodParam> params = new ArrayList<MethodParam>();

    MethodReader(ExecutableElement element, TypeElement beanType) {
        this.element = element;
        this.returnTypeRaw = element.getReturnType().toString();
        this.factoryType = beanType.getQualifiedName().toString();
    }

    void read() {
        List<? extends VariableElement> ps = this.element.getParameters();
        for (VariableElement variableElement : ps) {
            this.params.add(new MethodParam(variableElement.asType(), this.readNamed(variableElement)));
        }
    }

    private String readNamed(VariableElement p) {
        Named named = p.getAnnotation(Named.class);
        return named == null ? null : named.value();
    }

    List<MethodParam> getParams() {
        return this.params;
    }

    String getName() {
        return this.element.getSimpleName().toString();
    }

    MetaData createMeta() {
        MetaData metaData = new MetaData(this.returnTypeRaw);
        metaData.setMethod(this.fullBuildMethod());
        ArrayList<String> dependsOn = new ArrayList<String>(this.params.size() + 1);
        dependsOn.add(this.factoryType);
        for (MethodParam param : this.params) {
            dependsOn.add(param.paramType);
        }
        metaData.setDependsOn(dependsOn);
        metaData.setProvides(new ArrayList<String>());
        return metaData;
    }

    private String fullBuildMethod() {
        return this.factoryType + "$di.build_" + this.element.getSimpleName().toString();
    }

    String builderGetFactory() {
        return String.format("      %s factory = builder.get(%s.class);", this.factoryType, this.factoryType);
    }

    String builderBuildBean() {
        String methodName = this.element.getSimpleName().toString();
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("      %s bean = factory.%s(", this.returnTypeRaw, methodName));
        for (int i = 0; i < this.params.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.params.get(i).builderGetDependency());
        }
        sb.append(");");
        return sb.toString();
    }

    String builderDebugCurrentMethod() {
        String methodName = this.element.toString();
        return String.format("      builder.currentBean(\"%s\");", this.returnTypeRaw + " via " + methodName);
    }

    String getIsAddBeanFor() {
        return this.returnTypeRaw;
    }

    static class MethodParam {
        private final String rawType;
        private final String named;
        private final boolean listType;
        private final boolean optionalType;
        private final String paramType;

        MethodParam(TypeMirror type, String named) {
            this.rawType = type.toString();
            this.named = named;
            this.listType = Util.isList(this.rawType);
            boolean bl = this.optionalType = !this.listType && Util.isOptional(this.rawType);
            this.paramType = this.optionalType ? Util.extractOptionalType(this.rawType) : (this.listType ? Util.extractList(this.rawType) : this.rawType);
        }

        String builderGetDependency() {
            StringBuilder sb = new StringBuilder();
            if (this.listType) {
                sb.append("builder.getList(");
            } else if (this.optionalType) {
                sb.append("builder.getOptional(");
            } else {
                sb.append("builder.get(");
            }
            sb.append(this.paramType).append(".class");
            if (this.named != null) {
                sb.append(",\"").append(this.named).append("\"");
            }
            sb.append(")");
            return sb.toString();
        }

        String getDependsOn() {
            return this.paramType;
        }
    }
}

