/*
 * Decompiled with CFR 0.152.
 */
package io.kanuka.generator;

import io.kanuka.generator.MetaData;
import io.kanuka.generator.ProcessingContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class MetaDataOrdering {
    private final ProcessingContext processingContext;
    private final List<MetaData> orderedList = new ArrayList<MetaData>();
    private final List<MetaData> queue = new ArrayList<MetaData>();
    private final Map<String, ProviderList> providers = new HashMap<String, ProviderList>();
    private String topPackage;

    MetaDataOrdering(Collection<MetaData> values, ProcessingContext processingContext) {
        this.processingContext = processingContext;
        for (MetaData metaData : values) {
            if (metaData.noDepends()) {
                this.orderedList.add(metaData);
                metaData.setWired();
            } else {
                this.queue.add(metaData);
            }
            String aPackage = metaData.getTopPackage();
            if (this.topPackage == null || aPackage.length() < this.topPackage.length()) {
                this.topPackage = aPackage;
            }
            this.providers.computeIfAbsent(metaData.getType(), s -> new ProviderList()).add(metaData);
            for (String provide : metaData.getProvides()) {
                this.providers.computeIfAbsent(provide, s -> new ProviderList()).add(metaData);
            }
        }
    }

    int processQueue() {
        int count;
        while ((count = this.processQueueRound()) > 0) {
        }
        int remaining = this.queue.size();
        if (remaining != 0) {
            this.orderedList.addAll(this.queue);
        }
        return remaining;
    }

    void warnOnDependencies() {
        for (MetaData m : this.queue) {
            this.processingContext.logWarn("unsatisfied dependencies on %s dependsOn %s", m.getType(), m.getDependsOn());
        }
    }

    String getTopPackage() {
        return this.topPackage;
    }

    private int processQueueRound() {
        int count = 0;
        Iterator<MetaData> iterator = this.queue.iterator();
        while (iterator.hasNext()) {
            MetaData queuedMeta = iterator.next();
            if (!this.allDependenciesWired(queuedMeta)) continue;
            this.orderedList.add(queuedMeta);
            queuedMeta.setWired();
            iterator.remove();
            ++count;
        }
        return count;
    }

    private boolean allDependenciesWired(MetaData queuedMeta) {
        for (String dependency : queuedMeta.getDependsOn()) {
            ProviderList providerList = this.providers.get(dependency);
            if (providerList == null) {
                return false;
            }
            if (providerList.isAllWired()) continue;
            return false;
        }
        return true;
    }

    List<MetaData> getOrdered() {
        return this.orderedList;
    }

    private static class ProviderList {
        private List<MetaData> list = new ArrayList<MetaData>();

        private ProviderList() {
        }

        void add(MetaData beanMeta) {
            this.list.add(beanMeta);
        }

        boolean isAllWired() {
            for (MetaData metaData : this.list) {
                if (metaData.isWired()) continue;
                return false;
            }
            return true;
        }
    }
}

