package io.julian.mvp;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.widget.SwipeRefreshLayout;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import io.julian.common.widget.LoadingLayout;

import static android.view.ViewGroup.LayoutParams.MATCH_PARENT;

/**
 * Loading-Content-View
 *
 * @author Zhu Liang
 */

public abstract class BaseLceFragment<M, V extends View, P extends BaseLcePresenter> extends BaseFragment<P> implements BaseLceView<M, P> {

    private SwipeRefreshLayout mRefreshLayout;
    protected V mContentView;

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        LoadingLayout loadingLayout = new LoadingLayout(getContext());
        loadingLayout.setLayoutParams(new ViewGroup.LayoutParams(MATCH_PARENT, MATCH_PARENT));
        mRefreshLayout = new SwipeRefreshLayout(getContext());
        mRefreshLayout.setLayoutParams(new ViewGroup.LayoutParams(MATCH_PARENT, MATCH_PARENT));
        loadingLayout.addView(mRefreshLayout);
        mRefreshLayout.addView(mContentView = createContentView());
        mContentView.setLayoutParams(new ViewGroup.LayoutParams(MATCH_PARENT, MATCH_PARENT));
        mRefreshLayout.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener() {
            @Override
            public void onRefresh() {
                mPresenter.loadData(true);
            }
        });
        return loadingLayout;
    }

    @Override
    public void setLoadingIndicator(final boolean active) {
        if (getView() == null) return;
        LoadingLayout loadingLayout = (LoadingLayout) getView();
        loadingLayout.setStatus(LoadingLayout.SUCCESS);
        mRefreshLayout.post(new Runnable() {
            @Override
            public void run() {
                mRefreshLayout.setRefreshing(active);
            }
        });
    }

    @Override
    public void showContent(M data) {
        if (getView() == null) return;
        LoadingLayout loadingLayout = (LoadingLayout) getView();
        loadingLayout.setStatus(LoadingLayout.SUCCESS);
    }

    protected abstract V createContentView();
}
