package io.julian.mvp;

import android.support.v4.app.Fragment;

import io.julian.common.Preconditions;

public abstract class BaseFragment<P extends BasePresenter> extends Fragment implements BaseView<P> {
    protected P mPresenter;

    @Override
    public void onResume() {
        super.onResume();
        mPresenter.subscribe();
    }

    @Override
    public void onPause() {
        super.onPause();
        mPresenter.unsubscribe();
    }

    @Override
    public final void setPresenter(P presenter) {
        mPresenter = Preconditions.checkNotNull(presenter);
    }
}
