package io.julian.mvp;

import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;

import io.julian.common.Preconditions;

public abstract class BaseDialogFragment<P extends BasePresenter> extends DialogFragment implements BaseDialogView<P> {
    protected P mPresenter;

    @Override
    public void onResume() {
        super.onResume();
        mPresenter.subscribe();
    }

    @Override
    public void onPause() {
        super.onPause();
        mPresenter.unsubscribe();
    }

    @Override
    public final void setPresenter(P presenter) {
        mPresenter = Preconditions.checkNotNull(presenter);
    }

    @Override
    public void dismissDialog() {
        dismiss();
    }
}
