/*
 * Decompiled with CFR 0.152.
 */
package io.jstack.sendcloud4j.mail;

import io.jstack.sendcloud4j.mail.Email;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Result {
    private static Logger logger = LoggerFactory.getLogger(Result.class);
    private boolean success = false;
    private int statusCode;
    private String message;
    private String responseText;

    protected Result(String responseText) {
        this.responseText = responseText;
        this.parserResponseText(responseText);
    }

    protected static Result createExceptionResult(Email email, Throwable throwable) {
        logger.error("Send mail fail, request params: {}", email.getParameters(), (Object)throwable);
        return new Result(false, 500, throwable.getMessage());
    }

    protected Result(boolean success, int statusCode, String message) {
        this.success = success;
        this.statusCode = statusCode;
        this.message = message;
    }

    protected void parserResponseText(String responseJson) {
        JSONObject jsonObject = new JSONObject(responseJson);
        if (jsonObject.has("result")) {
            this.success = jsonObject.getBoolean("result");
        }
        if (jsonObject.has("message")) {
            this.message = jsonObject.getString("message");
        }
        if (jsonObject.has("statusCode")) {
            this.statusCode = jsonObject.getInt("statusCode");
        }
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return this.responseText;
    }
}

