/*
 * Decompiled with CFR 0.152.
 */
package io.jstack.sendcloud4j.mail;

import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Result {
    private static Logger logger = LoggerFactory.getLogger(Result.class);
    private String message;
    private List<String> errors;
    private String json;

    public Result(String jsonStr) {
        this.json = jsonStr;
        JSONObject jsonObj = new JSONObject(jsonStr);
        this.message = jsonObj.getString("message");
        try {
            JSONArray jsonErrors = jsonObj.getJSONArray("errors");
            if (jsonErrors.length() > 0) {
                this.errors = new ArrayList<String>();
            }
            for (int i = 0; i < jsonErrors.length(); ++i) {
                this.errors.add(jsonErrors.getString(i));
            }
        }
        catch (JSONException ex) {
            logger.debug("no error field");
        }
    }

    public Result(String message, String error) {
        this.message = message;
        if (null != error) {
            this.errors = new ArrayList<String>();
            this.errors.add(error);
        }
    }

    public boolean isSuccess() {
        return CODE.SUCCESS.equals(this.message);
    }

    public String getError() {
        if (null == this.errors) {
            return "";
        }
        if (this.errors.isEmpty()) {
            return "";
        }
        if (1 == this.errors.size()) {
            return this.errors.get(0).toString();
        }
        StringBuilder bufErrors = new StringBuilder();
        for (String error : this.errors) {
            bufErrors.append(error).append(";");
        }
        return bufErrors.toString();
    }

    public String getMessage() {
        return this.message;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public String toString() {
        return this.json;
    }

    public static class CODE {
        public static String ERROR = "error";
        public static String SUCCESS = "success";
    }
}

