/*
 * Decompiled with CFR 0.152.
 */
package io.jstack.sendcloud4j.mail;

import io.jstack.sendcloud4j.mail.GeneralEmail;
import io.jstack.sendcloud4j.mail.TemplateEmail;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Email<E extends Email<E>> {
    protected Map<String, String> parameters = new HashMap<String, String>();
    private boolean isRewrite = false;

    public static GeneralEmail general() {
        return new GeneralEmail();
    }

    public static TemplateEmail template(String template) {
        return new TemplateEmail(template);
    }

    public E from(String from) {
        return this.addParameter("from", from);
    }

    public E fromName(String fromName) {
        return this.addParameter("fromName", fromName);
    }

    public E subject(String subject) {
        return this.addParameter("subject", subject);
    }

    public E replyTo(String replyTo) {
        return this.addParameter("replyTo", replyTo);
    }

    public E to(String to) {
        if (this.isNotBlank(to)) {
            this.to(to.split(";"));
        } else {
            this.addParameter("to", null);
        }
        return this.getThis();
    }

    public E to(String[] toAddrs) {
        return this.addParameters("to", toAddrs, ";");
    }

    protected String[] to() {
        return this.getParameters("to", ";");
    }

    public E labelId(int labelid) {
        return this.addParameter("labelId", labelid);
    }

    public E headers(String headers) {
        return this.addParameter("headers", headers);
    }

    public E notRespEmailId() {
        return this.addParameter("respEmailId", false);
    }

    public E useNotification() {
        return this.addParameter("useNotification", true);
    }

    protected E addParameters(String name, String[] values, String sep) {
        StringBuffer bufValue = new StringBuffer();
        if (values != null && values.length > 0) {
            String origValue = this.getParameter(name);
            if (this.isNotBlank(origValue)) {
                bufValue.append(origValue);
            }
            for (String value : values) {
                if (!this.isNotBlank(value)) continue;
                if (bufValue.length() > 0) {
                    bufValue.append(sep);
                }
                bufValue.append(value);
            }
        }
        return this.addParameter(name, bufValue.toString());
    }

    protected E addParameter(String name, Object value) {
        String strValue = String.valueOf(value);
        if (value == null || !this.isNotBlank(strValue)) {
            this.parameters.remove(name);
        } else {
            this.parameters.put(name, String.valueOf(value));
        }
        return this.getThis();
    }

    protected String getParameter(String name) {
        return this.parameters.get(name);
    }

    protected String[] getParameters(String name, String sep) {
        String values = this.parameters.get(name);
        return this.isNotBlank(values) ? values.split(sep) : new String[]{};
    }

    protected final Map<String, String> getParameters() {
        if (!this.isRewrite) {
            this.rewriteParameters();
        }
        this.isRewrite = true;
        return this.parameters;
    }

    private boolean isNotBlank(String value) {
        return value != null && value.trim().length() > 0;
    }

    protected void rewriteParameters() {
    }

    protected abstract E getThis();
}

