/*
 * Decompiled with CFR 0.152.
 */
package io.jsondb.crypto;

import io.jsondb.JsonDBException;
import io.jsondb.crypto.ICipher;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.AEADBadTagException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class Default1Cipher
implements ICipher {
    private static final String ENCRYPTION_ALGORITHM = "AES";
    private static final String MODE_ALGORITHM = "GCM";
    private static final String PADDING_ALGORITHM = "NoPadding";
    private static final String PROVIDER = "SunJCE";
    private static final String CIPHER_ALGORITHM = "AES/GCM/NoPadding";
    private static final int IV_SIZE = 16;
    private static final int TAG_SIZE = 128;
    private static final SecureRandom rnd = Default1Cipher.createNewSecureRandom();
    private final Charset charset;
    private final SecretKeySpec key;

    private static final SecureRandom createNewSecureRandom() {
        try {
            return SecureRandom.getInstance("NativePRNGNonBlocking");
        }
        catch (NoSuchAlgorithmException e) {
            try {
                return SecureRandom.getInstance("SHA1PRNG");
            }
            catch (NoSuchAlgorithmException e2) {
                return new SecureRandom();
            }
        }
    }

    public Default1Cipher(String base64CodedEncryptionKey) throws GeneralSecurityException {
        this(Base64.getDecoder().decode(base64CodedEncryptionKey), StandardCharsets.UTF_8);
    }

    public Default1Cipher(byte[] encryptionKey) throws GeneralSecurityException {
        this(encryptionKey, StandardCharsets.UTF_8);
    }

    public Default1Cipher(String base64CodedEncryptionKey, Charset charset) throws GeneralSecurityException {
        this(Base64.getDecoder().decode(base64CodedEncryptionKey), charset);
    }

    public Default1Cipher(byte[] encryptionKey, Charset charset) throws GeneralSecurityException {
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        if (encryptionKey == null) {
            throw new NullPointerException("encryptionKey");
        }
        this.charset = charset;
        this.key = new SecretKeySpec(encryptionKey, ENCRYPTION_ALGORITHM);
    }

    @Override
    public String encrypt(String plainText) {
        try {
            byte[] iv = new byte[16];
            rnd.nextBytes(iv);
            Cipher enc = Cipher.getInstance(CIPHER_ALGORITHM, PROVIDER);
            enc.init(1, (Key)this.key, new GCMParameterSpec(128, iv));
            byte[] input = plainText.getBytes(this.charset);
            int sizeReq = 16 + enc.getOutputSize(input.length);
            byte[] output = new byte[sizeReq];
            ByteBuffer store = ByteBuffer.wrap(output);
            store.put(iv);
            int extra = enc.doFinal(input, 0, input.length, output, 16);
            store.position(store.position() + extra);
            store.flip();
            ByteBuffer bb = Base64.getEncoder().encode(store);
            return new String(bb.array(), 0, bb.limit(), StandardCharsets.US_ASCII);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new JsonDBException("Default cipher cannot be used on this VM installation", e);
        }
        catch (InvalidKeyException e) {
            throw new JsonDBException("Invalid key", e);
        }
        catch (BadPaddingException | ShortBufferException e) {
            throw new JsonDBException("Unexpected (bug?) crypto error", e);
        }
    }

    @Override
    public String decrypt(String cipherText) {
        byte[] in = Base64.getDecoder().decode(cipherText);
        try {
            Cipher dec = Cipher.getInstance(CIPHER_ALGORITHM, PROVIDER);
            dec.init(2, (Key)this.key, new GCMParameterSpec(128, in, 0, 16));
            return new String(dec.doFinal(in, 16, in.length - 16), this.charset);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new JsonDBException("Default cipher cannot be used on this VM installation", e);
        }
        catch (InvalidKeyException e) {
            throw new JsonDBException("Invalid key", e);
        }
        catch (AEADBadTagException e) {
            throw new JsonDBException("Incorrect key for this ciphertext (or ciphertext is corrupted)", e);
        }
        catch (InvalidAlgorithmParameterException | BadPaddingException e) {
            throw new JsonDBException("Unexpected (bug?) crypto error", e);
        }
    }
}

