/*
 * Decompiled with CFR 0.152.
 */
package io.jschneider.graphql.gremlin.entity;

import io.jschneider.graphql.gremlin.entity.GraphQLEntity;
import io.jschneider.graphql.gremlin.entity.GraphQLRelationEntity;
import io.jschneider.graphql.gremlin.field.GraphQLField;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.PathProcessor;
import org.apache.tinkerpop.gremlin.process.traversal.step.Scoping;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MapStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalRing;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class GraphQLEntitySelectStep<S, E>
extends MapStep<S, Map<String, E>>
implements Scoping,
TraversalParent,
PathProcessor {
    private TraversalRing<Object, E> traversalRing = new TraversalRing(new Traversal.Admin[0]);
    private GraphQLEntity entity;

    public GraphQLEntitySelectStep(Traversal.Admin traversal, GraphQLEntity entity) {
        super(traversal);
        this.entity = entity;
    }

    protected Map<String, E> map(Traverser.Admin<S> traverser) {
        Object end;
        LinkedHashMap<String, Object> bindings = new LinkedHashMap<String, Object>();
        for (GraphQLField field : this.entity.flattenedFields()) {
            if (field.isSkipped()) continue;
            end = this.getNullableScopeValue(null, field.getFieldAlias(), traverser);
            if (null != end) {
                bindings.put(field.getQueryAlias() == null ? field.getFieldName() : field.getQueryAlias(), TraversalUtil.apply((Object)end, (Traversal.Admin)this.traversalRing.next()));
                continue;
            }
            this.traversalRing.reset();
            return null;
        }
        for (GraphQLRelationEntity child : this.entity.flattenedChildEntities()) {
            if (child.isSkipped()) continue;
            end = this.getNullableScopeValue(null, child.getRelationAlias(), traverser);
            if (null != end) {
                bindings.put(child.getRelationName(), TraversalUtil.apply((Object)end, (Traversal.Admin)this.traversalRing.next()));
                continue;
            }
            this.traversalRing.reset();
            return null;
        }
        this.traversalRing.reset();
        return bindings;
    }

    public void reset() {
        super.reset();
        this.traversalRing.reset();
    }

    public String toString() {
        ArrayList selectKeys = new ArrayList();
        selectKeys.addAll(this.entity.flattenedFields().stream().map((? super T field) -> field.getFieldAlias() + " as " + field.getFieldName() + (field.getQueryAlias() != null ? " a.k.a. " + field.getQueryAlias() : "")).collect(Collectors.toList()));
        selectKeys.addAll(this.entity.flattenedChildEntities().stream().map((? super T child) -> child.getRelationAlias() + " as " + child.getRelationName()).collect(Collectors.toList()));
        return StringFactory.stepString((Step)this, (Object[])new Object[]{null, selectKeys, this.traversalRing});
    }

    public GraphQLEntitySelectStep<S, E> clone() {
        GraphQLEntitySelectStep clone = (GraphQLEntitySelectStep)super.clone();
        clone.traversalRing = this.traversalRing.clone();
        clone.getLocalChildren().forEach(arg_0 -> ((GraphQLEntitySelectStep)clone).integrateChild(arg_0));
        return clone;
    }

    public int hashCode() {
        return super.hashCode() ^ this.traversalRing.hashCode() ^ this.getScopeKeys().hashCode();
    }

    public List<Traversal.Admin<Object, E>> getLocalChildren() {
        return this.traversalRing.getTraversals();
    }

    public void addLocalChild(Traversal.Admin<?, ?> selectTraversal) {
        this.traversalRing.addTraversal(this.integrateChild(selectTraversal));
    }

    public Set<TraverserRequirement> getRequirements() {
        Set<String> selectKeys = this.getScopeKeys();
        return this.getSelfAndChildRequirements(TraversalHelper.getLabels((Traversal.Admin)TraversalHelper.getRootTraversal((Traversal.Admin)this.traversal)).stream().filter(selectKeys::contains).findAny().isPresent() ? TYPICAL_GLOBAL_REQUIREMENTS_ARRAY : TYPICAL_LOCAL_REQUIREMENTS_ARRAY);
    }

    public Set<String> getScopeKeys() {
        TreeSet<String> scopeKeys = new TreeSet<String>();
        scopeKeys.addAll(this.entity.getFields().stream().map(GraphQLField::getFieldName).collect(Collectors.toList()));
        scopeKeys.addAll(this.entity.flattenedChildEntities().stream().map(GraphQLRelationEntity::getRelationName).collect(Collectors.toList()));
        return scopeKeys;
    }
}

